/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.sniff.Sniffer;
import org.opensearch.client.sniff.SnifferBuilder;
import org.opensearch.spring.boot.autoconfigure.OpenSearchConnectionDetails;
import org.opensearch.spring.boot.autoconfigure.OpenSearchProperties;
import org.opensearch.spring.boot.autoconfigure.RestClientBuilderCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

class OpenSearchRestClientConfigurations {
    OpenSearchRestClientConfigurations() {
    }

    private static class ConnectionsDetailsCredentialsProvider
    extends BasicCredentialsProvider {
        ConnectionsDetailsCredentialsProvider(OpenSearchConnectionDetails connectionDetails) {
            if (StringUtils.hasText((String)connectionDetails.getUsername())) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(connectionDetails.getUsername(), connectionDetails.getPassword());
                this.setCredentials(AuthScope.ANY, (Credentials)credentials);
            }
            connectionDetails.getUris().stream().map(this::toUri).filter(this::hasUserInfo).forEach(this::addUserInfoCredentials);
        }

        private URI toUri(String uri) {
            try {
                return URI.create(uri);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }

        private boolean hasUserInfo(URI uri) {
            return uri != null && StringUtils.hasLength((String)uri.getUserInfo());
        }

        private void addUserInfoCredentials(URI uri) {
            AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
            Credentials credentials = this.createUserInfoCredentials(uri.getUserInfo());
            this.setCredentials(authScope, credentials);
        }

        private Credentials createUserInfoCredentials(String userInfo) {
            int delimiter = userInfo.indexOf(":");
            if (delimiter == -1) {
                return new UsernamePasswordCredentials(userInfo, null);
            }
            String username = userInfo.substring(0, delimiter);
            String password = userInfo.substring(delimiter + 1);
            return new UsernamePasswordCredentials(username, password);
        }
    }

    static class DefaultRestClientBuilderCustomizer
    implements RestClientBuilderCustomizer {
        private static final PropertyMapper map = PropertyMapper.get();
        private final OpenSearchProperties properties;
        private final OpenSearchConnectionDetails connectionDetails;
        private final ObjectProvider<SslBundles> sslBundles;

        DefaultRestClientBuilderCustomizer(OpenSearchProperties properties, OpenSearchConnectionDetails connectionDetails, ObjectProvider<SslBundles> sslBundles) {
            this.properties = properties;
            this.connectionDetails = connectionDetails;
            this.sslBundles = sslBundles;
        }

        @Override
        public void customize(RestClientBuilder builder) {
        }

        @Override
        public void customize(HttpAsyncClientBuilder builder) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)new ConnectionsDetailsCredentialsProvider(this.connectionDetails));
            map.from(this.properties::isSocketKeepAlive).to(keepAlive -> builder.setDefaultIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(keepAlive.booleanValue()).build()));
            String sslBundleName = this.properties.getRestclient().getSsl().getBundle();
            if (StringUtils.hasText((String)sslBundleName)) {
                this.configureSsl(builder, ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName));
            }
        }

        @Override
        public void customize(RequestConfig.Builder builder) {
            map.from(this.properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RequestConfig.Builder)builder).setConnectTimeout(arg_0));
            map.from(this.properties::getSocketTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RequestConfig.Builder)builder).setSocketTimeout(arg_0));
        }

        private void configureSsl(HttpAsyncClientBuilder builder, SslBundle sslBundle) {
            SSLContext sslcontext = sslBundle.createSslContext();
            SslOptions sslOptions = sslBundle.getOptions();
            builder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslcontext, sslOptions.getEnabledProtocols(), sslOptions.getCiphers(), (HostnameVerifier)null));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Sniffer.class})
    @ConditionalOnSingleCandidate(value=RestClient.class)
    static class RestClientSnifferConfiguration {
        RestClientSnifferConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Sniffer opensearchSniffer(RestClient client, OpenSearchProperties properties) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            Duration interval = properties.getRestclient().getSniffer().getInterval();
            map.from((Object)interval).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffIntervalMillis(arg_0));
            Duration delayAfterFailure = properties.getRestclient().getSniffer().getDelayAfterFailure();
            map.from((Object)delayAfterFailure).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffAfterFailureDelayMillis(arg_0));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={RestClient.class})
    static class RestClientConfiguration {
        RestClientConfiguration() {
        }

        @Bean
        RestClient opensearchRestClient(RestClientBuilder restClientBuilder) {
            return restClientBuilder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={RestClientBuilder.class})
    static class RestClientBuilderConfiguration {
        private final OpenSearchConnectionDetails connectionDetails;

        RestClientBuilderConfiguration(OpenSearchConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
        }

        @Bean
        RestClientBuilderCustomizer defaultRestClientBuilderCustomizer(OpenSearchProperties properties, ObjectProvider<SslBundles> sslBundles) {
            return new DefaultRestClientBuilderCustomizer(properties, this.connectionDetails, sslBundles);
        }

        @Bean
        RestClientBuilder opensearchRestClientBuilder(ObjectProvider<RestClientBuilderCustomizer> builderCustomizers) {
            HttpHost[] hosts = (HttpHost[])this.connectionDetails.getUris().stream().map(this::createHttpHost).toArray(HttpHost[]::new);
            RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(httpClientBuilder));
                return httpClientBuilder;
            });
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(requestConfigBuilder));
                return requestConfigBuilder;
            });
            if (this.connectionDetails.getPathPrefix() != null) {
                builder.setPathPrefix(this.connectionDetails.getPathPrefix());
            }
            builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        private HttpHost createHttpHost(String uri) {
            try {
                return this.createHttpHost(URI.create(uri));
            }
            catch (IllegalArgumentException ex) {
                return HttpHost.create((String)uri);
            }
        }

        private HttpHost createHttpHost(URI uri) {
            if (!StringUtils.hasLength((String)uri.getUserInfo())) {
                return HttpHost.create((String)uri.toString());
            }
            try {
                return HttpHost.create((String)new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString());
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

