/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure;

import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.data.client.orhlc.AbstractOpenSearchConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;

class OpenSearchRestHighLevelClientConfigurations {
    OpenSearchRestHighLevelClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={RestClientBuilder.class})
    @ConditionalOnMissingBean(name={"elasticsearchOperations", "elasticsearchTemplate", "opensearchTemplate"})
    static class RestHighLevelClientConfiguration
    extends AbstractOpenSearchConfiguration {
        private final RestClientBuilder restClientBuilder;

        RestHighLevelClientConfiguration(RestClientBuilder restClientBuilder) {
            this.restClientBuilder = restClientBuilder;
        }

        public RestHighLevelClient opensearchClient() {
            return new RestHighLevelClient(this.restClientBuilder);
        }

        @Bean
        @ConditionalOnMissingBean
        public ElasticsearchCustomConversions elasticsearchCustomConversions() {
            return super.elasticsearchCustomConversions();
        }
    }
}

