/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.GetIndexTemplatesRequest;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.IndexTemplatesExistRequest;
import org.opensearch.client.indices.PutIndexTemplateRequest;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.data.client.orhlc.OpenSearchRestTemplate;
import org.opensearch.data.client.orhlc.RequestFactory;
import org.opensearch.data.client.orhlc.ResponseConverter;
import org.springframework.data.elasticsearch.core.AbstractIndexTemplate;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class RestIndexTemplate
extends AbstractIndexTemplate
implements IndexOperations {
    private static final Log LOGGER = LogFactory.getLog(RestIndexTemplate.class);
    private final OpenSearchRestTemplate restTemplate;
    protected final RequestFactory requestFactory;

    public RestIndexTemplate(OpenSearchRestTemplate restTemplate, Class<?> boundClass) {
        super(restTemplate.getElasticsearchConverter(), boundClass);
        this.restTemplate = restTemplate;
        this.requestFactory = new RequestFactory(this.elasticsearchConverter);
    }

    public RestIndexTemplate(OpenSearchRestTemplate restTemplate, IndexCoordinates boundIndex) {
        super(restTemplate.getElasticsearchConverter(), boundIndex);
        this.restTemplate = restTemplate;
        this.requestFactory = new RequestFactory(this.elasticsearchConverter);
    }

    protected boolean doCreate(IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        CreateIndexRequest request = this.requestFactory.createIndexRequest(index, settings, mapping);
        return this.restTemplate.execute(client -> client.indices().create(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    protected boolean doDelete(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        if (this.doExists(index)) {
            DeleteIndexRequest deleteIndexRequest = this.requestFactory.deleteIndexRequest(index);
            return this.restTemplate.execute(client -> client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT).isAcknowledged());
        }
        return false;
    }

    protected boolean doExists(IndexCoordinates index) {
        GetIndexRequest getIndexRequest = this.requestFactory.getIndexRequest(index);
        return this.restTemplate.execute(client -> client.indices().exists(getIndexRequest, RequestOptions.DEFAULT));
    }

    protected boolean doPutMapping(IndexCoordinates index, Document mapping) {
        Assert.notNull((Object)index, (String)"No index defined for putMapping()");
        PutMappingRequest request = this.requestFactory.putMappingRequest(index, mapping);
        return this.restTemplate.execute(client -> client.indices().putMapping(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    protected Map<String, Object> doGetMapping(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for doGetMapping()");
        GetMappingsRequest mappingsRequest = this.requestFactory.getMappingsRequest(index);
        return this.restTemplate.execute(client -> {
            Map mappings = client.indices().getMapping(mappingsRequest, RequestOptions.DEFAULT).mappings();
            if (mappings == null || mappings.size() == 0) {
                return Collections.emptyMap();
            }
            if (mappings.size() > 1) {
                LOGGER.warn((Object)("more than one mapping returned for " + index.getIndexName()));
            }
            return ((MappingMetadata)mappings.entrySet().iterator().next().getValue()).getSourceAsMap();
        });
    }

    protected Map<String, Set<AliasData>> doGetAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = this.requestFactory.getAliasesRequest(aliasNames, indexNames);
        return this.restTemplate.execute(client -> ResponseConverter.aliasDatas(client.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT).getAliases()));
    }

    public boolean alias(AliasActions aliasActions) {
        IndicesAliasesRequest request = this.requestFactory.indicesAliasesRequest(aliasActions);
        return this.restTemplate.execute(client -> client.indices().updateAliases(request, RequestOptions.DEFAULT).isAcknowledged());
    }

    protected Settings doGetSettings(IndexCoordinates index, boolean includeDefaults) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetSettingsRequest getSettingsRequest = this.requestFactory.getSettingsRequest(index, includeDefaults);
        GetSettingsResponse response = this.restTemplate.execute(client -> client.indices().getSettings(getSettingsRequest, RequestOptions.DEFAULT));
        return ResponseConverter.fromSettingsResponse(response, getSettingsRequest.indices()[0]);
    }

    protected void doRefresh(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for refresh()");
        RefreshRequest refreshRequest = this.requestFactory.refreshRequest(index);
        this.restTemplate.execute(client -> client.indices().refresh(refreshRequest, RequestOptions.DEFAULT));
    }

    public boolean putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutIndexTemplateRequest putIndexTemplateRequest = this.requestFactory.putIndexTemplateRequest(putTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().putTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT).isAcknowledged());
    }

    public TemplateData getTemplate(GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        if (!this.existsTemplate(new ExistsTemplateRequest(getTemplateRequest.getTemplateName()))) {
            return null;
        }
        GetIndexTemplatesRequest getIndexTemplatesRequest = this.requestFactory.getIndexTemplatesRequest(getTemplateRequest);
        GetIndexTemplatesResponse getIndexTemplatesResponse = this.restTemplate.execute(client -> client.indices().getIndexTemplate(getIndexTemplatesRequest, RequestOptions.DEFAULT));
        return ResponseConverter.getTemplateData(getIndexTemplatesResponse, getTemplateRequest.getTemplateName());
    }

    public boolean existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        IndexTemplatesExistRequest putIndexTemplateRequest = this.requestFactory.indexTemplatesExistsRequest(existsTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().existsTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT));
    }

    public boolean deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = this.requestFactory.deleteIndexTemplateRequest(deleteTemplateRequest);
        return this.restTemplate.execute(client -> client.indices().deleteTemplate(deleteIndexTemplateRequest, RequestOptions.DEFAULT).isAcknowledged());
    }

    public List<IndexInformation> getInformation(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetIndexRequest request = this.requestFactory.getIndexRequest(index);
        return this.restTemplate.execute(client -> {
            GetIndexResponse getIndexResponse = client.indices().get(request, RequestOptions.DEFAULT);
            return ResponseConverter.getIndexInformations(getIndexResponse);
        });
    }
}

