/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.common.text.Text;
import org.opensearch.data.client.orhlc.DocumentAdapters;
import org.opensearch.data.client.orhlc.OpenSearchAggregations;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.term.TermSuggestion;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.PhraseSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.SortBy;
import org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion;
import org.springframework.data.elasticsearch.support.ScoreDoc;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchDocumentResponseBuilder {
    private static final Log LOGGER = LogFactory.getLog(SearchDocumentResponse.class);

    public static <T> SearchDocumentResponse from(SearchResponse searchResponse, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        Assert.notNull((Object)searchResponse, (String)"searchResponse must not be null");
        SearchHits searchHits = searchResponse.getHits();
        String scrollId = searchResponse.getScrollId();
        Aggregations aggregations = searchResponse.getAggregations();
        Suggest suggest = searchResponse.getSuggest();
        return SearchDocumentResponseBuilder.from(searchHits, scrollId, aggregations, suggest, entityCreator);
    }

    public static <T> SearchDocumentResponse from(SearchHits searchHits, @Nullable String scrollId, @Nullable Aggregations aggregations, @Nullable Suggest suggestOS, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        String totalHitsRelation;
        long totalHits;
        TotalHits responseTotalHits = searchHits.getTotalHits();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value;
            totalHitsRelation = responseTotalHits.relation.name();
        } else {
            totalHits = searchHits.getHits().length;
            totalHitsRelation = "OFF";
        }
        float maxScore = searchHits.getMaxScore();
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (SearchHit searchHit : searchHits) {
            if (searchHit == null) continue;
            searchDocuments.add(DocumentAdapters.from(searchHit));
        }
        OpenSearchAggregations aggregationsContainer = aggregations != null ? new OpenSearchAggregations(aggregations) : null;
        org.springframework.data.elasticsearch.core.suggest.response.Suggest suggest = SearchDocumentResponseBuilder.suggestFrom(suggestOS, entityCreator);
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, null, searchDocuments, (AggregationsContainer)aggregationsContainer, suggest);
    }

    @Nullable
    private static <T> org.springframework.data.elasticsearch.core.suggest.response.Suggest suggestFrom(@Nullable Suggest suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        if (suggestES == null) {
            return null;
        }
        ArrayList<Object> suggestions = new ArrayList<Object>();
        for (Suggest.Suggestion suggestionES : suggestES) {
            ArrayList<Object> options;
            ArrayList<Object> entries;
            if (suggestionES instanceof org.opensearch.search.suggest.term.TermSuggestion) {
                org.opensearch.search.suggest.term.TermSuggestion termSuggestionES = (org.opensearch.search.suggest.term.TermSuggestion)suggestionES;
                entries = new ArrayList<Object>();
                for (TermSuggestion.Entry entryES : termSuggestionES) {
                    options = new ArrayList<Object>();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add(new TermSuggestion.Entry.Option(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), (double)optionES.getScore(), Boolean.valueOf(optionES.collateMatch()), optionES.getFreq()));
                    }
                    entries.add(new TermSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options));
                }
                suggestions.add(new TermSuggestion(termSuggestionES.getName(), termSuggestionES.getSize(), entries, SearchDocumentResponseBuilder.suggestFrom(termSuggestionES.getSort())));
            }
            if (suggestionES instanceof org.opensearch.search.suggest.phrase.PhraseSuggestion) {
                org.opensearch.search.suggest.phrase.PhraseSuggestion phraseSuggestionES = (org.opensearch.search.suggest.phrase.PhraseSuggestion)suggestionES;
                entries = new ArrayList();
                for (TermSuggestion.Entry entryES : phraseSuggestionES) {
                    options = new ArrayList();
                    for (TermSuggestion.Entry.Option optionES : entryES) {
                        options.add(new PhraseSuggestion.Entry.Option(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), Double.valueOf(optionES.getScore()), Boolean.valueOf(optionES.collateMatch())));
                    }
                    entries.add(new PhraseSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options, Double.valueOf(entryES.getCutoffScore())));
                }
                suggestions.add(new PhraseSuggestion(phraseSuggestionES.getName(), phraseSuggestionES.getSize(), entries));
            }
            if (!(suggestionES instanceof org.opensearch.search.suggest.completion.CompletionSuggestion)) continue;
            org.opensearch.search.suggest.completion.CompletionSuggestion completionSuggestionES = (org.opensearch.search.suggest.completion.CompletionSuggestion)suggestionES;
            entries = new ArrayList();
            for (TermSuggestion.Entry entryES : completionSuggestionES) {
                options = new ArrayList();
                for (TermSuggestion.Entry.Option optionES : entryES) {
                    Object hitEntity;
                    SearchDocument searchDocument;
                    block13: {
                        searchDocument = optionES.getHit() != null ? DocumentAdapters.from(optionES.getHit()) : null;
                        hitEntity = null;
                        if (searchDocument != null) {
                            try {
                                hitEntity = ((CompletableFuture)entityCreator.apply((Object)searchDocument)).get();
                            }
                            catch (Exception e) {
                                if (!LOGGER.isWarnEnabled()) break block13;
                                LOGGER.warn((Object)"Error creating entity from SearchDocument");
                            }
                        }
                    }
                    options.add(new CompletionSuggestion.Entry.Option(SearchDocumentResponseBuilder.textToString(optionES.getText()), SearchDocumentResponseBuilder.textToString(optionES.getHighlighted()), Double.valueOf(optionES.getScore()), Boolean.valueOf(optionES.collateMatch()), optionES.getContexts(), SearchDocumentResponseBuilder.scoreDocFrom(optionES.getDoc()), searchDocument, hitEntity));
                }
                entries.add(new CompletionSuggestion.Entry(SearchDocumentResponseBuilder.textToString(entryES.getText()), entryES.getOffset(), entryES.getLength(), options));
            }
            suggestions.add(new CompletionSuggestion(completionSuggestionES.getName(), completionSuggestionES.getSize(), entries));
        }
        return new org.springframework.data.elasticsearch.core.suggest.response.Suggest(suggestions, suggestES.hasScoreDocs());
    }

    private static SortBy suggestFrom(org.opensearch.search.suggest.SortBy sort) {
        return SortBy.valueOf((String)sort.name().toUpperCase());
    }

    @Nullable
    private static ScoreDoc scoreDocFrom(@Nullable org.apache.lucene.search.ScoreDoc scoreDoc) {
        if (scoreDoc == null) {
            return null;
        }
        return new ScoreDoc((double)scoreDoc.score, Integer.valueOf(scoreDoc.doc), Integer.valueOf(scoreDoc.shardIndex));
    }

    private static String textToString(@Nullable Text text) {
        return text != null ? text.string() : "";
    }
}

