/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.rest_client.RestClientOptions;
import org.opensearch.data.client.osc.OpenSearchClients;
import org.opensearch.data.client.osc.OpenSearchTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class OpenSearchConfiguration
extends ElasticsearchConfigurationSupport {
    @Bean(name={"elasticsearchClientConfiguration"})
    public abstract ClientConfiguration clientConfiguration();

    @Bean
    public RestClient opensearchRestClient(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return OpenSearchClients.getRestClient(clientConfiguration);
    }

    @Bean
    public OpenSearchTransport opensearchTransport(RestClient restClient, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return OpenSearchClients.getOpenSearchTransport(restClient, "imperative", this.transportOptions(), jsonpMapper);
    }

    @Bean
    public OpenSearchClient opensearchClient(OpenSearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return OpenSearchClients.createImperative(transport);
    }

    @Bean(name={"elasticsearchOperations", "elasticsearchTemplate", "opensearchOperations", "opensearchTemplate"})
    public ElasticsearchOperations opensearchOperations(ElasticsearchConverter elasticsearchConverter, OpenSearchClient elasticsearchClient) {
        OpenSearchTemplate template = new OpenSearchTemplate(elasticsearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Bean
    public JsonpMapper jsonpMapper() {
        return new JacksonJsonpMapper();
    }

    public TransportOptions transportOptions() {
        return new RestClientOptions(RequestOptions.DEFAULT);
    }
}

