/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch._types.BulkIndexByScrollFailure;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.cluster.ComponentTemplate;
import org.opensearch.client.opensearch.cluster.ComponentTemplateNode;
import org.opensearch.client.opensearch.cluster.ComponentTemplateSummary;
import org.opensearch.client.opensearch.cluster.GetComponentTemplateResponse;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.GetScriptResponse;
import org.opensearch.client.opensearch.core.UpdateByQueryResponse;
import org.opensearch.client.opensearch.core.mget.MultiGetError;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.AliasDefinition;
import org.opensearch.client.opensearch.indices.GetAliasResponse;
import org.opensearch.client.opensearch.indices.GetIndexResponse;
import org.opensearch.client.opensearch.indices.GetIndexTemplateResponse;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsResponse;
import org.opensearch.client.opensearch.indices.GetMappingResponse;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.TemplateMapping;
import org.opensearch.client.opensearch.indices.get_index_template.IndexTemplate;
import org.opensearch.client.opensearch.indices.get_index_template.IndexTemplateItem;
import org.opensearch.client.opensearch.indices.get_index_template.IndexTemplateSummary;
import org.opensearch.client.opensearch.indices.get_mapping.IndexMappingRecord;
import org.opensearch.data.client.osc.EntityAsMap;
import org.opensearch.data.client.osc.JsonUtils;
import org.opensearch.data.client.osc.TypeUtils;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.index.TemplateResponseData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.data.elasticsearch.core.script.Script;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ResponseConverter {
    private static final Log LOGGER = LogFactory.getLog(ResponseConverter.class);
    private final JsonpMapper jsonpMapper;

    public ResponseConverter(JsonpMapper jsonpMapper) {
        this.jsonpMapper = jsonpMapper;
    }

    public ClusterHealth clusterHealth(HealthResponse healthResponse) {
        Assert.notNull((Object)healthResponse, (String)"healthResponse must not be null");
        return ClusterHealth.builder().withActivePrimaryShards(healthResponse.activePrimaryShards()).withActiveShards(healthResponse.activeShards()).withActiveShardsPercent(Double.parseDouble(healthResponse.activeShardsPercentAsNumber())).withClusterName(healthResponse.clusterName()).withDelayedUnassignedShards(healthResponse.delayedUnassignedShards()).withInitializingShards(healthResponse.initializingShards()).withNumberOfDataNodes(healthResponse.numberOfDataNodes()).withNumberOfInFlightFetch(healthResponse.numberOfInFlightFetch()).withNumberOfNodes(healthResponse.numberOfNodes()).withNumberOfPendingTasks(healthResponse.numberOfPendingTasks()).withRelocatingShards(healthResponse.relocatingShards()).withStatus(healthResponse.status().toString()).withTaskMaxWaitingTimeMillis(Long.parseLong(healthResponse.taskMaxWaitingInQueueMillis())).withTimedOut(healthResponse.timedOut()).withUnassignedShards(healthResponse.unassignedShards()).build();
    }

    public List<TemplateResponse> clusterGetComponentTemplates(GetComponentTemplateResponse getComponentTemplateResponse) {
        Assert.notNull((Object)getComponentTemplateResponse, (String)"getComponentTemplateResponse must not be null");
        ArrayList<TemplateResponse> componentTemplates = new ArrayList<TemplateResponse>();
        getComponentTemplateResponse.componentTemplates().forEach(componentTemplate -> componentTemplates.add(this.clusterGetComponentTemplate((ComponentTemplate)componentTemplate)));
        return componentTemplates;
    }

    private TemplateResponse clusterGetComponentTemplate(ComponentTemplate componentTemplate) {
        ComponentTemplateNode componentTemplateNode = componentTemplate.componentTemplate();
        ComponentTemplateSummary componentTemplateSummary = componentTemplateNode.template();
        return TemplateResponse.builder().withName(componentTemplate.name()).withVersion(componentTemplateNode.version()).withTemplateData(this.clusterGetComponentTemplateData(componentTemplateSummary)).build();
    }

    private TemplateResponseData clusterGetComponentTemplateData(ComponentTemplateSummary componentTemplateSummary) {
        Document mapping = TypeUtils.typeMapping(componentTemplateSummary.mappings());
        Settings settings = new Settings();
        componentTemplateSummary.settings().forEach((key, indexSettings) -> settings.put(key, (Object)Settings.parse((String)indexSettings.toJsonString())));
        Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (AliasDefinition)entry.getValue());
        Map<String, AliasData> aliases = componentTemplateSummary.aliases().entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return TemplateResponseData.builder().withMapping(mapping).withSettings(settings).withAliases(aliases).build();
    }

    public Settings indicesGetSettings(GetIndicesSettingsResponse getIndicesSettingsResponse, String indexName) {
        Assert.notNull((Object)getIndicesSettingsResponse, (String)"getIndicesSettingsResponse must not be null");
        Assert.notNull((Object)indexName, (String)"indexName must not be null");
        Settings settings = new Settings();
        IndexState indexState = (IndexState)getIndicesSettingsResponse.get(indexName);
        if (indexState != null) {
            Function<IndexSettings, Settings> indexSettingsToSettings = indexSettings -> {
                Settings parsedSettings = Settings.parse((String)JsonUtils.toJson(indexSettings, this.jsonpMapper));
                return indexSettings.index() != null ? parsedSettings : (Settings)new Settings().append("index", (Object)parsedSettings);
            };
            if (indexState.defaults() != null) {
                Settings defaultSettings = indexSettingsToSettings.apply(indexState.defaults());
                settings.merge(defaultSettings);
            }
            if (indexState.settings() != null) {
                Settings nonDefaultSettings = indexSettingsToSettings.apply(indexState.settings());
                settings.merge(nonDefaultSettings);
            }
        }
        return settings;
    }

    public Document indicesGetMapping(GetMappingResponse getMappingResponse, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)getMappingResponse, (String)"getMappingResponse must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Map mappings = getMappingResponse.result();
        if (mappings == null || mappings.size() == 0) {
            return Document.create();
        }
        IndexMappingRecord indexMappingRecord = (IndexMappingRecord)mappings.get(indexCoordinates.getIndexName());
        if (indexMappingRecord == null) {
            if (mappings.size() != 1) {
                LOGGER.warn((Object)String.format("no mapping returned for index %s", indexCoordinates.getIndexName()));
                return Document.create();
            }
            String index = (String)mappings.keySet().iterator().next();
            indexMappingRecord = (IndexMappingRecord)mappings.get(index);
        }
        return Document.parse((String)JsonUtils.toJson(indexMappingRecord.mappings(), this.jsonpMapper));
    }

    public List<IndexInformation> indicesGetIndexInformations(GetIndexResponse getIndexResponse) {
        Assert.notNull((Object)getIndexResponse, (String)"getIndexResponse must not be null");
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        getIndexResponse.result().forEach((indexName, indexState) -> {
            Settings settings = indexState.settings() != null ? Settings.parse((String)JsonUtils.toJson(indexState.settings(), this.jsonpMapper)) : new Settings();
            Document mappings = indexState.mappings() != null ? Document.parse((String)JsonUtils.toJson(indexState.mappings(), this.jsonpMapper)) : Document.create();
            ArrayList aliasDataList = new ArrayList();
            indexState.aliases().forEach((aliasName, alias) -> aliasDataList.add(this.indicesGetAliasData((String)aliasName, (Alias)alias)));
            indexInformationList.add(IndexInformation.of((String)indexName, (Settings)settings, (Document)mappings, aliasDataList));
        });
        return indexInformationList;
    }

    public Map<String, Set<AliasData>> indicesGetAliasData(GetAliasResponse getAliasResponse) {
        Assert.notNull((Object)getAliasResponse, (String)"getAliasResponse must not be null");
        HashMap<String, Set<AliasData>> aliasDataMap = new HashMap<String, Set<AliasData>>();
        getAliasResponse.result().forEach((indexName, alias) -> {
            HashSet aliasDataSet = new HashSet();
            alias.aliases().forEach((aliasName, aliasDefinition) -> aliasDataSet.add(this.indicesGetAliasData((String)aliasName, (AliasDefinition)aliasDefinition)));
            aliasDataMap.put((String)indexName, aliasDataSet);
        });
        return aliasDataMap;
    }

    private AliasData indicesGetAliasData(String aliasName, Alias alias) {
        Query filter = alias.filter();
        String filterJson = filter != null ? JsonUtils.toJson(filter, this.jsonpMapper) : null;
        StringQuery filterQuery = filterJson != null ? StringQuery.builder((String)filterJson).build() : null;
        return AliasData.of((String)aliasName, (org.springframework.data.elasticsearch.core.query.Query)filterQuery, (String)alias.indexRouting(), (String)alias.searchRouting(), (Boolean)alias.isWriteIndex(), (Boolean)alias.isHidden());
    }

    private AliasData indicesGetAliasData(String aliasName, AliasDefinition alias) {
        Query filter = alias.filter();
        String filterJson = filter != null ? JsonUtils.toJson(filter, this.jsonpMapper) : null;
        StringQuery filterQuery = filterJson != null ? StringQuery.builder((String)filterJson).build() : null;
        return AliasData.of((String)aliasName, (org.springframework.data.elasticsearch.core.query.Query)filterQuery, (String)alias.indexRouting(), (String)alias.searchRouting(), (Boolean)alias.isWriteIndex(), null);
    }

    @Nullable
    public TemplateData indicesGetTemplateData(GetTemplateResponse getTemplateResponse, String templateName) {
        Assert.notNull((Object)getTemplateResponse, (String)"getTemplateResponse must not be null");
        Assert.notNull((Object)templateName, (String)"templateName must not be null");
        TemplateMapping templateMapping = (TemplateMapping)getTemplateResponse.get(templateName);
        if (templateMapping != null) {
            Settings settings = new Settings();
            templateMapping.settings().forEach((key, jsonData) -> {
                if (key.contains(".")) {
                    settings.put(key, (Object)jsonData.toJson().toString().replaceAll("^\"|\"$", ""));
                } else {
                    settings.put(key, (Object)new DefaultStringObjectMap().fromJson(jsonData.toJson().toString()));
                }
            });
            Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
            Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (Alias)entry.getValue());
            Map<String, AliasData> aliases = templateMapping.aliases().entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
            Document mapping = Document.parse((String)JsonUtils.toJson(templateMapping.mappings(), this.jsonpMapper));
            TemplateData.TemplateDataBuilder builder = TemplateData.builder().withIndexPatterns(templateMapping.indexPatterns().toArray(new String[0])).withOrder(templateMapping.order()).withSettings((Map)settings).withMapping(mapping).withAliases(aliases);
            if (templateMapping.version() != null) {
                builder.withVersion(Integer.valueOf(templateMapping.version().intValue()));
            }
            return builder.build();
        }
        return null;
    }

    public List<TemplateResponse> getIndexTemplates(GetIndexTemplateResponse getIndexTemplateResponse) {
        Assert.notNull((Object)getIndexTemplateResponse, (String)"getIndexTemplateResponse must not be null");
        ArrayList<TemplateResponse> componentTemplates = new ArrayList<TemplateResponse>();
        getIndexTemplateResponse.indexTemplates().forEach(indexTemplateItem -> componentTemplates.add(this.indexGetComponentTemplate((IndexTemplateItem)indexTemplateItem)));
        return componentTemplates;
    }

    private TemplateResponse indexGetComponentTemplate(IndexTemplateItem indexTemplateItem) {
        IndexTemplate indexTemplate = indexTemplateItem.indexTemplate();
        List composedOf = indexTemplate.composedOf();
        IndexTemplateSummary indexTemplateSummary = indexTemplate.template();
        return TemplateResponse.builder().withName(indexTemplateItem.name()).withVersion(indexTemplate.version()).withTemplateData(this.indexGetComponentTemplateData(indexTemplateSummary, composedOf)).build();
    }

    private TemplateResponseData indexGetComponentTemplateData(IndexTemplateSummary indexTemplateSummary, List<String> composedOf) {
        Document mapping = TypeUtils.typeMapping(indexTemplateSummary.mappings());
        Function<Map, Settings> indexSettingsToSettings = indexSettings -> {
            if (indexSettings == null) {
                return null;
            }
            Settings parsedSettings = Settings.parse((String)JsonUtils.toJson(indexSettings, this.jsonpMapper));
            return indexSettings.get("index") != null ? parsedSettings : (Settings)new Settings().append("index", (Object)parsedSettings);
        };
        Settings settings = indexSettingsToSettings.apply(indexTemplateSummary.settings());
        Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (Alias)entry.getValue());
        Map aliases1 = indexTemplateSummary.aliases();
        Map<String, AliasData> aliases = aliases1.entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return TemplateResponseData.builder().withMapping(mapping).withSettings(settings).withAliases(aliases).withComposedOf(composedOf).build();
    }

    public ReindexResponse reindexResponse(org.opensearch.client.opensearch.core.ReindexResponse reindexResponse) {
        Assert.notNull((Object)reindexResponse, (String)"reindexResponse must not be null");
        List failures = reindexResponse.failures().stream().map(this::reindexResponseFailureOf).collect(Collectors.toList());
        return ReindexResponse.builder().withTook(this.timeToLong(reindexResponse.took())).withTimedOut(reindexResponse.timedOut().booleanValue()).withTotal(reindexResponse.total().longValue()).withCreated(reindexResponse.created().longValue()).withUpdated(reindexResponse.updated().longValue()).withDeleted(reindexResponse.deleted().longValue()).withBatches(reindexResponse.batches().longValue()).withVersionConflicts(reindexResponse.versionConflicts().longValue()).withNoops(reindexResponse.noops().longValue()).withBulkRetries(reindexResponse.retries().bulk()).withSearchRetries(reindexResponse.retries().search()).withThrottledMillis(this.timeToLong(reindexResponse.throttledMillis())).withRequestsPerSecond((double)reindexResponse.requestsPerSecond().longValue()).withThrottledUntilMillis(this.timeToLong(reindexResponse.throttledUntilMillis())).withFailures(failures).build();
    }

    private ReindexResponse.Failure reindexResponseFailureOf(BulkIndexByScrollFailure failure) {
        return ReindexResponse.Failure.builder().withIndex(failure.index()).withType(failure.type()).withId(failure.id()).withStatus(Integer.valueOf(failure.status())).withErrorCause(ResponseConverter.toErrorCause(failure.cause())).build();
    }

    private ByQueryResponse.Failure byQueryResponseFailureOf(BulkIndexByScrollFailure failure) {
        return ByQueryResponse.Failure.builder().withIndex(failure.index()).withType(failure.type()).withId(failure.id()).withStatus(Integer.valueOf(failure.status())).withErrorCause(ResponseConverter.toErrorCause(failure.cause())).build();
    }

    @Nullable
    public static MultiGetItem.Failure getFailure(MultiGetResponseItem<EntityAsMap> itemResponse) {
        MultiGetError responseFailure = itemResponse.isFailure() ? itemResponse.failure() : null;
        return responseFailure != null ? MultiGetItem.Failure.of((String)responseFailure.index(), null, (String)responseFailure.id(), null, (ElasticsearchErrorCause)ResponseConverter.toErrorCause(responseFailure.error())) : null;
    }

    public ByQueryResponse byQueryResponse(DeleteByQueryResponse response) {
        List failures = response.failures().stream().map(this::byQueryResponseFailureOf).collect(Collectors.toList());
        ByQueryResponse.ByQueryResponseBuilder builder = ByQueryResponse.builder();
        if (response.took() != null) {
            builder.withTook(response.took().longValue());
        }
        if (response.timedOut() != null) {
            builder.withTimedOut(response.timedOut().booleanValue());
        }
        if (response.total() != null) {
            builder.withTotal(response.total().longValue());
        }
        if (response.deleted() != null) {
            builder.withDeleted(response.deleted().longValue());
        }
        if (response.batches() != null) {
            builder.withBatches(Math.toIntExact(response.batches()));
        }
        if (response.versionConflicts() != null) {
            builder.withVersionConflicts(response.versionConflicts().longValue());
        }
        if (response.noops() != null) {
            builder.withNoops(response.noops().longValue());
        }
        if (response.retries() != null) {
            builder.withBulkRetries(response.retries().bulk());
            builder.withSearchRetries(response.retries().search());
        }
        builder.withFailures(failures);
        return builder.build();
    }

    public ByQueryResponse byQueryResponse(UpdateByQueryResponse response) {
        List failures = response.failures().stream().map(this::byQueryResponseFailureOf).collect(Collectors.toList());
        ByQueryResponse.ByQueryResponseBuilder builder = ByQueryResponse.builder();
        if (response.took() != null) {
            builder.withTook(response.took().longValue());
        }
        if (response.timedOut() != null) {
            builder.withTimedOut(response.timedOut().booleanValue());
        }
        if (response.total() != null) {
            builder.withTotal(response.total().longValue());
        }
        if (response.deleted() != null) {
            builder.withDeleted(response.deleted().longValue());
        }
        if (response.updated() != null) {
            builder.withUpdated(response.updated().longValue());
        }
        if (response.batches() != null) {
            builder.withBatches(Math.toIntExact(response.batches()));
        }
        if (response.versionConflicts() != null) {
            builder.withVersionConflicts(response.versionConflicts().longValue());
        }
        if (response.noops() != null) {
            builder.withNoops(response.noops().longValue());
        }
        if (response.retries() != null) {
            builder.withBulkRetries(response.retries().bulk());
            builder.withSearchRetries(response.retries().search());
        }
        builder.withFailures(failures);
        return builder.build();
    }

    @Nullable
    public Script scriptResponse(GetScriptResponse response) {
        Assert.notNull((Object)response, (String)"response must not be null");
        return response.found() ? Script.builder().withId(response.id()).withLanguage(response.script().lang()).withSource(response.script().source()).build() : null;
    }

    private long timeToLong(String time) {
        if (time == null) {
            return 0L;
        }
        return Long.parseLong(time);
    }

    private long timeToLong(Time time) {
        if (time.isTime()) {
            return Long.parseLong(time.time());
        }
        return time.offset().intValue();
    }

    @Nullable
    static ElasticsearchErrorCause toErrorCause(@Nullable ErrorCause errorCause) {
        if (errorCause != null) {
            return new ElasticsearchErrorCause(errorCause.type(), errorCause.reason(), errorCause.stackTrace(), ResponseConverter.toErrorCause(errorCause.causedBy()), errorCause.rootCause().stream().map(ResponseConverter::toErrorCause).collect(Collectors.toList()), errorCause.suppressed().stream().map(ResponseConverter::toErrorCause).collect(Collectors.toList()));
        }
        return null;
    }
}

