/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.lang.Nullable;

final class JsonUtils {
    private static final Log LOGGER = LogFactory.getLog(JsonUtils.class);

    private JsonUtils() {
    }

    public static String toJson(Object object, JsonpMapper mapper) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
        mapper.serialize(object, generator);
        generator.close();
        String json = "{}";
        try {
            json = baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)"could not read json", (Throwable)e);
        }
        return json;
    }

    @Nullable
    public static String queryToJson(@Nullable Query query, JsonpMapper mapper) {
        if (query == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
        query.serialize(generator, mapper);
        generator.close();
        return baos.toString(StandardCharsets.UTF_8);
    }
}

