/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.opensearch.nio.NioChannel;
import org.opensearch.nio.SocketChannelContext;

public class NioSocketChannel
extends NioChannel {
    private final AtomicBoolean contextSet = new AtomicBoolean(false);
    private final SocketChannel socketChannel;
    private volatile InetSocketAddress remoteAddress;
    private volatile InetSocketAddress localAddress;
    private volatile SocketChannelContext context;

    public NioSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setContext(SocketChannelContext context) {
        if (!this.contextSet.compareAndSet(false, true)) {
            throw new IllegalStateException("Context on this channel were already set. It should only be once.");
        }
        this.context = context;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = (InetSocketAddress)this.socketChannel.socket().getLocalSocketAddress();
        }
        return this.localAddress;
    }

    @Override
    public SocketChannel getRawChannel() {
        return this.socketChannel;
    }

    public SocketChannelContext getContext() {
        return this.context;
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
        }
        return this.remoteAddress;
    }

    public void addConnectListener(BiConsumer<Void, Exception> listener) {
        this.context.addConnectListener(listener);
    }

    public String toString() {
        return "NioSocketChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + "}";
    }
}

