/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geo.search.aggregations.bucket.composite.GeoTileValuesSource;
import org.opensearch.geo.search.aggregations.bucket.geogrid.CellIdSource;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.bucket.GeoTileUtils;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.sort.SortOrder;

public class GeoTileGridValuesSourceBuilder
extends CompositeValuesSourceBuilder<GeoTileGridValuesSourceBuilder> {
    public static final String TYPE = "geotile_grid";
    @Deprecated
    public static final Byte COMPOSITE_AGGREGATION_SERIALISATION_BYTE_CODE = 3;
    static final ValuesSourceRegistry.RegistryKey<GeoTileCompositeSuppier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("geotile_grid", GeoTileCompositeSuppier.class);
    static final ObjectParser<GeoTileGridValuesSourceBuilder, Void> PARSER = new ObjectParser("geotile_grid");
    private int precision = 7;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));

    public static GeoTileGridValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (GeoTileGridValuesSourceBuilder)((Object)PARSER.parse(parser, (Object)new GeoTileGridValuesSourceBuilder(name), null));
    }

    public static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.GEOPOINT, (valuesSourceConfig, precision, boundingBox, name, hasScript, format, missingBucket, missingOrder, order) -> {
            ValuesSource.GeoPoint geoPoint = (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource();
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            CellIdSource cellIdSource = new CellIdSource(geoPoint, precision, boundingBox, GeoTileUtils::longEncode);
            return new CompositeValuesSourceConfig(name, fieldType, (ValuesSource)cellIdSource, DocValueFormat.GEOTILE, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                CellIdSource cis = (CellIdSource)compositeValuesSourceConfig.valuesSource();
                return new GeoTileValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)cis::longValues), LongUnaryOperator.identity(), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    GeoTileGridValuesSourceBuilder(String name) {
        super(name);
    }

    public GeoTileGridValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readInt();
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
            this.geoBoundingBox = new GeoBoundingBox(in);
        }
    }

    public GeoTileGridValuesSourceBuilder precision(int precision) {
        this.precision = GeoTileUtils.checkPrecisionRange((int)precision);
        return this;
    }

    public GeoTileGridValuesSourceBuilder geoBoundingBox(GeoBoundingBox geoBoundingBox) {
        this.geoBoundingBox = geoBoundingBox;
        return this;
    }

    public GeoTileGridValuesSourceBuilder format(String format) {
        throw new IllegalArgumentException("[format] is not supported for [geotile_grid]");
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeInt(this.precision);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_6_0)) {
            this.geoBoundingBox.writeTo(out);
        }
    }

    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("precision", this.precision);
        if (!this.geoBoundingBox.isUnbounded()) {
            this.geoBoundingBox.toXContent(builder, params);
        }
    }

    protected String type() {
        return TYPE;
    }

    GeoBoundingBox geoBoundingBox() {
        return this.geoBoundingBox;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.geoBoundingBox);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoTileGridValuesSourceBuilder other = (GeoTileGridValuesSourceBuilder)((Object)obj);
        return Objects.equals(this.precision, other.precision) && Objects.equals(this.geoBoundingBox, other.geoBoundingBox);
    }

    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.GEOPOINT;
    }

    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config) throws IOException {
        return ((GeoTileCompositeSuppier)queryShardContext.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config)).apply(config, this.precision, this.geoBoundingBox(), this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        PARSER.declareInt(GeoTileGridValuesSourceBuilder::precision, new ParseField("precision", new String[0]));
        PARSER.declareField((p, builder, context) -> builder.geoBoundingBox(GeoBoundingBox.parseBoundingBox((XContentParser)p)), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface GeoTileCompositeSuppier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, int var2, GeoBoundingBox var3, String var4, boolean var5, String var6, boolean var7, MissingOrder var8, SortOrder var9);
    }
}

