/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.GeneralScriptException;
import org.opensearch.script.expression.PerThreadReplaceableConstDoubleValueSource;

class ExpressionAggregationScript
implements AggregationScript.LeafFactory {
    final Expression exprScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final boolean needsScore;
    final PerThreadReplaceableConstDoubleValueSource specialValue;

    ExpressionAggregationScript(Expression e, SimpleBindings b, boolean n, PerThreadReplaceableConstDoubleValueSource v) {
        this.exprScript = e;
        this.bindings = b;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)this.bindings);
        this.needsScore = n;
        this.specialValue = v;
    }

    public boolean needs_score() {
        return this.needsScore;
    }

    public AggregationScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new AggregationScript(this){
            DoubleValues values;
            final /* synthetic */ ExpressionAggregationScript this$0;
            {
                this.this$0 = this$0;
                this.values = this.this$0.source.getValues(leaf, new DoubleValues(){

                    public double doubleValue() throws IOException {
                        return this.get_score().doubleValue();
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                });
            }

            public Object execute() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + String.valueOf(this.this$0.exprScript), (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + String.valueOf(this.this$0.exprScript), e);
                }
            }

            public void setNextAggregationValue(Object value) {
                if (this.this$0.specialValue != null) {
                    if (value instanceof Number) {
                        this.this$0.specialValue.setValue(((Number)value).doubleValue());
                    } else {
                        throw new GeneralScriptException("Cannot use expression with text variable using " + String.valueOf(this.this$0.exprScript));
                    }
                }
            }
        };
    }
}

