/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

public class RankFeaturesFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "rank_features";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private RankFeaturesFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    protected RankFeaturesFieldMapper clone() {
        return (RankFeaturesFieldMapper)super.clone();
    }

    public RankFeaturesFieldType fieldType() {
        return (RankFeaturesFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[rank_features] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[rank_features] fields must be json objects, expected a START_OBJECT but got: " + context.parser().currentToken());
        }
        String feature = null;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                feature = context.parser().currentName();
            } else if (token != XContentParser.Token.VALUE_NULL) {
                if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                    String key = this.name() + "." + feature;
                    float value = context.parser().floatValue(true);
                    if (context.doc().getByKey((Object)key) != null) {
                        throw new IllegalArgumentException("[rank_features] fields do not support indexing multiple values for the same rank feature [" + key + "] in the same document");
                    }
                    context.doc().addWithKey((Object)key, (IndexableField)new FeatureField(this.name(), feature, value));
                } else {
                    throw new IllegalArgumentException("[rank_features] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + token);
                }
            }
            token = context.parser().nextToken();
        }
    }

    protected void parseCreateField(ParseContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.meta);
        }

        public RankFeaturesFieldMapper build(Mapper.BuilderContext context) {
            return new RankFeaturesFieldMapper(this.name, new RankFeaturesFieldType(this.buildFullName(context), (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build());
        }
    }

    public static final class RankFeaturesFieldType
    extends MappedFieldType {
        public RankFeaturesFieldType(String name, Map<String, String> meta) {
            super(name, false, false, false, TextSearchInfo.NONE, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public String typeName() {
            return RankFeaturesFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new IllegalArgumentException("[rank_features] fields do not support [exists] queries");
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            throw new IllegalArgumentException("[rank_features] fields do not support sorting, scripting or aggregating");
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity((String)this.name(), (MapperService)mapperService, (String)format);
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new IllegalArgumentException("Queries on [rank_features] fields are not supported");
        }
    }
}

