/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.spi;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.painless.spi.WhitelistConstructor;
import org.opensearch.painless.spi.WhitelistField;
import org.opensearch.painless.spi.WhitelistMethod;

public final class WhitelistClass {
    public final String origin;
    public final String javaClassName;
    public final List<WhitelistConstructor> whitelistConstructors;
    public final List<WhitelistMethod> whitelistMethods;
    public final List<WhitelistField> whitelistFields;
    public final Map<Class<?>, Object> painlessAnnotations;

    public WhitelistClass(String origin, String javaClassName, List<WhitelistConstructor> whitelistConstructors, List<WhitelistMethod> whitelistMethods, List<WhitelistField> whitelistFields, List<Object> painlessAnnotations) {
        this.origin = Objects.requireNonNull(origin);
        this.javaClassName = Objects.requireNonNull(javaClassName);
        this.whitelistConstructors = Collections.unmodifiableList(Objects.requireNonNull(whitelistConstructors));
        this.whitelistMethods = Collections.unmodifiableList(Objects.requireNonNull(whitelistMethods));
        this.whitelistFields = Collections.unmodifiableList(Objects.requireNonNull(whitelistFields));
        this.painlessAnnotations = painlessAnnotations.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(Objects.requireNonNull(painlessAnnotations).stream().map(painlessAnnotation -> new AbstractMap.SimpleEntry(painlessAnnotation.getClass(), painlessAnnotation)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

