/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.rankeval.RankEvalAction;
import org.opensearch.index.rankeval.RankEvalRequest;
import org.opensearch.index.rankeval.RankEvalSpec;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestRankEvalAction
extends BaseRestHandler {
    public static String ENDPOINT = "_rank_eval";

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.POST, "/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.GET, "/{index}/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.POST, "/{index}/" + ENDPOINT)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RankEvalRequest rankEvalRequest = new RankEvalRequest();
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestRankEvalAction.parseRankEvalRequest(rankEvalRequest, request, parser);
        }
        return channel -> client.executeLocally((ActionType)RankEvalAction.INSTANCE, (ActionRequest)rankEvalRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private static void parseRankEvalRequest(RankEvalRequest rankEvalRequest, RestRequest request, XContentParser parser) {
        rankEvalRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
        rankEvalRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)rankEvalRequest.indicesOptions()));
        if (request.hasParam("search_type")) {
            rankEvalRequest.searchType(SearchType.fromString((String)request.param("search_type")));
        }
        RankEvalSpec spec = RankEvalSpec.parse(parser);
        rankEvalRequest.setRankEvalSpec(spec);
    }

    public String getName() {
        return "rank_eval_action";
    }
}

