/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.OpenSearchAllocationTestCase;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.util.CollectionUtils;

public abstract class OpenSearchAllocationWithConstraintsTestCase
extends OpenSearchAllocationTestCase {
    protected OpenSearchAllocationTestCase.MockAllocationService allocation;
    private ClusterState initialClusterState;
    protected ClusterState clusterState;
    private HashMap<String, Integer> indexShardCount;
    private HashMap<String, HashMap<String, Integer>> nodeShardsByIndex;
    private static final int MAX_REROUTE_STEPS_ALLOWED = 1500;

    @Before
    public void clearState() {
        this.allocation = null;
        this.initialClusterState = null;
        this.clusterState = null;
        this.indexShardCount = null;
        this.nodeShardsByIndex = null;
    }

    public static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }

    public void buildAllocationService() {
        Settings.Builder sb = Settings.builder();
        this.buildAllocationService(sb);
    }

    public void buildAllocationService(String excludeNodes) {
        this.logger.info("Excluding nodes: [{}]", (Object)excludeNodes);
        Settings.Builder sb = Settings.builder().put("cluster.routing.allocation.exclude._node_id", excludeNodes);
        this.buildAllocationService(sb);
    }

    public void buildZoneAwareAllocationService() {
        this.logger.info("Creating zone aware cluster");
        Settings.Builder sb = Settings.builder().put("cluster.routing.allocation.awareness.attributes", "zone");
        this.buildAllocationService(sb);
    }

    public void buildAllocationService(Settings.Builder sb) {
        sb.put("cluster.routing.allocation.node_concurrent_recoveries", 1);
        sb.put("cluster.routing.allocation.cluster_concurrent_rebalance", 1);
        this.allocation = OpenSearchAllocationWithConstraintsTestCase.createAllocationService(sb.build());
    }

    public Metadata buildMetadata(Metadata.Builder mb, String indexPrefix, int numberOfIndices, int numberOfShards, int numberOfReplicas) {
        for (int i = 0; i < numberOfIndices; ++i) {
            mb.put(IndexMetadata.builder((String)(indexPrefix + i)).settings(OpenSearchAllocationWithConstraintsTestCase.settings(Version.CURRENT).put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), "0")).numberOfShards(numberOfShards).numberOfReplicas(numberOfReplicas));
        }
        return mb.build();
    }

    public RoutingTable buildRoutingTable(RoutingTable.Builder rb, Metadata metadata, String indexPrefix, int numberOfIndices) {
        for (int i = 0; i < numberOfIndices; ++i) {
            rb.addAsNew(metadata.index(indexPrefix + i));
        }
        return rb.build();
    }

    public DiscoveryNodes addNodes(DiscoveryNodes.Builder nb, String nodePrefix, int nodesAdded) {
        for (int i = 0; i < nodesAdded; ++i) {
            nb.add(OpenSearchAllocationWithConstraintsTestCase.newNode(nodePrefix + i, Collections.singletonMap("_node_id", nodePrefix + i)));
        }
        return nb.build();
    }

    public void resetCluster() {
        this.clusterState = this.initialClusterState;
    }

    public void updateInitialCluster() {
        this.initialClusterState = this.clusterState;
    }

    public void createEmptyZoneAwareCluster(Map<String, Integer> nodesPerZone) {
        DiscoveryNodes.Builder nb = DiscoveryNodes.builder();
        int nodeId = 0;
        for (String zone : nodesPerZone.keySet()) {
            for (int i = 0; i < nodesPerZone.get(zone); ++i) {
                nb.add(OpenSearchAllocationWithConstraintsTestCase.newNode("node_" + nodeId, Collections.singletonMap("zone", zone)));
                ++nodeId;
            }
        }
        this.clusterState = this.initialClusterState = ClusterState.builder((ClusterName)ClusterName.DEFAULT).nodes(nb.build()).build();
    }

    public void setupInitialCluster(int nodeCount, int indices, int shards, int replicas) {
        String DEFAULT_INDEX_PREFIX = "index_";
        String DEFAULT_NODE_PREFIX = "node_";
        Metadata metadata = this.buildMetadata(Metadata.builder(), "index_", indices, shards, replicas);
        RoutingTable routingTable = this.buildRoutingTable(RoutingTable.builder(), metadata, "index_", indices);
        DiscoveryNodes nodes = this.addNodes(DiscoveryNodes.builder(), "node_", nodeCount);
        this.initialClusterState = ClusterState.builder((ClusterName)ClusterName.DEFAULT).metadata(metadata).routingTable(routingTable).nodes(nodes).build();
        this.buildAllocationService();
        this.clusterState = this.initialClusterState = this.allocateShardsAndBalance(this.initialClusterState);
        this.indexShardCount = new HashMap();
        for (int i = 0; i < indices; ++i) {
            this.indexShardCount.put("index_" + i, shards * (replicas + 1));
        }
        this.assertForIndexShardHotSpots(false, nodeCount, new String[0]);
        this.logger.info("Initial cluster created...");
    }

    public void buildNodeShardsByIndex() {
        this.nodeShardsByIndex = new HashMap();
        for (RoutingNode rn : this.clusterState.getRoutingNodes()) {
            String node = rn.nodeId();
            this.nodeShardsByIndex.put(node, new HashMap());
            for (ShardRouting shard : rn) {
                assert (shard.currentNodeId().equals(node));
                if (shard.state() != ShardRoutingState.INITIALIZING && shard.state() != ShardRoutingState.STARTED) continue;
                this.nodeShardsByIndex.get(node).merge(shard.getIndexName(), 1, Integer::sum);
            }
        }
    }

    public boolean isIndexHotSpotPresent(int nodes, List<String> nodeList) {
        for (String node : nodeList) {
            for (String index : this.nodeShardsByIndex.get(node).keySet()) {
                int limit;
                int count = this.nodeShardsByIndex.get(node).get(index);
                if (count <= (limit = (int)Math.ceil((float)this.indexShardCount.get(index).intValue() / (float)nodes))) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNodeList(String ... nodesToValidate) {
        if (CollectionUtils.isEmpty((Object[])nodesToValidate)) {
            return Arrays.asList(this.clusterState.getNodes().resolveNodes(new String[0]));
        }
        return Arrays.asList(nodesToValidate);
    }

    public void assertForIndexShardHotSpots(boolean expected, int nodes, String ... nodesToValidate) {
        List<String> nodeList = this.getNodeList(nodesToValidate);
        this.buildNodeShardsByIndex();
        OpenSearchAllocationWithConstraintsTestCase.assertEquals((Object)expected, (Object)this.isIndexHotSpotPresent(nodes, nodeList));
    }

    public int allocateAndCheckIndexShardHotSpots(boolean expected, int nodes, String ... nodesToValidate) {
        List initShards;
        List<String> nodeList = this.getNodeList(nodesToValidate);
        boolean hasHotSpot = false;
        this.buildNodeShardsByIndex();
        int movesToBalance = 0;
        do {
            assert (movesToBalance <= 1500) : "Could not balance cluster in max allowed moves";
            this.clusterState = this.allocation.applyStartedShards(this.clusterState, this.clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
            this.clusterState = this.allocation.reroute(this.clusterState, "reroute");
            initShards = this.clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING});
            for (ShardRouting shard : initShards) {
                int limit;
                int count;
                String node = shard.currentNodeId();
                String index = shard.getIndexName();
                this.nodeShardsByIndex.get(node).merge(index, 1, Integer::sum);
                if (!nodeList.contains(node) || (count = this.nodeShardsByIndex.get(node).get(index).intValue()) <= (limit = (int)Math.ceil((float)this.indexShardCount.get(index).intValue() / (float)nodes))) continue;
                boolean limitBreachedOnAllNodes = true;
                for (RoutingNode peerNode : this.clusterState.getRoutingNodes()) {
                    int peerCount;
                    if (peerNode.nodeId().equals(node) || (peerCount = this.nodeShardsByIndex.get(peerNode.nodeId()).getOrDefault(index, 0).intValue()) >= limit) continue;
                    limitBreachedOnAllNodes = false;
                }
                if (limitBreachedOnAllNodes) continue;
                boolean peerHasSameShard = false;
                for (RoutingNode peerNode : this.clusterState.getRoutingNodes()) {
                    ShardRouting sameIdShardOnPeer;
                    if (peerNode.nodeId().equals(node) || (sameIdShardOnPeer = peerNode.getByShardId(shard.shardId())) == null || !sameIdShardOnPeer.getIndexName().equals(index)) continue;
                    peerHasSameShard = true;
                }
                if (peerHasSameShard) continue;
                hasHotSpot = true;
            }
            ++movesToBalance;
        } while (!initShards.isEmpty());
        this.logger.info("HotSpot: [{}], Moves to balance: [{}]", (Object)hasHotSpot, (Object)movesToBalance);
        OpenSearchAllocationWithConstraintsTestCase.assertEquals((Object)expected, (Object)hasHotSpot);
        this.assertForIndexShardHotSpots(false, nodes, new String[0]);
        return movesToBalance;
    }

    public ClusterState allocateShardsAndBalance(ClusterState clusterState) {
        int iterations = 0;
        do {
            clusterState = this.allocation.applyStartedShards(clusterState, clusterState.getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}));
        } while (!(clusterState = this.allocation.reroute(clusterState, "reroute")).getRoutingNodes().shardsWithState(new ShardRoutingState[]{ShardRoutingState.INITIALIZING}).isEmpty() && ++iterations < 1500);
        return clusterState;
    }

    public void addNodesWithoutIndexing(int nodeCount, String node_prefix) {
        DiscoveryNodes nodes = this.addNodes(DiscoveryNodes.builder((DiscoveryNodes)this.clusterState.nodes()), node_prefix, nodeCount);
        this.clusterState = ClusterState.builder((ClusterState)this.clusterState).nodes(nodes).build();
    }

    public void terminateNodes(String ... nodesToTerminate) {
        if (CollectionUtils.isEmpty((Object[])nodesToTerminate)) {
            return;
        }
        DiscoveryNodes.Builder nb = DiscoveryNodes.builder((DiscoveryNodes)this.clusterState.nodes());
        Arrays.asList(nodesToTerminate).forEach(node -> nb.remove(node));
        this.clusterState = ClusterState.builder((ClusterState)this.clusterState).nodes(nb.build()).build();
        this.clusterState = this.allocation.disassociateDeadNodes(this.clusterState, true, "node-terminated");
        this.clusterState = this.allocateShardsAndBalance(this.clusterState);
    }

    public void addNodesWithIndexing(int nodeCount, String node_prefix, int indices, int shards, int replicas) {
        String NEW_INDEX_PREFIX = "new_index_";
        Metadata md = this.buildMetadata(Metadata.builder((Metadata)this.clusterState.getMetadata()), "new_index_", indices, shards, replicas);
        RoutingTable rb = this.buildRoutingTable(RoutingTable.builder((RoutingTable)this.clusterState.getRoutingTable()), md, "new_index_", indices);
        DiscoveryNodes nodes = this.addNodes(DiscoveryNodes.builder((DiscoveryNodes)this.clusterState.nodes()), node_prefix, nodeCount);
        this.clusterState = ClusterState.builder((ClusterState)this.clusterState).metadata(md).routingTable(rb).nodes(nodes).build();
        for (int i = 0; i < indices; ++i) {
            this.indexShardCount.put("new_index_" + i, shards * (replicas + 1));
        }
    }

    public void addIndices(String index_prefix, int indices, int shards, int replicas) {
        Metadata md = this.buildMetadata(Metadata.builder((Metadata)this.clusterState.getMetadata()), index_prefix, indices, shards, replicas);
        RoutingTable rb = this.buildRoutingTable(RoutingTable.builder((RoutingTable)this.clusterState.getRoutingTable()), md, index_prefix, indices);
        this.clusterState = ClusterState.builder((ClusterState)this.clusterState).metadata(md).routingTable(rb).build();
        if (this.indexShardCount == null) {
            this.indexShardCount = new HashMap();
        }
        for (int i = 0; i < indices; ++i) {
            this.indexShardCount.put(index_prefix + i, shards * (replicas + 1));
        }
    }
}

