/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.util.concurrent.TimeUnit;
import org.opensearch.cluster.coordination.DeterministicTaskQueue;
import org.opensearch.common.util.concurrent.PrioritizedOpenSearchThreadPoolExecutor;
import org.opensearch.threadpool.ThreadPool;

public class MockSinglePrioritizingExecutor
extends PrioritizedOpenSearchThreadPoolExecutor {
    public MockSinglePrioritizingExecutor(String name, final DeterministicTaskQueue deterministicTaskQueue, ThreadPool threadPool) {
        super(name, 0, 1, 0L, TimeUnit.MILLISECONDS, r -> new Thread(){

            @Override
            public void start() {
                deterministicTaskQueue.scheduleNow(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            r.run();
                        }
                        catch (KillWorkerError killWorkerError) {
                            // empty catch block
                        }
                    }

                    public String toString() {
                        return r.toString();
                    }
                });
            }
        }, threadPool.getThreadContext(), threadPool.scheduler());
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        throw KillWorkerError.INSTANCE;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    private static final class KillWorkerError
    extends Error {
        private static final KillWorkerError INSTANCE = new KillWorkerError();

        private KillWorkerError() {
        }
    }
}

