/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.util.Random;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.opensearch.Version;
import org.opensearch.cluster.routing.AllocationId;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.common.UUIDs;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.repositories.IndexId;
import org.opensearch.snapshots.Snapshot;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.test.OpenSearchTestCase;

public class TestShardRouting {
    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state) {
        return new ShardRouting(shardId, currentNodeId, null, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), -1L);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource) {
        return new ShardRouting(shardId, currentNodeId, null, primary, state, recoverySource, TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), TestShardRouting.buildAllocationId(state), -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, AllocationId allocationId) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, allocationId);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, AllocationId allocationId) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), TestShardRouting.buildUnassignedInfo(state), allocationId, -1L);
    }

    public static ShardRouting newShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo) {
        return TestShardRouting.newShardRouting(new ShardId(index, "_na_", shardId), currentNodeId, relocatingNodeId, primary, state, unassignedInfo);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, UnassignedInfo unassignedInfo) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, TestShardRouting.buildRecoveryTarget(primary, state), unassignedInfo, TestShardRouting.buildAllocationId(state), -1L);
    }

    public static ShardRouting newShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource, UnassignedInfo unassignedInfo) {
        return new ShardRouting(shardId, currentNodeId, relocatingNodeId, primary, state, recoverySource, unassignedInfo, TestShardRouting.buildAllocationId(state), -1L);
    }

    public static ShardRouting relocate(ShardRouting shardRouting, String relocatingNodeId, long expectedShardSize) {
        return shardRouting.relocate(relocatingNodeId, expectedShardSize);
    }

    private static RecoverySource buildRecoveryTarget(boolean primary, ShardRoutingState state) {
        switch (state) {
            case UNASSIGNED: 
            case INITIALIZING: {
                if (primary) {
                    return OpenSearchTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE);
                }
                return RecoverySource.PeerRecoverySource.INSTANCE;
            }
            case STARTED: 
            case RELOCATING: {
                return null;
            }
        }
        throw new IllegalStateException("illegal state");
    }

    private static AllocationId buildAllocationId(ShardRoutingState state) {
        switch (state) {
            case UNASSIGNED: {
                return null;
            }
            case INITIALIZING: 
            case STARTED: {
                return AllocationId.newInitializing();
            }
            case RELOCATING: {
                AllocationId allocationId = AllocationId.newInitializing();
                return AllocationId.newRelocation((AllocationId)allocationId);
            }
        }
        throw new IllegalStateException("illegal state");
    }

    private static UnassignedInfo buildUnassignedInfo(ShardRoutingState state) {
        switch (state) {
            case UNASSIGNED: 
            case INITIALIZING: {
                return new UnassignedInfo(OpenSearchTestCase.randomFrom(UnassignedInfo.Reason.values()), "auto generated for test");
            }
            case STARTED: 
            case RELOCATING: {
                return null;
            }
        }
        throw new IllegalStateException("illegal state");
    }

    public static RecoverySource randomRecoverySource() {
        return OpenSearchTestCase.randomFrom(RecoverySource.EmptyStoreRecoverySource.INSTANCE, RecoverySource.ExistingStoreRecoverySource.INSTANCE, RecoverySource.PeerRecoverySource.INSTANCE, RecoverySource.LocalShardsRecoverySource.INSTANCE, new RecoverySource.SnapshotRecoverySource(UUIDs.randomBase64UUID(), new Snapshot("repo", new SnapshotId(OpenSearchTestCase.randomAlphaOfLength(8), UUIDs.randomBase64UUID())), Version.CURRENT, new IndexId("some_index", UUIDs.randomBase64UUID((Random)LuceneTestCase.random()))));
    }
}

