/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.spi.Element;
import org.opensearch.common.inject.spi.Elements;
import org.opensearch.common.inject.spi.InstanceBinding;
import org.opensearch.common.inject.spi.ProviderInstanceBinding;
import org.opensearch.test.OpenSearchTestCase;

public abstract class ModuleTestCase
extends OpenSearchTestCase {
    public <T> void assertInstanceBinding(Module module, Class<T> to, Predicate<T> tester) {
        this.assertInstanceBindingWithAnnotation(module, to, tester, null);
    }

    private <T> void assertInstanceBindingWithAnnotation(Module module, Class<T> to, Predicate<T> tester, Class<? extends Annotation> annotation) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            InstanceBinding binding;
            if (element instanceof InstanceBinding) {
                binding = (InstanceBinding)element;
                if (!to.equals(binding.getKey().getTypeLiteral().getType()) || annotation != null && !annotation.equals(binding.getKey().getAnnotationType())) continue;
                ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding.getInstance())));
                return;
            }
            if (!(element instanceof ProviderInstanceBinding) || !to.equals((binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.assertTrue((boolean)tester.test(to.cast(binding.getProviderInstance().get())));
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Element element : elements) {
            s.append(element).append("\n");
        }
        ModuleTestCase.fail((String)("Did not find any instance binding to " + to.getName() + ". Found these bindings:\n" + s));
    }
}

