/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedFormatter {
    private static final Pattern PARAM_REGEX = Pattern.compile("\\\\(.) | (% \\( ([^)]+) \\) )", 4);

    private NamedFormatter() {
    }

    public static String format(String fmt, Map<String, Object> values) {
        Matcher matcher = PARAM_REGEX.matcher(fmt);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String replacement;
                if (matcher.group(1) != null) {
                    replacement = matcher.group(1);
                } else {
                    String paramName = matcher.group(3);
                    if (values.containsKey(paramName)) {
                        replacement = values.get(paramName).toString();
                    } else {
                        throw new IllegalArgumentException("No parameter value for %(" + paramName + ")");
                    }
                }
                matcher.appendReplacement(sb, replacement);
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return fmt;
    }
}

