/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MapperTestCase;
import org.opensearch.index.mapper.MockFieldMapper;

public abstract class FieldMapperTestCase2<T extends FieldMapper.Builder<?>>
extends MapperTestCase {
    private final List<Modifier> modifiers = new ArrayList<Modifier>(Arrays.asList(new Modifier("analyzer", false, (a, b) -> {
        a.indexAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.indexAnalyzer(new NamedAnalyzer("keyword", AnalyzerScope.INDEX, (Analyzer)new KeywordAnalyzer()));
    }), new Modifier("boost", true, (a, b) -> {
        a.boost(1.1f);
        b.boost(1.2f);
    }), new Modifier("doc_values", false, (a, b) -> {
        a.docValues(true);
        b.docValues(false);
    }), this.booleanModifier("eager_global_ordinals", true, (a, t) -> a.setEagerGlobalOrdinals(t.booleanValue())), this.booleanModifier("index", false, (a, t) -> a.index(t.booleanValue())), this.booleanModifier("norms", false, FieldMapper.Builder::omitNorms), new Modifier("search_analyzer", true, (a, b) -> {
        a.searchAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.searchAnalyzer(new NamedAnalyzer("keyword", AnalyzerScope.INDEX, (Analyzer)new KeywordAnalyzer()));
    }), new Modifier("search_quote_analyzer", true, (a, b) -> {
        a.searchQuoteAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.searchQuoteAnalyzer(new NamedAnalyzer("whitespace", AnalyzerScope.INDEX, (Analyzer)new WhitespaceAnalyzer()));
    }), new Modifier("store", false, (a, b) -> {
        a.store(true);
        b.store(false);
    }), new Modifier("term_vector", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(false);
    }), new Modifier("term_vector_positions", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(false);
    }), new Modifier("term_vector_payloads", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(true);
        a.storeTermVectorPayloads(true);
        b.storeTermVectorPayloads(false);
    }), new Modifier("term_vector_offsets", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(true);
        a.storeTermVectorOffsets(true);
        b.storeTermVectorOffsets(false);
    })));

    private Modifier booleanModifier(String name, boolean updateable, BiConsumer<T, Boolean> method) {
        return new Modifier(name, updateable, (a, b) -> {
            method.accept(a, true);
            method.accept(b, false);
        });
    }

    protected Set<String> unsupportedProperties() {
        return Collections.emptySet();
    }

    protected void addModifier(String property, boolean updateable, BiConsumer<T, T> method) {
        this.modifiers.add(new Modifier(property, updateable, method));
    }

    protected void addBooleanModifier(String property, boolean updateable, BiConsumer<T, Boolean> method) {
        this.modifiers.add(new Modifier(property, updateable, (a, b) -> {
            method.accept(a, true);
            method.accept(b, false);
        }));
    }

    protected abstract T newBuilder();

    public void testMergeConflicts() {
        Mapper.BuilderContext context = new Mapper.BuilderContext(SETTINGS, new ContentPath(1));
        T builder1 = this.newBuilder();
        T builder2 = this.newBuilder();
        FieldMapper mapper = (FieldMapper)builder1.build(context);
        Object toMerge = (FieldMapper)builder2.build(context);
        mapper.merge((Mapper)toMerge);
        mapper = (FieldMapper)this.newBuilder().build(context);
        toMerge = new MockFieldMapper("bogus"){

            @Override
            protected String contentType() {
                return "bogustype";
            }
        };
        IllegalArgumentException e = (IllegalArgumentException)FieldMapperTestCase2.expectThrows(IllegalArgumentException.class, () -> FieldMapperTestCase2.lambda$testMergeConflicts$14(mapper, (FieldMapper)toMerge));
        FieldMapperTestCase2.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"cannot be changed from type"));
        FieldMapperTestCase2.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"bogustype"));
        for (Modifier modifier : this.modifiers) {
            if (this.unsupportedProperties().contains(modifier.property)) continue;
            builder1 = this.newBuilder();
            builder2 = this.newBuilder();
            modifier.apply(builder1, builder2);
            FieldMapper mapper2 = (FieldMapper)builder1.build(context);
            FieldMapper toMerge2 = (FieldMapper)builder2.build(context);
            if (modifier.updateable) {
                mapper2.merge((Mapper)toMerge2);
                continue;
            }
            IllegalArgumentException e2 = (IllegalArgumentException)FieldMapperTestCase2.expectThrows(IllegalArgumentException.class, (String)("Expected an error when merging property difference " + modifier.property), () -> mapper2.merge((Mapper)toMerge2));
            FieldMapperTestCase2.assertThat((Object)e2.getMessage(), (Matcher)Matchers.containsString((String)modifier.property));
        }
    }

    public final void testSerialization() throws IOException {
        for (Modifier modifier : this.modifiers) {
            if (this.unsupportedProperties().contains(modifier.property)) continue;
            T builder1 = this.newBuilder();
            T builder2 = this.newBuilder();
            modifier.apply(builder1, builder2);
            this.assertSerializes(builder1);
            this.assertSerializes(builder2);
        }
        this.assertSerializationWarnings();
    }

    protected void assertSerializationWarnings() {
    }

    protected void assertSerializes(T builder) throws IOException {
        Mapper.BuilderContext context = new Mapper.BuilderContext(this.getIndexSettings(), new ContentPath(1));
        XContentBuilder mappings = this.mappingsToJson((ToXContent)builder.build(context), false);
        XContentBuilder mappingsWithDefault = this.mappingsToJson((ToXContent)builder.build(context), true);
        MapperService mapperService = this.createMapperService(mappings);
        Mapper rebuilt = mapperService.documentMapper().mappers().getMapper(((FieldMapper.Builder)builder).name);
        XContentBuilder reparsed = this.mappingsToJson((ToXContent)rebuilt, false);
        XContentBuilder reparsedWithDefault = this.mappingsToJson((ToXContent)rebuilt, true);
        FieldMapperTestCase2.assertThat((Object)reparsed.toString(), (Matcher)Matchers.equalTo((Object)mappings.toString()));
        FieldMapperTestCase2.assertThat((Object)reparsedWithDefault.toString(), (Matcher)Matchers.equalTo((Object)mappingsWithDefault.toString()));
    }

    private XContentBuilder mappingsToJson(ToXContent builder, boolean includeDefaults) throws IOException {
        ToXContent.Params params = includeDefaults ? new ToXContent.MapParams(Collections.singletonMap("include_defaults", "true")) : ToXContent.EMPTY_PARAMS;
        return this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> builder.toXContent(b, params)));
    }

    @Override
    public void testMinimalToMaximal() {
        FieldMapperTestCase2.assumeFalse((String)"`include_defaults` includes unsupported properties in non-parametrized mappers", (boolean)false);
    }

    private static /* synthetic */ void lambda$testMergeConflicts$14(FieldMapper mapper, FieldMapper toMerge) throws Throwable {
        mapper.merge((Mapper)toMerge);
    }

    private final class Modifier {
        final String property;
        final boolean updateable;
        final BiConsumer<T, T> modifier;

        Modifier(String property, boolean updateable, BiConsumer<T, T> modifier) {
            this.property = property;
            this.updateable = updateable;
            this.modifier = modifier;
        }

        void apply(T first, T second) {
            this.modifier.accept(first, second);
        }
    }
}

