/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.ingest.IngestDocument;

public class IngestDocumentMatcher {
    public static void assertIngestDocument(IngestDocument docA, IngestDocument docB) {
        if (!(IngestDocumentMatcher.deepEquals(docA.getIngestMetadata(), docB.getIngestMetadata(), true) && IngestDocumentMatcher.deepEquals(docA.getSourceAndMetadata(), docB.getSourceAndMetadata(), false))) {
            throw new AssertionError((Object)("Expected [" + docA + "] but received [" + docB + "]."));
        }
    }

    private static boolean deepEquals(Object a, Object b, boolean isIngestMeta) {
        if (a instanceof Map) {
            Map mapA = (Map)a;
            if (!(b instanceof Map)) {
                return false;
            }
            Map mapB = (Map)b;
            if (mapA.size() != mapB.size()) {
                return false;
            }
            for (Map.Entry entry : mapA.entrySet()) {
                Object key = entry.getKey();
                if (isIngestMeta && "timestamp".equals(key) || IngestDocumentMatcher.deepEquals(entry.getValue(), mapB.get(key), false)) continue;
                return false;
            }
            return true;
        }
        if (a instanceof List) {
            List listA = (List)a;
            if (!(b instanceof List)) {
                return false;
            }
            List listB = (List)b;
            int countA = listA.size();
            if (countA != listB.size()) {
                return false;
            }
            for (int i = 0; i < countA; ++i) {
                Object value = listA.get(i);
                if (IngestDocumentMatcher.deepEquals(value, listB.get(i), false)) continue;
                return false;
            }
            return true;
        }
        return Objects.deepEquals(a, b);
    }
}

