/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.search.SearchService;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.ParameterizedOpenSearchIntegTestCase;

@OpenSearchIntegTestCase.SuiteScopeTestCase
public abstract class AbstractNumericTestCase
extends ParameterizedOpenSearchIntegTestCase {
    protected static long minValue;
    protected static long maxValue;
    protected static long minValues;
    protected static long maxValues;

    public AbstractNumericTestCase(Settings dynamicSettings) {
        super(dynamicSettings);
    }

    @ParametersFactory
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Settings.builder().put(SearchService.CLUSTER_CONCURRENT_SEGMENT_SEARCH_SETTING.getKey(), false).build()}, {Settings.builder().put(SearchService.CLUSTER_CONCURRENT_SEGMENT_SEARCH_SETTING.getKey(), true).build()});
    }

    @Override
    protected Settings featureFlagSettings() {
        return Settings.builder().put(super.featureFlagSettings()).put("opensearch.experimental.feature.concurrent_segment_search.enabled", "true").build();
    }

    @Override
    public void setupSuiteScopeCluster() throws Exception {
        int i;
        this.createIndex("idx");
        this.createIndex("idx_unmapped");
        ArrayList<Object> builders = new ArrayList<IndexRequestBuilder>();
        int numDocs = 10;
        for (i = 0; i < 10; ++i) {
            builders.add(AbstractNumericTestCase.client().prepareIndex("idx").setId(String.valueOf(i)).setSource(XContentFactory.jsonBuilder().startObject().field("value", i + 1).startArray("values").value(i + 2).value(i + 3).endArray().endObject()));
        }
        minValue = 1L;
        minValues = 2L;
        maxValue = 10L;
        maxValues = 12L;
        this.indexRandom(true, builders);
        this.prepareCreate("empty_bucket_idx").setMapping(new String[]{"value", "type=integer"}).execute().actionGet();
        builders = new ArrayList();
        for (i = 0; i < 2; ++i) {
            builders.add(AbstractNumericTestCase.client().prepareIndex("empty_bucket_idx").setId(String.valueOf(i)).setSource(XContentFactory.jsonBuilder().startObject().field("value", i * 2).endObject()));
        }
        this.indexRandom(true, builders);
        this.ensureSearchable(new String[0]);
    }

    public void testEmptyAggregation() throws Exception {
    }

    public void testUnmapped() throws Exception {
    }

    public void testSingleValuedField() throws Exception {
    }

    public void testSingleValuedFieldGetProperty() throws Exception {
    }

    public void testSingleValuedFieldPartiallyUnmapped() throws Exception {
    }

    public void testSingleValuedFieldWithValueScript() throws Exception {
    }

    public void testSingleValuedFieldWithValueScriptWithParams() throws Exception {
    }

    public void testMultiValuedField() throws Exception {
    }

    public void testMultiValuedFieldWithValueScript() throws Exception {
    }

    public void testMultiValuedFieldWithValueScriptWithParams() throws Exception {
    }

    public void testScriptSingleValued() throws Exception {
    }

    public void testScriptSingleValuedWithParams() throws Exception {
    }

    public void testScriptMultiValued() throws Exception {
    }

    public void testScriptMultiValuedWithParams() throws Exception {
    }

    public void testOrderByEmptyAggregation() throws Exception {
    }
}

