/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentGenerator;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.index.query.support.QueryParsers;
import org.opensearch.test.AbstractBuilderTestCase;
import org.opensearch.test.EqualsHashCodeTestUtils;

public abstract class AbstractQueryTestCase<QB extends AbstractQueryBuilder<QB>>
extends AbstractBuilderTestCase {
    private static final int NUMBER_OF_TESTQUERIES = 20;

    public final QB createTestQueryBuilder() {
        return this.createTestQueryBuilder(this.supportsBoost(), this.supportsQueryName());
    }

    public final QB createTestQueryBuilder(boolean supportsBoost, boolean supportsQueryName) {
        QB query = this.doCreateTestQueryBuilder();
        if (supportsBoost && AbstractQueryTestCase.randomBoolean()) {
            query.boost(2.0f / (float)AbstractQueryTestCase.randomIntBetween(1, 20));
        }
        if (supportsQueryName && AbstractQueryTestCase.randomBoolean()) {
            query.queryName(AbstractQueryTestCase.createUniqueRandomName());
        }
        return query;
    }

    protected abstract QB doCreateTestQueryBuilder();

    public void testNegativeBoosts() {
        Object testQuery = this.createTestQueryBuilder();
        IllegalArgumentException exc = (IllegalArgumentException)AbstractQueryTestCase.expectThrows(IllegalArgumentException.class, () -> testQuery.boost(-0.5f));
        AbstractQueryTestCase.assertThat((Object)exc.getMessage(), (Matcher)Matchers.containsString((String)"negative [boost]"));
    }

    public void testFromXContent() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            XContentType xContentType = AbstractQueryTestCase.randomFrom(XContentType.values());
            BytesReference shuffledXContent = this.toShuffledXContent((ToXContent)testQuery, xContentType, ToXContent.EMPTY_PARAMS, AbstractQueryTestCase.randomBoolean(), this.shuffleProtectedFields());
            this.assertParsedQuery(this.createParser(xContentType.xContent(), shuffledXContent), (QueryBuilder)testQuery);
            for (Map.Entry<String, QB> alternateVersion : this.getAlternateVersions().entrySet()) {
                String queryAsString = alternateVersion.getKey();
                this.assertParsedQuery(this.createParser((XContent)JsonXContent.jsonXContent, queryAsString), (QueryBuilder)alternateVersion.getValue());
            }
        }
    }

    protected String[] shuffleProtectedFields() {
        return Strings.EMPTY_ARRAY;
    }

    public void testUnknownField() throws IOException {
        QB testQuery;
        String marker = "#marker#";
        while ((testQuery = this.createTestQueryBuilder()).toString().contains(marker)) {
        }
        testQuery.queryName(marker);
        String queryAsString = testQuery.toString().replace("\"" + marker + "\"", "\"" + marker + "\", \"bogusField\" : \"someValue\"");
        try {
            this.parseQuery(queryAsString);
            AbstractQueryTestCase.fail((String)"expected ParsingException or XContentParsingException");
        }
        catch (ParsingException | XContentParseException e) {
            AbstractQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"bogusField"));
        }
    }

    public void testUnknownObjectException() throws IOException {
        HashSet<String> candidates = new HashSet<String>();
        candidates.add(this.createTestQueryBuilder().toString());
        candidates.addAll(this.getAlternateVersions().keySet());
        List<Tuple<String, Boolean>> testQueries = AbstractQueryTestCase.alterateQueries(candidates, this.getObjectsHoldingArbitraryContent());
        for (Tuple<String, Boolean> testQuery : testQueries) {
            boolean expectedException = (Boolean)testQuery.v2();
            try {
                this.parseQuery((String)testQuery.v1());
                if (!expectedException) continue;
                AbstractQueryTestCase.fail((String)("some parsing exception expected for query: " + testQuery));
            }
            catch (OpenSearchParseException | ParsingException | XContentParseException e) {
                if (!expectedException) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
            }
            catch (IllegalArgumentException e) {
                if (!expectedException) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
                AbstractQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unknown field [newField]"));
            }
        }
    }

    static List<Tuple<String, Boolean>> alterateQueries(Set<String> queries, Set<String> arbitraryMarkers) throws IOException {
        ArrayList<Tuple<String, Boolean>> results = new ArrayList<Tuple<String, Boolean>>();
        boolean hasArbitraryContent = arbitraryMarkers != null && !arbitraryMarkers.isEmpty();
        block12: for (String query : queries) {
            int mutation = 0;
            while (true) {
                boolean expectException = true;
                BytesStreamOutput out = new BytesStreamOutput();
                XContentGenerator generator = MediaTypeRegistry.JSON.xContent().createGenerator((OutputStream)out);
                try {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, query);
                    try {
                        XContentParser.Token token;
                        int objectIndex = -1;
                        LinkedList<String> levels = new LinkedList<String>();
                        block14: while ((token = parser.nextToken()) != null) {
                            if (token == XContentParser.Token.START_ARRAY) {
                                levels.addLast(parser.currentName());
                            } else if (token == XContentParser.Token.START_OBJECT) {
                                levels.addLast(parser.currentName());
                                if (++objectIndex == mutation) {
                                    generator.writeStartObject();
                                    generator.writeFieldName("newField");
                                    generator.copyCurrentStructure(parser);
                                    generator.writeEndObject();
                                    if (!hasArbitraryContent) continue;
                                    for (String marker : arbitraryMarkers) {
                                        if (!levels.contains(marker)) continue;
                                        expectException = false;
                                        continue block14;
                                    }
                                    continue;
                                }
                            } else if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                                levels.removeLast();
                            }
                            generator.copyCurrentEvent(parser);
                        }
                        if (objectIndex < mutation) continue block12;
                        ++mutation;
                    }
                    finally {
                        if (parser == null) continue block12;
                        parser.close();
                        continue block12;
                    }
                }
                finally {
                    if (generator == null) continue block12;
                    generator.close();
                    continue block12;
                }
                results.add((Tuple<String, Boolean>)new Tuple((Object)out.bytes().utf8ToString(), (Object)expectException));
            }
        }
        return results;
    }

    protected Set<String> getObjectsHoldingArbitraryContent() {
        return Collections.emptySet();
    }

    public final void testQueryWrappedInArray() {
        QB queryBuilder = this.createTestQueryBuilder();
        String queryName = queryBuilder.getName();
        String validQuery = queryBuilder.toString();
        this.queryWrappedInArrayTest(queryName, validQuery);
        for (String query : this.getAlternateVersions().keySet()) {
            this.queryWrappedInArrayTest(queryName, query);
        }
    }

    private void queryWrappedInArrayTest(String queryName, String validQuery) {
        int endArrayPosition;
        int insertionPosition;
        int i = validQuery.indexOf("\"" + queryName + "\"");
        AbstractQueryTestCase.assertThat((Object)i, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (insertionPosition = i; insertionPosition < validQuery.length() && validQuery.charAt(insertionPosition) != ':'; ++insertionPosition) {
        }
        ++insertionPosition;
        for (endArrayPosition = validQuery.length() - 1; endArrayPosition >= 0 && validQuery.charAt(endArrayPosition) != '}'; --endArrayPosition) {
        }
        String testQuery = validQuery.substring(0, insertionPosition) + "[" + validQuery.substring(insertionPosition, endArrayPosition) + "]" + validQuery.substring(endArrayPosition, validQuery.length());
        ParsingException e = (ParsingException)AbstractQueryTestCase.expectThrows(ParsingException.class, () -> this.parseQuery(testQuery));
        AbstractQueryTestCase.assertEquals((Object)("[" + queryName + "] query malformed, no start_object after query name"), (Object)e.getMessage());
    }

    protected Map<String, QB> getAlternateVersions() {
        return Collections.emptyMap();
    }

    protected void assertParsedQuery(String queryAsString, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = this.parseQuery(queryAsString);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    private void assertParsedQuery(XContentParser parser, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = this.parseQuery(parser);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    protected QueryBuilder parseQuery(AbstractQueryBuilder<?> builder) throws IOException {
        BytesReference bytes = XContentHelper.toXContent(builder, (MediaType)MediaTypeRegistry.JSON, (boolean)false);
        return this.parseQuery(this.createParser((XContent)JsonXContent.jsonXContent, bytes));
    }

    protected QueryBuilder parseQuery(String queryAsString) throws IOException {
        XContentParser parser = this.createParser((XContent)JsonXContent.jsonXContent, queryAsString);
        return this.parseQuery(parser);
    }

    protected QueryBuilder parseQuery(XContentParser parser) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        AbstractQueryTestCase.assertNull((Object)parser.nextToken());
        return parseInnerQueryBuilder;
    }

    protected boolean builderGeneratesCacheableQueries() {
        return true;
    }

    public void testToQuery() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QueryShardContext context = AbstractQueryTestCase.createShardContext();
            assert (context.isCacheable());
            context.setAllowUnmappedFields(true);
            QB firstQuery = this.createTestQueryBuilder();
            QB controlQuery = this.copyQuery(firstQuery);
            QueryBuilder rewritten = this.rewriteQuery(firstQuery, (QueryRewriteContext)new QueryShardContext(context));
            Query firstLuceneQuery = rewritten.toQuery(context);
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)firstLuceneQuery);
            this.assertLuceneQuery(firstQuery, firstLuceneQuery, context);
            AbstractQueryTestCase.assertTrue((String)("query is not equal to its copy after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (boolean)firstQuery.equals(controlQuery));
            AbstractQueryTestCase.assertTrue((String)("equals is not symmetric after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (boolean)controlQuery.equals(firstQuery));
            AbstractQueryTestCase.assertThat((String)("query copy's hashcode is different from original hashcode after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (Object)controlQuery.hashCode(), (Matcher)CoreMatchers.equalTo((Object)firstQuery.hashCode()));
            QB secondQuery = this.copyQuery(firstQuery);
            if (AbstractQueryTestCase.randomBoolean()) {
                secondQuery.queryName((String)(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)));
            }
            context = new QueryShardContext(context);
            Query secondLuceneQuery = this.rewriteQuery(secondQuery, (QueryRewriteContext)context).toQuery(context);
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)secondLuceneQuery);
            this.assertLuceneQuery(secondQuery, secondLuceneQuery, context);
            if (this.builderGeneratesCacheableQueries()) {
                AbstractQueryTestCase.assertEquals((String)"two equivalent query builders lead to different lucene queries hashcode", (long)secondLuceneQuery.hashCode(), (long)firstLuceneQuery.hashCode());
                AbstractQueryTestCase.assertEquals((String)"two equivalent query builders lead to different lucene queries", (Object)this.rewrite(secondLuceneQuery), (Object)this.rewrite(firstLuceneQuery));
            }
            if (!this.supportsBoost() || firstLuceneQuery instanceof MatchNoDocsQuery) continue;
            secondQuery.boost(firstQuery.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
            Query thirdLuceneQuery = this.rewriteQuery(secondQuery, (QueryRewriteContext)context).toQuery(context);
            AbstractQueryTestCase.assertNotEquals((String)"modifying the boost doesn't affect the corresponding lucene query", (Object)this.rewrite(firstLuceneQuery), (Object)this.rewrite(thirdLuceneQuery));
        }
    }

    protected QueryBuilder rewriteQuery(QB queryBuilder, QueryRewriteContext rewriteContext) throws IOException {
        QueryBuilder rewritten = this.rewriteAndFetch((QueryBuilder)queryBuilder, rewriteContext);
        this.assertSerialization(rewritten);
        return rewritten;
    }

    protected boolean supportsBoost() {
        return true;
    }

    protected boolean supportsQueryName() {
        return true;
    }

    private void assertLuceneQuery(QB queryBuilder, Query query, QueryShardContext context) throws IOException {
        if (queryBuilder.queryName() != null && !(query instanceof MatchNoDocsQuery)) {
            Query namedQuery = (Query)context.copyNamedQueries().get(queryBuilder.queryName());
            AbstractQueryTestCase.assertThat((Object)namedQuery, (Matcher)CoreMatchers.equalTo((Object)query));
        }
        if (query != null && queryBuilder.boost() != 1.0f) {
            AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.either((Matcher)Matchers.instanceOf(BoostQuery.class)).or(Matchers.instanceOf(MatchNoDocsQuery.class)));
            if (query instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query;
                if (!(boostQuery.getQuery() instanceof MatchNoDocsQuery)) {
                    AbstractQueryTestCase.assertThat((Object)Float.valueOf(boostQuery.getBoost()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(queryBuilder.boost())));
                }
                query = boostQuery.getQuery();
            }
        }
        this.doAssertLuceneQuery(queryBuilder, query, context);
    }

    protected abstract void doAssertLuceneQuery(QB var1, Query var2, QueryShardContext var3) throws IOException;

    protected void assertTermOrBoostQuery(Query query, String field, String value, float fieldBoost) {
        if (fieldBoost != 1.0f) {
            AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(BoostQuery.class));
            BoostQuery boostQuery = (BoostQuery)query;
            AbstractQueryTestCase.assertThat((Object)Float.valueOf(boostQuery.getBoost()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(fieldBoost)));
            query = boostQuery.getQuery();
        }
        this.assertTermQuery(query, field, value);
    }

    protected void assertTermQuery(Query query, String field, String value) {
        AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(TermQuery.class));
        TermQuery termQuery = (TermQuery)query;
        String expectedFieldName = AbstractQueryTestCase.expectedFieldName(field);
        AbstractQueryTestCase.assertThat((Object)termQuery.getTerm().field(), (Matcher)CoreMatchers.equalTo((Object)expectedFieldName));
        AbstractQueryTestCase.assertThat((Object)termQuery.getTerm().text().toLowerCase(Locale.ROOT), (Matcher)CoreMatchers.equalTo((Object)value.toLowerCase(Locale.ROOT)));
    }

    public void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            this.assertSerialization((QueryBuilder)testQuery);
        }
    }

    protected QueryBuilder assertSerialization(QueryBuilder testQuery) throws IOException {
        return this.assertSerialization(testQuery, Version.CURRENT);
    }

    protected QueryBuilder assertSerialization(QueryBuilder testQuery, Version version) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            QueryBuilder queryBuilder;
            output.setVersion(version);
            output.writeNamedWriteable((NamedWriteable)testQuery);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry());){
                in.setVersion(version);
                QueryBuilder deserializedQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
                AbstractQueryTestCase.assertEquals((Object)testQuery, (Object)deserializedQuery);
                AbstractQueryTestCase.assertEquals((long)testQuery.hashCode(), (long)deserializedQuery.hashCode());
                AbstractQueryTestCase.assertNotSame((Object)testQuery, (Object)deserializedQuery);
                queryBuilder = deserializedQuery;
            }
            return queryBuilder;
        }
    }

    public void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestQueryBuilder(), this::copyQuery, this::mutateInstance);
        }
    }

    public QB mutateInstance(QB instance) throws IOException {
        return this.changeNameOrBoost(instance);
    }

    public void testValidOutput() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            MediaType mediaType = MediaTypeRegistry.JSON;
            String toString = Strings.toString((MediaType)MediaTypeRegistry.JSON, testQuery);
            this.assertParsedQuery(this.createParser(mediaType.xContent(), toString), (QueryBuilder)testQuery);
            BytesReference bytes = XContentHelper.toXContent(testQuery, (MediaType)mediaType, (boolean)false);
            this.assertParsedQuery(this.createParser(mediaType.xContent(), bytes), (QueryBuilder)testQuery);
        }
    }

    protected QB changeNameOrBoost(QB original) throws IOException {
        QB secondQuery = this.copyQuery(original);
        if (AbstractQueryTestCase.randomBoolean()) {
            secondQuery.queryName((String)(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)));
        } else {
            secondQuery.boost(original.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
        }
        return secondQuery;
    }

    private QB copyQuery(QB query) throws IOException {
        Writeable.Reader reader = this.namedWriteableRegistry().getReader(QueryBuilder.class, query.getWriteableName());
        return (QB)((AbstractQueryBuilder)AbstractQueryTestCase.copyWriteable(query, this.namedWriteableRegistry(), reader));
    }

    protected static Object getRandomValueForFieldName(String fieldName) {
        Object value;
        switch (fieldName) {
            case "mapped_string": 
            case "mapped_string_alias": {
                if (AbstractQueryTestCase.rarely()) {
                    JsonStringEncoder encoder = JsonStringEncoder.getInstance();
                    value = new String(encoder.quoteAsString(AbstractQueryTestCase.randomUnicodeOfLength(10)));
                    break;
                }
                value = AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
                break;
            }
            case "mapped_int": {
                value = AbstractQueryTestCase.randomIntBetween(0, 10);
                break;
            }
            case "mapped_double": {
                value = 1.0 + AbstractQueryTestCase.randomDouble() * 9.0;
                break;
            }
            case "mapped_boolean": {
                value = AbstractQueryTestCase.randomBoolean();
                break;
            }
            case "mapped_date": {
                value = new DateTime(System.currentTimeMillis(), DateTimeZone.UTC).toString();
                break;
            }
            case "mapped_date_nanos": {
                value = Instant.now().toString();
                break;
            }
            default: {
                value = AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
            }
        }
        return value;
    }

    protected static String getRandomQueryText() {
        int terms = AbstractQueryTestCase.randomIntBetween(0, 3);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < terms; ++i) {
            builder.append(AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)).append(" ");
        }
        return builder.toString().trim();
    }

    protected static String getRandomFieldName() {
        if (AbstractQueryTestCase.randomBoolean()) {
            return AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
        }
        return AbstractQueryTestCase.randomFrom(MAPPED_LEAF_FIELD_NAMES);
    }

    protected static String getRandomRewriteMethod() {
        Object rewrite = AbstractQueryTestCase.randomBoolean() ? AbstractQueryTestCase.randomFrom(QueryParsers.CONSTANT_SCORE, QueryParsers.SCORING_BOOLEAN, QueryParsers.CONSTANT_SCORE_BOOLEAN).getPreferredName() : AbstractQueryTestCase.randomFrom(QueryParsers.TOP_TERMS, QueryParsers.TOP_TERMS_BOOST, QueryParsers.TOP_TERMS_BLENDED_FREQS).getPreferredName() + "1";
        return rewrite;
    }

    protected static Fuzziness randomFuzziness(String fieldName) {
        switch (fieldName) {
            case "mapped_int": {
                return Fuzziness.build((Object)AbstractQueryTestCase.randomIntBetween(3, 100));
            }
            case "mapped_double": {
                return Fuzziness.build((Object)Float.valueOf(1.0f + AbstractQueryTestCase.randomFloat() * 10.0f));
            }
            case "mapped_date": {
                return Fuzziness.build((Object)AbstractQueryTestCase.randomTimeValue());
            }
            case "mapped_date_nanos": {
                return Fuzziness.build((Object)AbstractQueryTestCase.randomTimeValue());
            }
        }
        if (AbstractQueryTestCase.randomBoolean()) {
            return Fuzziness.fromEdits((int)AbstractQueryTestCase.randomIntBetween(0, 2));
        }
        return Fuzziness.AUTO;
    }

    protected static String randomAnalyzer() {
        return AbstractQueryTestCase.randomFrom("simple", "standard", "keyword", "whitespace");
    }

    protected static String randomMinimumShouldMatch() {
        return AbstractQueryTestCase.randomFrom("1", "-1", "75%", "-25%", "2<75%", "2<-25%");
    }

    public static void checkGeneratedJson(String expected, QueryBuilder source) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        source.toXContent(builder, ToXContent.EMPTY_PARAMS);
        AbstractQueryTestCase.assertEquals((String)AbstractQueryTestCase.msg(expected, builder.toString()), (Object)expected.replaceAll("\\s+", ""), (Object)builder.toString().replaceAll("\\s+", ""));
    }

    private static String msg(String left, String right) {
        int size = Math.min(left.length(), right.length());
        StringBuilder builder = new StringBuilder("size: " + left.length() + " vs. " + right.length());
        builder.append(" content: <<");
        for (int i = 0; i < size; ++i) {
            if (left.charAt(i) != right.charAt(i)) {
                builder.append(">> ").append("until offset: ").append(i).append(" [").append(left.charAt(i)).append(" vs.").append(right.charAt(i)).append("] [").append((int)left.charAt(i)).append(" vs.").append((int)right.charAt(i)).append(']');
                return builder.toString();
            }
            builder.append(left.charAt(i));
        }
        if (left.length() != right.length()) {
            int leftEnd = Math.max(size, left.length()) - 1;
            int rightEnd = Math.max(size, right.length()) - 1;
            builder.append(">> ").append("until offset: ").append(size).append(" [").append(left.charAt(leftEnd)).append(" vs.").append(right.charAt(rightEnd)).append("] [").append((int)left.charAt(leftEnd)).append(" vs.").append((int)right.charAt(rightEnd)).append(']');
            return builder.toString();
        }
        return "";
    }

    public void testMustRewrite() throws IOException {
        QueryShardContext context = AbstractQueryTestCase.createShardContext();
        context.setAllowUnmappedFields(true);
        QB queryBuilder = this.createTestQueryBuilder();
        queryBuilder.toQuery(context);
    }

    protected Query rewrite(Query query) throws IOException {
        return query;
    }

    protected QueryBuilder rewriteAndFetch(QueryBuilder builder, QueryRewriteContext context) {
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)builder, (QueryRewriteContext)context, (ActionListener)future);
        return (QueryBuilder)future.actionGet();
    }

    public boolean isTextField(String fieldName) {
        return fieldName.equals("mapped_string") || fieldName.equals("mapped_string_alias");
    }

    public void testCacheability() throws IOException {
        QB queryBuilder = this.createTestQueryBuilder();
        QueryShardContext context = AbstractQueryTestCase.createShardContext();
        QueryBuilder rewriteQuery = this.rewriteQuery(queryBuilder, (QueryRewriteContext)new QueryShardContext(context));
        AbstractQueryTestCase.assertNotNull((Object)rewriteQuery.toQuery(context));
        AbstractQueryTestCase.assertTrue((String)("query should be cacheable: " + queryBuilder.toString()), (boolean)context.isCacheable());
    }
}

