/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.coordination.ClusterBootstrapService;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.common.Priority;
import org.opensearch.common.settings.FeatureFlagSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.Strings;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.discovery.SettingsBasedSeedHostsProvider;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;
import org.opensearch.node.MockNode;
import org.opensearch.node.Node;
import org.opensearch.node.NodeValidationException;
import org.opensearch.plugins.Plugin;
import org.opensearch.script.MockScriptService;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.MockHttpTransport;
import org.opensearch.test.NodeRoles;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.TestSearchContext;
import org.opensearch.test.hamcrest.OpenSearchAssertions;
import org.opensearch.test.telemetry.MockTelemetryPlugin;
import org.opensearch.test.telemetry.tracing.StrictCheckSpanProcessor;
import org.opensearch.transport.TransportSettings;

public abstract class OpenSearchSingleNodeTestCase
extends OpenSearchTestCase {
    private static Node NODE = null;

    protected void startNode(long seed) throws Exception {
        assert (NODE == null);
        NODE = (Node)RandomizedContext.current().runWithPrivateRandomness(seed, this::newNode);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)this.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().get();
        OpenSearchSingleNodeTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
        this.client().admin().indices().preparePutTemplate("one_shard_index_template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0)).get();
        this.client().admin().indices().preparePutTemplate("random-soft-deletes-template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(Settings.builder().put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), OpenSearchSingleNodeTestCase.between(0, 1000))).get();
    }

    private static void stopNode() throws IOException, InterruptedException {
        Node node = NODE;
        NODE = null;
        IOUtils.close((Closeable)node);
        if (node != null && !node.awaitClose(10L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Node couldn't close within 10 seconds.");
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        long seed = OpenSearchSingleNodeTestCase.random().nextLong();
        if (NODE == null) {
            this.startNode(seed);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.logger.trace("[{}#{}]: cleaning up after test", (Object)OpenSearchSingleNodeTestCase.getTestClass().getSimpleName(), (Object)this.getTestName());
        super.tearDown();
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)this.client().admin().indices().prepareDelete(new String[]{"*"}).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN).get());
        Metadata metadata = ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState().getMetadata();
        OpenSearchSingleNodeTestCase.assertThat((String)("test leaves persistent cluster metadata behind: " + metadata.persistentSettings().keySet()), (Object)metadata.persistentSettings().size(), (Matcher)Matchers.equalTo((Object)0));
        OpenSearchSingleNodeTestCase.assertThat((String)("test leaves transient cluster metadata behind: " + metadata.transientSettings().keySet()), (Object)metadata.transientSettings().size(), (Matcher)Matchers.equalTo((Object)0));
        GetIndexResponse indices = (GetIndexResponse)((GetIndexRequestBuilder)((GetIndexRequestBuilder)this.client().admin().indices().prepareGetIndex().setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN)).addIndices(new String[]{"*"})).get();
        OpenSearchSingleNodeTestCase.assertThat((String)("test leaves indices that were not deleted: " + Strings.arrayToCommaDelimitedString((Object[])indices.indices())), (Object)indices.indices(), (Matcher)Matchers.equalTo((Object)Strings.EMPTY_ARRAY));
        if (this.resetNodeAfterTest()) {
            assert (NODE != null);
            OpenSearchSingleNodeTestCase.stopNode();
            this.startNode(OpenSearchSingleNodeTestCase.random().nextLong());
        }
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        OpenSearchSingleNodeTestCase.stopNode();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        OpenSearchSingleNodeTestCase.stopNode();
        StrictCheckSpanProcessor.validateTracingStateOnShutdown();
    }

    protected boolean resetNodeAfterTest() {
        return false;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    @SafeVarargs
    protected final Collection<Class<? extends Plugin>> pluginList(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings nodeSettings() {
        return Settings.EMPTY;
    }

    protected boolean addMockHttpTransport() {
        return true;
    }

    private Node newNode() {
        Collection<Class<? extends Plugin>> plugins;
        Path tempDir = OpenSearchSingleNodeTestCase.createTempDir();
        String nodeName = this.nodeSettings().get(Node.NODE_NAME_SETTING.getKey(), "node_s_0");
        Settings.Builder settingsBuilder = Settings.builder().put(ClusterName.CLUSTER_NAME_SETTING.getKey(), InternalTestCluster.clusterName("single-node-cluster", OpenSearchSingleNodeTestCase.random().nextLong())).put(Environment.PATH_HOME_SETTING.getKey(), tempDir).put(Environment.PATH_REPO_SETTING.getKey(), tempDir.resolve("repo")).put(Environment.PATH_SHARED_DATA_SETTING.getKey(), OpenSearchSingleNodeTestCase.createTempDir().getParent()).put(Node.NODE_NAME_SETTING.getKey(), nodeName).put(OpenSearchExecutors.NODE_PROCESSORS_SETTING.getKey(), 1).put("transport.type", OpenSearchSingleNodeTestCase.getTestTransportType()).put(TransportSettings.PORT.getKey(), OpenSearchSingleNodeTestCase.getPortRange()).put(NodeRoles.dataNode()).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), OpenSearchSingleNodeTestCase.random().nextLong()).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b").put(HierarchyCircuitBreakerService.USE_REAL_MEMORY_USAGE_SETTING.getKey(), false).putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]).putList(ClusterBootstrapService.INITIAL_CLUSTER_MANAGER_NODES_SETTING.getKey(), new String[]{nodeName}).put(TelemetrySettings.TRACER_ENABLED_SETTING.getKey(), true).put(this.nodeSettings()).put(this.featureFlagSettings());
        if (Boolean.parseBoolean(settingsBuilder.get("opensearch.experimental.feature.concurrent_segment_search.enabled")) && settingsBuilder.get("search.concurrent.max_slice_count") == null) {
            settingsBuilder.put("search.concurrent.max_slice_count", 2);
        }
        if (!(plugins = this.getPlugins()).contains(OpenSearchSingleNodeTestCase.getTestTransportPlugin())) {
            plugins = new ArrayList<Class<? extends Plugin>>(plugins);
            plugins.add(OpenSearchSingleNodeTestCase.getTestTransportPlugin());
        }
        if (this.addMockHttpTransport()) {
            plugins.add(MockHttpTransport.TestPlugin.class);
        }
        plugins.add(MockScriptService.TestPlugin.class);
        plugins.add(MockTelemetryPlugin.class);
        MockNode node = new MockNode(settingsBuilder.build(), plugins, this.forbidPrivateIndexSettings());
        try {
            node.start();
        }
        catch (NodeValidationException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    public Client client() {
        return this.wrapClient(NODE.client());
    }

    public Client wrapClient(Client client) {
        return client;
    }

    protected Node node() {
        return NODE;
    }

    protected <T> T getInstanceFromNode(Class<T> clazz) {
        return (T)NODE.injector().getInstance(clazz);
    }

    protected IndexService createIndex(String index) {
        return this.createIndex(index, Settings.EMPTY);
    }

    protected IndexService createIndex(String index, Settings settings) {
        return this.createIndex(index, settings, null, (XContentBuilder)null);
    }

    @Deprecated
    protected IndexService createIndex(String index, Settings settings, String type, XContentBuilder mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (type != null && mappings != null) {
            createIndexRequestBuilder.setMapping(mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    @Deprecated
    protected IndexService createIndex(String index, Settings settings, String type, String ... mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (mappings != null) {
            createIndexRequestBuilder.setMapping(mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    protected IndexService createIndex(String index, CreateIndexRequestBuilder createIndexRequestBuilder) {
        OpenSearchAssertions.assertAcked((CreateIndexResponse)createIndexRequestBuilder.get());
        ClusterHealthResponse health = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])new String[]{index}).waitForYellowStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        OpenSearchSingleNodeTestCase.assertThat((Object)health.getStatus(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)ClusterHealthStatus.YELLOW));
        OpenSearchSingleNodeTestCase.assertThat((String)"Cluster must be a single node cluster", (Object)health.getNumberOfDataNodes(), (Matcher)Matchers.equalTo((Object)1));
        IndicesService instanceFromNode = this.getInstanceFromNode(IndicesService.class);
        return instanceFromNode.indexServiceSafe(this.resolveIndex(index));
    }

    public Index resolveIndex(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)this.client().admin().indices().prepareGetIndex().setIndices(new String[]{index})).get();
        OpenSearchSingleNodeTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey(index));
        String uuid = ((Settings)getIndexResponse.getSettings().get(index)).get("index.uuid");
        return new Index(index, uuid);
    }

    protected SearchContext createSearchContext(IndexService indexService) {
        BigArrays bigArrays = indexService.getBigArrays();
        return new TestSearchContext(bigArrays, indexService);
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureGreen timed out, cluster state:\n{}\n{}", (Object)((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState(), (Object)this.client().admin().cluster().preparePendingClusterTasks().get());
            OpenSearchSingleNodeTestCase.assertThat((String)"timed out waiting for green state", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        OpenSearchSingleNodeTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)ClusterHealthStatus.GREEN));
        this.logger.debug("indices {} are green", (Object)(indices.length == 0 ? "[_all]" : indices));
        return actionGet.getStatus();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.getInstanceFromNode(NamedXContentRegistry.class);
    }

    protected boolean forbidPrivateIndexSettings() {
        return true;
    }

    protected Settings featureFlagSettings() {
        Settings.Builder featureSettings = Settings.builder();
        for (Setting builtInFlag : FeatureFlagSettings.BUILT_IN_FEATURE_FLAGS) {
            featureSettings.put(builtInFlag.getKey(), builtInFlag.getDefaultRaw(Settings.EMPTY));
        }
        featureSettings.put(FeatureFlags.TELEMETRY_SETTING.getKey(), true);
        return featureSettings.build();
    }
}

