/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.CodepointSetGenerator;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestRuleMarkFailure;
import org.apache.lucene.tests.util.TestUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.opensearch.Version;
import org.opensearch.bootstrap.BootstrapForTesting;
import org.opensearch.client.Requests;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Numbers;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.io.PathUtilsForTesting;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.logging.DeprecatedMessage;
import org.opensearch.common.logging.HeaderWarning;
import org.opensearch.common.logging.HeaderWarningAppender;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.time.DateUtils;
import org.opensearch.common.time.FormatNames;
import org.opensearch.common.util.MockBigArrays;
import org.opensearch.common.util.MockPageCacheRecycler;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.env.TestEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.MockSearchService;
import org.opensearch.test.FeatureFlagSetter;
import org.opensearch.test.IndexSettingsModule;
import org.opensearch.test.junit.listeners.LoggingListener;
import org.opensearch.test.junit.listeners.ReproduceInfoPrinter;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.nio.MockNioTransportPlugin;

@Listeners(value={ReproduceInfoPrinter.class, LoggingListener.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakLingering(linger=5000)
@TimeoutSuite(millis=1200000)
@LuceneTestCase.SuppressSysoutChecks(bugUrl="we log a lot on purpose")
@LuceneTestCase.SuppressCodecs(value={"SimpleText", "Memory", "CheapBastard", "Direct", "Compressing", "FST50", "FSTOrd50", "TestBloomFilteredLucenePostings", "MockRandom", "BlockTreeOrds", "LuceneFixedGap", "LuceneVarGapFixedInterval", "LuceneVarGapDocFreqInterval", "Lucene50"})
@LuceneTestCase.SuppressReproduceLine
public abstract class OpenSearchTestCase
extends LuceneTestCase {
    protected static final List<String> JODA_TIMEZONE_IDS;
    protected static final List<String> JAVA_TIMEZONE_IDS;
    protected static final List<String> JAVA_ZONE_IDS;
    private static final AtomicInteger portGenerator;
    private static final Collection<String> nettyLoggedLeaks;
    private HeaderWarningAppender headerWarningAppender;
    public static final String TEST_WORKER_VM_ID;
    public static final String TEST_WORKER_SYS_PROPERTY = "org.gradle.test.worker";
    public static final String DEFAULT_TEST_WORKER_ID = "--not-gradle--";
    public static final String FIPS_SYSPROP = "tests.fips.enabled";
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ThreadContext threadContext;
    @Rule
    public RuleChain failureAndSuccessEvents = RuleChain.outerRule((TestRule)new TestRuleAdapter(){

        protected void afterIfSuccessful() throws Throwable {
            OpenSearchTestCase.this.afterIfSuccessful();
        }

        protected void afterAlways(List<Throwable> errors) throws Throwable {
            if (errors != null && !errors.isEmpty()) {
                boolean allAssumption = true;
                for (Throwable error : errors) {
                    if (error instanceof AssumptionViolatedException) continue;
                    allAssumption = false;
                    break;
                }
                if (!allAssumption) {
                    OpenSearchTestCase.this.afterIfFailed(errors);
                }
            }
            super.afterAlways(errors);
        }
    });
    private static final List<StatusData> statusData;
    public static final List<Exception> checkIndexFailures;
    private static final String[] TIME_SUFFIXES;
    private static final long AWAIT_BUSY_THRESHOLD = 1000L;
    private static final GeohashGenerator geohashGenerator;
    private static final NamedXContentRegistry DEFAULT_NAMED_X_CONTENT_REGISTRY;
    protected static final NamedWriteableRegistry DEFAULT_NAMED_WRITABLE_REGISTRY;

    @AfterClass
    public static void resetPortCounter() {
        portGenerator.set(0);
    }

    public void tearDown() throws Exception {
        FeatureFlagSetter.clear();
        super.tearDown();
    }

    @SuppressForbidden(reason="force log4j and netty sysprops")
    private static void setTestSysProps() {
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("io.netty.leakDetection.level", "paranoid");
    }

    public static TransportAddress buildNewFakeTransportAddress() {
        return new TransportAddress(TransportAddress.META_ADDRESS, portGenerator.incrementAndGet());
    }

    protected void afterIfFailed(List<Throwable> errors) {
    }

    protected void afterIfSuccessful() throws Exception {
    }

    @BeforeClass
    public static void setFileSystem() throws Exception {
        PathUtilsForTesting.setup();
    }

    @AfterClass
    public static void restoreFileSystem() throws Exception {
        PathUtilsForTesting.teardown();
    }

    @BeforeClass
    public static void setContentType() throws Exception {
        Requests.CONTENT_TYPE = OpenSearchTestCase.randomFrom(XContentType.values());
        Requests.INDEX_CONTENT_TYPE = (MediaType)OpenSearchTestCase.randomFrom(XContentType.values());
    }

    @AfterClass
    public static void restoreContentType() {
        Requests.CONTENT_TYPE = XContentType.SMILE;
        Requests.INDEX_CONTENT_TYPE = MediaTypeRegistry.JSON;
    }

    @BeforeClass
    public static void ensureSupportedLocale() {
        if (OpenSearchTestCase.isUnusableLocale()) {
            Logger logger = LogManager.getLogger(OpenSearchTestCase.class);
            logger.warn("Attempting to run tests in an unusable locale in a FIPS JVM. Certificate expiration validation will fail, switching to English. See: https://github.com/bcgit/bc-java/issues/405");
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    @Before
    public void setHeaderWarningAppender() {
        this.headerWarningAppender = HeaderWarningAppender.createAppender((String)"header_warning", null);
        this.headerWarningAppender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.opensearch.deprecation"), (Appender)this.headerWarningAppender);
    }

    @After
    public void removeHeaderWarningAppender() {
        if (this.headerWarningAppender != null) {
            Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.opensearch.deprecation"), (Appender)this.headerWarningAppender);
            this.headerWarningAppender = null;
        }
    }

    @Before
    public final void before() {
        this.logger.info("{}before test", (Object)this.getTestParamsForLogging());
        OpenSearchTestCase.assertNull((String)"Thread context initialized twice", (Object)this.threadContext);
        if (this.enableWarningsCheck()) {
            this.threadContext = new ThreadContext(Settings.EMPTY);
            HeaderWarning.setThreadContext((ThreadContext)this.threadContext);
        }
    }

    @AfterClass
    public static void clearAdditionalRoles() {
        DiscoveryNode.setAdditionalRoles(Collections.emptySet());
    }

    protected boolean enableWarningsCheck() {
        return true;
    }

    protected boolean enableJodaDeprecationWarningsCheck() {
        return false;
    }

    @After
    public final void after() throws Exception {
        OpenSearchTestCase.checkStaticState(false);
        if (this.threadContext != null) {
            this.ensureNoWarnings();
            HeaderWarning.removeThreadContext((ThreadContext)this.threadContext);
            this.threadContext = null;
        }
        this.ensureAllSearchContextsReleased();
        this.ensureCheckIndexPassed();
        DeprecatedMessage.resetDeprecatedMessageForTests();
        this.logger.info("{}after test", (Object)this.getTestParamsForLogging());
    }

    private String getTestParamsForLogging() {
        String name = this.getTestName();
        int start = name.indexOf(123);
        if (start < 0) {
            return "";
        }
        int end = name.lastIndexOf(125);
        if (end < 0) {
            return "";
        }
        return "[" + name.substring(start + 1, end) + "] ";
    }

    private void ensureNoWarnings() {
        try {
            List warnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            if (warnings != null) {
                List<String> filteredWarnings = new ArrayList<String>(warnings);
                if (!this.enableJodaDeprecationWarningsCheck()) {
                    filteredWarnings = this.filterJodaDeprecationWarnings(filteredWarnings);
                }
                if (!JvmInfo.jvmInfo().getBundledJdk()) {
                    filteredWarnings = filteredWarnings.stream().filter(k -> !k.contains("no-jdk distributions that do not bundle a JDK are deprecated and will be removed in a future release")).collect(Collectors.toList());
                }
                OpenSearchTestCase.assertThat((String)"unexpected warning headers", filteredWarnings, (Matcher)Matchers.empty());
            } else {
                OpenSearchTestCase.assertNull((String)"unexpected warning headers", (Object)warnings);
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    protected final void assertSettingDeprecationsAndWarnings(Setting<?>[] settings, String ... warnings) {
        this.assertSettingDeprecationsAndWarnings((String[])Arrays.stream(settings).map(Setting::getKey).toArray(String[]::new), warnings);
    }

    protected final void assertSettingDeprecationsAndWarnings(String[] settings, String ... warnings) {
        this.assertWarnings((String[])Stream.concat(Arrays.stream(settings).map(k -> "[" + k + "] setting was deprecated in OpenSearch and will be removed in a future release! See the breaking changes documentation for the next major version."), Arrays.stream(warnings)).toArray(String[]::new));
    }

    protected final void assertNoDeprecationWarnings() {
        List actualWarnings = (List)this.threadContext.getResponseHeaders().get("Warning");
        OpenSearchTestCase.assertTrue((String)"Found duplicate warnings logged", (actualWarnings == null ? 1 : 0) != 0);
    }

    protected final void assertWarnings(String ... expectedWarnings) {
        this.assertWarnings(true, expectedWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void allowedWarnings(String ... allowedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            List actualWarnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            if (actualWarnings == null) {
                return;
            }
            Set actualWarningValues = actualWarnings.stream().map(s -> HeaderWarning.extractWarningValueFromWarningHeader((String)s, (boolean)true)).map(HeaderWarning::escapeAndEncode).collect(Collectors.toSet());
            HashSet<String> expectedWarnings = new HashSet<String>(Arrays.asList(allowedWarnings));
            Set warningsNotExpected = Sets.difference(actualWarningValues, expectedWarnings);
            OpenSearchTestCase.assertThat((String)("Found " + warningsNotExpected.size() + " unexpected warnings\nExpected: " + expectedWarnings + "\nActual: " + actualWarningValues), (Object)warningsNotExpected.size(), (Matcher)Matchers.equalTo((Object)0));
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertWarnings(boolean stripXContentPosition, String ... expectedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            List actualWarnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            if (actualWarnings != null && !this.enableJodaDeprecationWarningsCheck()) {
                List<String> filteredWarnings = this.filterJodaDeprecationWarnings(actualWarnings);
                this.assertWarnings(stripXContentPosition, filteredWarnings, expectedWarnings);
            } else {
                this.assertWarnings(stripXContentPosition, actualWarnings, expectedWarnings);
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    private List<String> filterJodaDeprecationWarnings(List<String> actualWarnings) {
        return actualWarnings.stream().filter(m -> !m.contains("Use new java.time date format specifiers.")).collect(Collectors.toList());
    }

    private void assertWarnings(boolean stripXContentPosition, List<String> actualWarnings, String[] expectedWarnings) {
        OpenSearchTestCase.assertNotNull((String)("no warnings, expected: " + Arrays.asList(expectedWarnings)), actualWarnings);
        Set actualWarningValues = actualWarnings.stream().map(s -> HeaderWarning.extractWarningValueFromWarningHeader((String)s, (boolean)stripXContentPosition)).collect(Collectors.toSet());
        for (String msg : expectedWarnings) {
            OpenSearchTestCase.assertThat(actualWarningValues, (Matcher)Matchers.hasItem((Object)HeaderWarning.escapeAndEncode((String)msg)));
        }
        OpenSearchTestCase.assertEquals((String)("Expected " + expectedWarnings.length + " warnings but found " + actualWarnings.size() + "\nExpected: " + Arrays.asList(expectedWarnings) + "\nActual: " + actualWarnings), (long)expectedWarnings.length, (long)actualWarnings.size());
    }

    private void resetDeprecationLogger() {
        this.threadContext.stashContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkStaticState(boolean afterClass) throws Exception {
        if (afterClass) {
            MockPageCacheRecycler.ensureAllPagesAreReleased();
        }
        MockBigArrays.ensureAllArraysAreReleased();
        OpenSearchTestCase.assertThat((Object)StatusLogger.getLogger().getLevel(), (Matcher)Matchers.equalTo((Object)Level.WARN));
        Collection<Object> collection = statusData;
        synchronized (collection) {
            try {
                OpenSearchTestCase.assertThat(statusData.stream().map(status -> status.getMessage().getFormattedMessage()).collect(Collectors.toList()), (Matcher)Matchers.empty());
            }
            finally {
                statusData.clear();
            }
        }
        collection = nettyLoggedLeaks;
        synchronized (collection) {
            try {
                OpenSearchTestCase.assertThat(nettyLoggedLeaks, (Matcher)Matchers.empty());
            }
            finally {
                nettyLoggedLeaks.clear();
            }
        }
    }

    public final void ensureAllSearchContextsReleased() throws Exception {
        OpenSearchTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> MockSearchService.assertNoInFlightContext()));
    }

    @Before
    public final void resetCheckIndexStatus() throws Exception {
        checkIndexFailures.clear();
    }

    public final void ensureCheckIndexPassed() {
        if (!checkIndexFailures.isEmpty()) {
            AssertionError e = new AssertionError((Object)"at least one shard failed CheckIndex");
            for (Exception failure : checkIndexFailures) {
                ((Throwable)((Object)e)).addSuppressed(failure);
            }
            throw e;
        }
    }

    public static int scaledRandomIntBetween(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween((int)min, (int)max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomNumbers.randomIntBetween((Random)OpenSearchTestCase.random(), (int)min, (int)max);
    }

    public static long randomLongBetween(long min, long max) {
        return RandomNumbers.randomLongBetween((Random)OpenSearchTestCase.random(), (long)min, (long)max);
    }

    public static int iterations(int min, int max) {
        return OpenSearchTestCase.scaledRandomIntBetween(min, max);
    }

    public static int between(int min, int max) {
        return OpenSearchTestCase.randomIntBetween(min, max);
    }

    public static boolean frequently() {
        return !OpenSearchTestCase.rarely();
    }

    public static boolean randomBoolean() {
        return OpenSearchTestCase.random().nextBoolean();
    }

    public static byte randomByte() {
        return (byte)OpenSearchTestCase.random().nextInt();
    }

    public static byte[] randomByteArrayOfLength(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = OpenSearchTestCase.randomByte();
        }
        return bytes;
    }

    public static short randomShort() {
        return (short)OpenSearchTestCase.random().nextInt();
    }

    public static int randomInt() {
        return OpenSearchTestCase.random().nextInt();
    }

    public static long randomNonNegativeLong() {
        long randomLong = OpenSearchTestCase.randomLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    public static float randomFloat() {
        return OpenSearchTestCase.random().nextFloat();
    }

    public static double randomDouble() {
        return OpenSearchTestCase.random().nextDouble();
    }

    public static double randomDoubleBetween(double start, double end, boolean lowerInclusive) {
        double result = 0.0;
        if (start == -1.7976931348623157E308 || end == Double.MAX_VALUE) {
            result = Double.longBitsToDouble(OpenSearchTestCase.randomLong());
            while (result < start || result > end || Double.isNaN(result)) {
                result = Double.longBitsToDouble(OpenSearchTestCase.randomLong());
            }
        } else {
            result = OpenSearchTestCase.randomDouble();
            if (!lowerInclusive) {
                while (result <= 0.0) {
                    result = OpenSearchTestCase.randomDouble();
                }
            }
            result = result * end + (1.0 - result) * start;
        }
        return result;
    }

    public static long randomLong() {
        return OpenSearchTestCase.random().nextLong();
    }

    public static BigInteger randomUnsignedLong() {
        BigInteger value = OpenSearchTestCase.randomBigInteger().abs();
        while (value.compareTo(Numbers.MAX_UNSIGNED_LONG_VALUE) == 1) {
            value = value.subtract(Numbers.MAX_UNSIGNED_LONG_VALUE);
        }
        return value;
    }

    public static BigInteger randomBigInteger() {
        return new BigInteger(64, OpenSearchTestCase.random());
    }

    public static int randomInt(int max) {
        return RandomizedTest.randomInt((int)max);
    }

    public static <T> T randomFrom(T ... array) {
        return OpenSearchTestCase.randomFrom(OpenSearchTestCase.random(), array);
    }

    public static <T> T randomFrom(Random random, T ... array) {
        return (T)RandomPicks.randomFrom((Random)random, (Object[])array);
    }

    public static <T> T randomFrom(List<T> list) {
        return (T)RandomPicks.randomFrom((Random)OpenSearchTestCase.random(), list);
    }

    public static <T> T randomFrom(Collection<T> collection) {
        return OpenSearchTestCase.randomFrom(OpenSearchTestCase.random(), collection);
    }

    public static <T> T randomFrom(Random random, Collection<T> collection) {
        return (T)RandomPicks.randomFrom((Random)random, collection);
    }

    public static String randomAlphaOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomAsciiOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomAlphaOfLength(int codeUnits) {
        return RandomizedTest.randomAsciiOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomUnicodeOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLength((int)codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLength((int)codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLength((int)codePoints);
    }

    public static String replaceUnicodeControlCharacters(String uniCodeStr, String toReplaceWith) {
        return uniCodeStr.replaceAll("\\p{Cc}", toReplaceWith);
    }

    public static String replaceUnicodeControlCharacters(String uniCodeStr) {
        return OpenSearchTestCase.replaceUnicodeControlCharacters(uniCodeStr, " ");
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull, boolean allowEmpty) {
        if (allowNull && OpenSearchTestCase.random().nextBoolean()) {
            return null;
        }
        int arraySize = OpenSearchTestCase.randomIntBetween(allowEmpty ? 0 : 1, maxArraySize);
        String[] array = new String[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = RandomStrings.randomAsciiOfLength((Random)OpenSearchTestCase.random(), (int)stringSize);
        }
        return array;
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull) {
        return OpenSearchTestCase.generateRandomStringArray(maxArraySize, stringSize, allowNull, true);
    }

    public static <T> T[] randomArray(int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        return OpenSearchTestCase.randomArray(0, maxArraySize, arrayConstructor, valueConstructor);
    }

    public static <T> T[] randomArray(int minArraySize, int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        int size = OpenSearchTestCase.randomIntBetween(minArraySize, maxArraySize);
        T[] array = arrayConstructor.apply(size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = valueConstructor.get();
        }
        return array;
    }

    public static <T> List<T> randomList(int maxListSize, Supplier<T> valueConstructor) {
        return OpenSearchTestCase.randomList(0, maxListSize, valueConstructor);
    }

    public static <T> List<T> randomList(int minListSize, int maxListSize, Supplier<T> valueConstructor) {
        int size = OpenSearchTestCase.randomIntBetween(minListSize, maxListSize);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(valueConstructor.get());
        }
        return list;
    }

    public static String randomTimeValue(int lower, int upper, String ... suffixes) {
        return OpenSearchTestCase.randomIntBetween(lower, upper) + OpenSearchTestCase.randomFrom(suffixes);
    }

    public static String randomTimeValue(int lower, int upper) {
        return OpenSearchTestCase.randomTimeValue(lower, upper, TIME_SUFFIXES);
    }

    public static String randomTimeValue() {
        return OpenSearchTestCase.randomTimeValue(0, 1000);
    }

    public static String randomPositiveTimeValue() {
        return OpenSearchTestCase.randomTimeValue(1, 1000);
    }

    public static DateTimeZone randomDateTimeZone() {
        return DateTimeZone.forID((String)OpenSearchTestCase.randomFrom(JODA_TIMEZONE_IDS));
    }

    public static TimeZone randomTimeZone() {
        return TimeZone.getTimeZone(OpenSearchTestCase.randomJodaAndJavaSupportedTimezone(JAVA_TIMEZONE_IDS));
    }

    public static ZoneId randomZone() {
        return ZoneId.of(OpenSearchTestCase.randomJodaAndJavaSupportedTimezone(JAVA_ZONE_IDS));
    }

    private static String randomJodaAndJavaSupportedTimezone(List<String> zoneIds) {
        return OpenSearchTestCase.randomValueOtherThanMany(id -> !JODA_TIMEZONE_IDS.contains(id), () -> (String)OpenSearchTestCase.randomFrom(zoneIds));
    }

    public static String randomDateFormatterPattern() {
        EnumSet<FormatNames> formatNames = EnumSet.complementOf(EnumSet.of(FormatNames.WEEK_YEAR));
        return OpenSearchTestCase.randomFrom(formatNames).getSnakeCaseName();
    }

    public static <T> void maybeSet(Consumer<T> consumer, T value) {
        if (OpenSearchTestCase.randomBoolean()) {
            consumer.accept(value);
        }
    }

    public static <T> T randomValueOtherThan(T input, Supplier<T> randomSupplier) {
        return (T)OpenSearchTestCase.randomValueOtherThanMany(v -> Objects.equals(input, v), randomSupplier);
    }

    public static <T> T randomValueOtherThanMany(Predicate<T> input, Supplier<T> randomSupplier) {
        T randomValue = null;
        while (input.test(randomValue = (T)randomSupplier.get())) {
        }
        return randomValue;
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock) throws Exception {
        OpenSearchTestCase.assertBusy(codeBlock, 10L, TimeUnit.SECONDS);
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long iterations = Math.max(Math.round(Math.log10(maxTimeInMillis) / Math.log10(2.0)), 1L);
        long timeInMillis = 1L;
        long sum = 0L;
        ArrayList<AssertionError> failures = new ArrayList<AssertionError>();
        int i = 0;
        while ((long)i < iterations) {
            try {
                codeBlock.run();
                return;
            }
            catch (AssertionError e) {
                failures.add(e);
                sum += timeInMillis;
                Thread.sleep(timeInMillis);
                timeInMillis *= 2L;
                ++i;
            }
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        try {
            codeBlock.run();
        }
        catch (AssertionError e) {
            for (AssertionError failure : failures) {
                ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)failure));
            }
            throw e;
        }
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier) throws InterruptedException {
        return OpenSearchTestCase.waitUntil(breakSupplier, 10L, TimeUnit.SECONDS);
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier, long maxWaitTime, TimeUnit unit) throws InterruptedException {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakSupplier.getAsBoolean()) {
                return true;
            }
            Thread.sleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        return breakSupplier.getAsBoolean();
    }

    public static boolean terminate(ExecutorService ... services) {
        boolean terminated = true;
        for (ExecutorService service : services) {
            if (service == null) continue;
            terminated &= ThreadPool.terminate((ExecutorService)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        return terminated;
    }

    public static boolean terminate(ThreadPool threadPool) {
        return ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Path getDataPath(String relativePath) {
        try {
            return PathUtils.get((URI)((Object)((Object)this)).getClass().getResource(relativePath).toURI()).toAbsolutePath().normalize();
        }
        catch (Exception e) {
            throw new RuntimeException("resource not found: " + relativePath, e);
        }
    }

    public String[] tmpPaths() {
        int numPaths = TestUtil.nextInt((Random)OpenSearchTestCase.random(), (int)1, (int)3);
        String[] absPaths = new String[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            absPaths[i] = OpenSearchTestCase.createTempDir().toAbsolutePath().toString();
        }
        return absPaths;
    }

    public NodeEnvironment newNodeEnvironment() throws IOException {
        return this.newNodeEnvironment(Settings.EMPTY);
    }

    public Settings buildEnvSettings(Settings settings) {
        return Settings.builder().put(settings).put(Environment.PATH_HOME_SETTING.getKey(), OpenSearchTestCase.createTempDir().toAbsolutePath()).putList(Environment.PATH_DATA_SETTING.getKey(), this.tmpPaths()).build();
    }

    public NodeEnvironment newNodeEnvironment(Settings settings) throws IOException {
        Settings build = this.buildEnvSettings(settings);
        return new NodeEnvironment(build, TestEnvironment.newEnvironment(build));
    }

    public static Settings.Builder settings(Version version) {
        Settings.Builder builder = Settings.builder().put("index.version.created", version);
        return builder;
    }

    public static Settings.Builder remoteIndexSettings(Version version) {
        Settings.Builder builder = Settings.builder().put(FileCache.DATA_TO_FILE_CACHE_SIZE_RATIO_SETTING.getKey(), 5).put("index.version.created", version).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), IndexModule.Type.REMOTE_SNAPSHOT.getSettingsKey());
        return builder;
    }

    public static <T> List<T> randomSubsetOf(int size, T ... values) {
        ArrayList list = CollectionUtils.arrayAsArrayList((Object[])values);
        return OpenSearchTestCase.randomSubsetOf(size, list);
    }

    public static <T> List<T> randomSubsetOf(Collection<T> collection) {
        return OpenSearchTestCase.randomSubsetOf(OpenSearchTestCase.randomInt(collection.size()), collection);
    }

    public static <T> List<T> randomSubsetOf(int size, Collection<T> collection) {
        if (size > collection.size()) {
            throw new IllegalArgumentException("Can't pick " + size + " random objects from a collection of " + collection.size() + " objects");
        }
        ArrayList<T> tempList = new ArrayList<T>(collection);
        Collections.shuffle(tempList, OpenSearchTestCase.random());
        return tempList.subList(0, size);
    }

    public static <T> Set<T> randomUnique(Supplier<T> supplier, int targetCount) {
        HashSet<T> things = new HashSet<T>();
        int maxTries = targetCount * 10;
        for (int t = 0; t < maxTries; ++t) {
            if (things.size() == targetCount) {
                return things;
            }
            things.add(supplier.get());
        }
        return things;
    }

    public static String randomGeohash(int minPrecision, int maxPrecision) {
        return geohashGenerator.ofStringLength(OpenSearchTestCase.random(), minPrecision, maxPrecision);
    }

    public static String getTestTransportType() {
        return "mock-nio";
    }

    public static Class<? extends Plugin> getTestTransportPlugin() {
        return MockNioTransportPlugin.class;
    }

    @Deprecated
    protected final BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        BytesReference bytes = XContentHelper.toXContent((ToXContent)toXContent, (MediaType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
        try (XContentParser parser = this.createParser(xContentType.xContent(), bytes);){
            BytesReference bytesReference;
            block12: {
                XContentBuilder builder = OpenSearchTestCase.shuffleXContent(parser, OpenSearchTestCase.rarely(), exceptFieldNames);
                try {
                    bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    if (builder == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return bytesReference;
        }
    }

    protected final BytesReference toShuffledXContent(ToXContent toXContent, MediaType mediaType, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        BytesReference bytes = XContentHelper.toXContent((ToXContent)toXContent, (MediaType)mediaType, (ToXContent.Params)params, (boolean)humanReadable);
        try (XContentParser parser = this.createParser(mediaType.xContent(), bytes);){
            BytesReference bytesReference;
            block12: {
                XContentBuilder builder = OpenSearchTestCase.shuffleXContent(parser, OpenSearchTestCase.rarely(), exceptFieldNames);
                try {
                    bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    if (builder == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return bytesReference;
        }
    }

    protected final XContentBuilder shuffleXContent(XContentBuilder builder, String ... exceptFieldNames) throws IOException {
        try (XContentParser parser = this.createParser(builder);){
            XContentBuilder xContentBuilder = OpenSearchTestCase.shuffleXContent(parser, builder.isPrettyPrint(), exceptFieldNames);
            return xContentBuilder;
        }
    }

    public static XContentBuilder shuffleXContent(XContentParser parser, boolean prettyPrint, String ... exceptFieldNames) throws IOException {
        XContentParser.Token token;
        XContentBuilder xContentBuilder = MediaTypeRegistry.contentBuilder((MediaType)parser.contentType());
        if (prettyPrint) {
            xContentBuilder.prettyPrint();
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            List<Object> shuffledList = OpenSearchTestCase.shuffleList(parser.listOrderedMap(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
            return xContentBuilder.value(shuffledList);
        }
        LinkedHashMap<String, Object> shuffledMap = OpenSearchTestCase.shuffleMap((LinkedHashMap)parser.mapOrdered(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
        return xContentBuilder.map(shuffledMap);
    }

    private static List<Object> shuffleList(List<Object> list, Set<String> exceptFields) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object value : list) {
            if (value instanceof Map) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetList.add(OpenSearchTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List) {
                targetList.add(OpenSearchTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetList.add(value);
        }
        return targetList;
    }

    public static LinkedHashMap<String, Object> shuffleMap(LinkedHashMap<String, Object> map, Set<String> exceptFields) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
        Collections.shuffle(keys, OpenSearchTestCase.random());
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof Map && !exceptFields.contains(key)) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetMap.put(key, OpenSearchTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List && !exceptFields.contains(key)) {
                targetMap.put(key, OpenSearchTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        return OpenSearchTestCase.copyWriteable(original, namedWriteableRegistry, reader, Version.CURRENT);
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Version version) throws IOException {
        return OpenSearchTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> value.writeTo(out), reader, version);
    }

    public static <T extends NamedWriteable> T copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<T> categoryClass) throws IOException {
        return OpenSearchTestCase.copyNamedWriteable(original, namedWriteableRegistry, categoryClass, Version.CURRENT);
    }

    public static <T extends NamedWriteable> T copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<T> categoryClass, Version version) throws IOException {
        return OpenSearchTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> out.writeNamedWriteable(value), in -> in.readNamedWriteable(categoryClass), version);
    }

    protected static <T> T copyInstance(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Writer<T> writer, Writeable.Reader<T> reader, Version version) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            Object object;
            output.setVersion(version);
            writer.write((StreamOutput)output, original);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                in.setVersion(version);
                object = reader.read((StreamInput)in);
            }
            return (T)object;
        }
    }

    protected final XContentParser createParser(XContentBuilder builder) throws IOException {
        return this.createParser(builder.contentType().xContent(), BytesReference.bytes((XContentBuilder)builder));
    }

    protected final XContentParser createParser(XContent xContent, String data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, InputStream data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, byte[] data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        return this.createParser(this.xContentRegistry(), xContent, data);
    }

    protected final XContentParser createParser(NamedXContentRegistry namedXContentRegistry, XContent xContent, BytesReference data) throws IOException {
        if (data instanceof BytesArray) {
            BytesArray array = (BytesArray)data;
            return xContent.createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, array.array(), array.offset(), array.length());
        }
        return xContent.createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)data.streamInput());
    }

    protected NamedXContentRegistry xContentRegistry() {
        return DEFAULT_NAMED_X_CONTENT_REGISTRY;
    }

    protected NamedWriteableRegistry writableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    protected PersistedStateRegistry persistedStateRegistry() {
        return new PersistedStateRegistry();
    }

    public static Script mockScript(String id) {
        return new Script(ScriptType.INLINE, "mockscript", id, Collections.emptyMap());
    }

    public static TestRuleMarkFailure getSuiteFailureMarker() {
        return suiteFailureMarker;
    }

    public static void assertArrayEquals(StackTraceElement[] expected, StackTraceElement[] actual) {
        OpenSearchTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            OpenSearchTestCase.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        OpenSearchTestCase.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        OpenSearchTestCase.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        OpenSearchTestCase.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        OpenSearchTestCase.assertEquals((long)expected.getLineNumber(), (long)actual.getLineNumber());
        OpenSearchTestCase.assertEquals((Object)expected.isNativeMethod(), (Object)actual.isNativeMethod());
    }

    protected static long spinForAtLeastOneMillisecond() {
        return OpenSearchTestCase.spinForAtLeastNMilliseconds(1L);
    }

    protected static long spinForAtLeastNMilliseconds(long ms) {
        long elapsed;
        long nanosecondsInMillisecond = TimeUnit.NANOSECONDS.convert(ms, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        while ((elapsed = System.nanoTime() - start) < nanosecondsInMillisecond) {
        }
        return elapsed;
    }

    protected IndexAnalyzers createDefaultIndexAnalyzers() {
        return new IndexAnalyzers(Collections.singletonMap("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())), Collections.emptyMap(), Collections.emptyMap());
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings nodeSettings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), OpenSearchTestCase.createTempDir()).build();
        return OpenSearchTestCase.createTestAnalysis(index, nodeSettings, settings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings nodeSettings, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings indexSettings = Settings.builder().put(settings).put("index.version.created", Version.CURRENT).build();
        return OpenSearchTestCase.createTestAnalysis(IndexSettingsModule.newIndexSettings(index, indexSettings, new Setting[0]), nodeSettings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(IndexSettings indexSettings, Settings nodeSettings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Environment env = TestEnvironment.newEnvironment(nodeSettings);
        AnalysisModule analysisModule = new AnalysisModule(env, Arrays.asList(analysisPlugins));
        AnalysisRegistry analysisRegistry = analysisModule.getAnalysisRegistry();
        return new TestAnalysis(analysisRegistry.build(indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }

    private static boolean isUnusableLocale() {
        return OpenSearchTestCase.inFipsJvm() && (Locale.getDefault().toLanguageTag().equals("th-TH") || Locale.getDefault().toLanguageTag().equals("ja-JP-u-ca-japanese-x-lvariant-JP") || Locale.getDefault().toLanguageTag().equals("th-TH-u-nu-thai-x-lvariant-TH"));
    }

    public static boolean inFipsJvm() {
        return Boolean.parseBoolean(System.getProperty(FIPS_SYSPROP));
    }

    public static String getPortRange() {
        return OpenSearchTestCase.getBasePort() + "-" + (OpenSearchTestCase.getBasePort() + 99);
    }

    protected static int getBasePort() {
        int startAt;
        String workerIdStr = System.getProperty(TEST_WORKER_SYS_PROPERTY);
        if (workerIdStr == null) {
            startAt = 0;
        } else {
            long workerId = Long.valueOf(workerIdStr);
            assert (workerId >= 1L) : "Non positive gradle worker id: " + workerIdStr;
            startAt = (int)Math.floorMod(workerId - 1L, 223L) + 1;
        }
        assert (startAt >= 0) : "Unexpected test worker Id, resulting port range would be negative";
        return 10300 + startAt * 100;
    }

    protected static InetAddress randomIp(boolean v4) {
        try {
            if (v4) {
                byte[] ipv4 = new byte[4];
                OpenSearchTestCase.random().nextBytes(ipv4);
                return InetAddress.getByAddress(ipv4);
            }
            byte[] ipv6 = new byte[16];
            OpenSearchTestCase.random().nextBytes(ipv6);
            return InetAddress.getByAddress(ipv6);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    private static /* synthetic */ void lambda$static$0(Appender leakAppender) {
        leakAppender.stop();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configurator.shutdown((LoggerContext)context);
    }

    static {
        portGenerator = new AtomicInteger();
        nettyLoggedLeaks = new ArrayList<String>();
        TEST_WORKER_VM_ID = System.getProperty(TEST_WORKER_SYS_PROPERTY, DEFAULT_TEST_WORKER_ID);
        OpenSearchTestCase.setTestSysProps();
        String leakLoggerName = "io.netty.util.ResourceLeakDetector";
        Logger leakLogger = LogManager.getLogger((String)leakLoggerName);
        AbstractAppender leakAppender = new AbstractAppender(leakLoggerName, null, (Layout)PatternLayout.newBuilder().withPattern("%m").build()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void append(LogEvent event) {
                String message = event.getMessage().getFormattedMessage();
                if (Level.ERROR.equals((Object)event.getLevel()) && message.contains("LEAK:")) {
                    Collection<String> collection = nettyLoggedLeaks;
                    synchronized (collection) {
                        nettyLoggedLeaks.add(message);
                    }
                }
            }
        };
        leakAppender.start();
        Loggers.addAppender((Logger)leakLogger, (Appender)leakAppender);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> OpenSearchTestCase.lambda$static$0((Appender)leakAppender)));
        BootstrapForTesting.ensureInitialized();
        TransportService.ensureClassloaded();
        List jodaTZIds = DateTimeZone.getAvailableIDs().stream().filter(s -> !DateUtils.DEPRECATED_SHORT_TZ_IDS.contains(s)).sorted().collect(Collectors.toList());
        JODA_TIMEZONE_IDS = Collections.unmodifiableList(jodaTZIds);
        List<String> javaTZIds = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(javaTZIds);
        JAVA_TIMEZONE_IDS = Collections.unmodifiableList(javaTZIds);
        ArrayList<String> javaZoneIds = new ArrayList<String>(ZoneId.getAvailableZoneIds());
        Collections.sort(javaZoneIds);
        JAVA_ZONE_IDS = Collections.unmodifiableList(javaZoneIds);
        statusData = new ArrayList<StatusData>();
        StatusLogger.getLogger().setLevel(Level.WARN);
        StatusLogger.getLogger().registerListener((StatusListener)new StatusConsoleListener(Level.WARN){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(StatusData data) {
                List<StatusData> list = statusData;
                synchronized (list) {
                    statusData.add(data);
                }
            }
        });
        checkIndexFailures = new CopyOnWriteArrayList<Exception>();
        TIME_SUFFIXES = new String[]{"d", "h", "ms", "s", "m", "micros", "nanos"};
        geohashGenerator = new GeohashGenerator();
        DEFAULT_NAMED_X_CONTENT_REGISTRY = new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
        DEFAULT_NAMED_WRITABLE_REGISTRY = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    public static class GeohashGenerator
    extends CodepointSetGenerator {
        private static final char[] ASCII_SET = "0123456789bcdefghjkmnpqrstuvwxyz".toCharArray();

        public GeohashGenerator() {
            super(ASCII_SET);
        }
    }

    public static final class TestAnalysis {
        public final IndexAnalyzers indexAnalyzers;
        public final Map<String, TokenFilterFactory> tokenFilter;
        public final Map<String, TokenizerFactory> tokenizer;
        public final Map<String, CharFilterFactory> charFilter;

        public TestAnalysis(IndexAnalyzers indexAnalyzers, Map<String, TokenFilterFactory> tokenFilter, Map<String, TokenizerFactory> tokenizer, Map<String, CharFilterFactory> charFilter) {
            this.indexAnalyzers = indexAnalyzers;
            this.tokenFilter = tokenFilter;
            this.tokenizer = tokenizer;
            this.charFilter = charFilter;
        }
    }
}

