/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import org.junit.After;
import org.junit.Before;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.test.OpenSearchIntegTestCase;

public abstract class ParameterizedOpenSearchIntegTestCase
extends OpenSearchIntegTestCase {
    private final Settings dynamicSettings;

    public ParameterizedOpenSearchIntegTestCase(Settings dynamicSettings) {
        this.dynamicSettings = dynamicSettings;
    }

    @Before
    public void beforeTests() {
        SettingsModule settingsModule = new SettingsModule(this.dynamicSettings, new Setting[0]);
        for (String key : this.dynamicSettings.keySet()) {
            ParameterizedOpenSearchIntegTestCase.assertTrue((settingsModule.getClusterSettings().isDynamicSetting(key) || settingsModule.getIndexScopedSettings().isDynamicSetting(key) ? 1 : 0) != 0);
        }
        ParameterizedOpenSearchIntegTestCase.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(this.dynamicSettings).get();
    }

    @After
    public void afterTests() {
        Settings.Builder settingsToUnset = Settings.builder();
        this.dynamicSettings.keySet().forEach(arg_0 -> ((Settings.Builder)settingsToUnset).putNull(arg_0));
        ParameterizedOpenSearchIntegTestCase.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(settingsToUnset).get();
    }
}

