/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.Version;
import org.opensearch.common.UUIDs;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.test.OpenSearchTestCase;

public final class RemoteStoreTestUtils {
    private RemoteStoreTestUtils() {
    }

    public static InputStream createMetadataFileBytes(Map<String, String> segmentFilesMap, ReplicationCheckpoint replicationCheckpoint, SegmentInfos segmentInfos) throws IOException {
        ByteBuffersDataOutput byteBuffersIndexOutput = new ByteBuffersDataOutput();
        segmentInfos.write((IndexOutput)new ByteBuffersIndexOutput(byteBuffersIndexOutput, "", ""));
        byte[] byteArray = byteBuffersIndexOutput.toArrayCopy();
        BytesStreamOutput output = new BytesStreamOutput();
        OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("segment metadata", "metadata output stream", (OutputStream)output, 4096);
        CodecUtil.writeHeader((DataOutput)indexOutput, (String)"segment_md", (int)1);
        indexOutput.writeMapOfStrings(segmentFilesMap);
        RemoteSegmentMetadata.writeCheckpointToIndexOutput((ReplicationCheckpoint)replicationCheckpoint, (IndexOutput)indexOutput);
        indexOutput.writeLong((long)byteArray.length);
        indexOutput.writeBytes(byteArray, byteArray.length);
        CodecUtil.writeFooter((IndexOutput)indexOutput);
        indexOutput.close();
        return new ByteArrayInputStream(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    public static Map<String, String> getDummyMetadata(String prefix, int commitGeneration) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(prefix + ".cfe", prefix + ".cfe::" + prefix + ".cfe__" + UUIDs.base64UUID() + "::" + OpenSearchTestCase.randomIntBetween(1000, 5000) + "::" + OpenSearchTestCase.randomIntBetween(512000, 1024000) + "::" + Version.MIN_SUPPORTED_MAJOR);
        metadata.put(prefix + ".cfs", prefix + ".cfs::" + prefix + ".cfs__" + UUIDs.base64UUID() + "::" + OpenSearchTestCase.randomIntBetween(1000, 5000) + "::" + OpenSearchTestCase.randomIntBetween(512000, 1024000) + "::" + Version.MIN_SUPPORTED_MAJOR);
        metadata.put(prefix + ".si", prefix + ".si::" + prefix + ".si__" + UUIDs.base64UUID() + "::" + OpenSearchTestCase.randomIntBetween(1000, 5000) + "::" + OpenSearchTestCase.randomIntBetween(512000, 1024000) + "::" + Version.LATEST.major);
        metadata.put("segments_" + commitGeneration, "segments_" + commitGeneration + "::segments_" + commitGeneration + "__" + UUIDs.base64UUID() + "::" + OpenSearchTestCase.randomIntBetween(1000, 5000) + "::" + OpenSearchTestCase.randomIntBetween(1024, 5120) + "::" + Version.LATEST.major);
        return metadata;
    }
}

