/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.action.search.SearchType;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.ParsedQuery;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.aggregations.BucketCollectorProcessor;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.SearchContextAggregations;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchDocValuesContext;
import org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.ScriptFieldsContext;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.profile.Profilers;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.sort.SortAndFormats;
import org.opensearch.search.suggest.SuggestionSearchContext;
import org.opensearch.test.InternalAggregationTestCase;

public class TestSearchContext
extends SearchContext {
    public static final SearchShardTarget SHARD_TARGET = new SearchShardTarget("test", new ShardId("test", "test", 0), null, OriginalIndices.NONE);
    final BigArrays bigArrays;
    final IndexService indexService;
    final BitsetFilterCache fixedBitSetFilterCache;
    final Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers = new HashMap();
    final IndexShard indexShard;
    final QuerySearchResult queryResult = new QuerySearchResult();
    final QueryShardContext queryShardContext;
    ParsedQuery originalQuery;
    ParsedQuery postFilter;
    Query query;
    Float minScore;
    SearchShardTask task;
    SortAndFormats sort;
    boolean trackScores = false;
    int trackTotalHitsUpTo = 10000;
    ContextIndexSearcher searcher;
    int from;
    int size;
    private int terminateAfter = 0;
    private SearchContextAggregations aggregations;
    private ScrollContext scrollContext;
    private FieldDoc searchAfter;
    private Profilers profilers;
    private CollapseContext collapse;
    protected boolean concurrentSegmentSearchEnabled;
    private BucketCollectorProcessor bucketCollectorProcessor = NO_OP_BUCKET_COLLECTOR_PROCESSOR;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private ShardSearchRequest request;

    public void setConcurrentSegmentSearchEnabled(boolean concurrentSegmentSearchEnabled) {
        this.concurrentSegmentSearchEnabled = concurrentSegmentSearchEnabled;
    }

    public TestSearchContext(BigArrays bigArrays, IndexService indexService) {
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.indexService = indexService;
        this.fixedBitSetFilterCache = indexService.cache().bitsetFilterCache();
        this.indexShard = indexService.getShardOrNull(0);
        this.queryShardContext = indexService.newQueryShardContext(0, null, () -> 0L, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext) {
        this(queryShardContext, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard) {
        this(queryShardContext, indexShard, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard, ContextIndexSearcher searcher) {
        this(queryShardContext, indexShard, searcher, null);
    }

    public TestSearchContext(QueryShardContext queryShardContext, IndexShard indexShard, ContextIndexSearcher searcher, ScrollContext scrollContext) {
        this.bigArrays = null;
        this.indexService = null;
        this.fixedBitSetFilterCache = null;
        this.indexShard = indexShard;
        this.queryShardContext = queryShardContext;
        this.searcher = searcher;
        this.concurrentSegmentSearchEnabled = searcher != null && searcher.getExecutor() != null;
        this.scrollContext = scrollContext;
    }

    public void setSearcher(ContextIndexSearcher searcher) {
        this.searcher = searcher;
    }

    public void preProcess(boolean rewrite) {
    }

    public Query buildFilteredQuery(Query query) {
        return null;
    }

    public ShardSearchContextId id() {
        return new ShardSearchContextId("", 0L);
    }

    public String source() {
        return null;
    }

    public ShardSearchRequest request() {
        return this.request;
    }

    public void setShardSearchRequest(ShardSearchRequest request) {
        this.request = request;
    }

    public SearchType searchType() {
        return null;
    }

    public SearchShardTarget shardTarget() {
        return null;
    }

    public int numberOfShards() {
        return 1;
    }

    public float queryBoost() {
        return 0.0f;
    }

    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    public SearchHighlightContext highlight() {
        return null;
    }

    public void highlight(SearchHighlightContext highlight) {
    }

    public SuggestionSearchContext suggest() {
        return null;
    }

    public void suggest(SuggestionSearchContext suggest) {
    }

    public List<RescoreContext> rescore() {
        return Collections.emptyList();
    }

    public boolean hasScriptFields() {
        return false;
    }

    public ScriptFieldsContext scriptFields() {
        return null;
    }

    public boolean sourceRequested() {
        return false;
    }

    public boolean hasFetchSourceContext() {
        return false;
    }

    public FetchSourceContext fetchSourceContext() {
        return null;
    }

    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        return null;
    }

    public FetchDocValuesContext docValuesContext() {
        return null;
    }

    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        return null;
    }

    public FetchFieldsContext fetchFieldsContext() {
        return null;
    }

    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        return null;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    public MapperService mapperService() {
        if (this.indexService != null) {
            return this.indexService.mapperService();
        }
        return null;
    }

    public SimilarityService similarityService() {
        return null;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.fixedBitSetFilterCache;
    }

    public TimeValue timeout() {
        return TimeValue.ZERO;
    }

    public void timeout(TimeValue timeout) {
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public boolean lowLevelCancellation() {
        return false;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minScore;
    }

    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    public SortAndFormats sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    public SearchContext searchAfter(FieldDoc searchAfterDoc) {
        this.searchAfter = searchAfterDoc;
        return this;
    }

    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    public Query aliasFilter() {
        return null;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public int from() {
        return this.from;
    }

    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public SearchContext size(int size) {
        return null;
    }

    public boolean hasStoredFields() {
        return false;
    }

    public boolean hasStoredFieldsContext() {
        return false;
    }

    public boolean storedFieldsRequested() {
        return false;
    }

    public StoredFieldsContext storedFieldsContext() {
        return null;
    }

    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        return null;
    }

    public boolean explain() {
        return false;
    }

    public void explain(boolean explain) {
    }

    public List<String> groupStats() {
        return null;
    }

    public void groupStats(List<String> groupStats) {
    }

    public boolean version() {
        return false;
    }

    public void version(boolean version) {
    }

    public boolean seqNoAndPrimaryTerm() {
        return false;
    }

    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
    }

    public int[] docIdsToLoad() {
        return new int[0];
    }

    public int docIdsToLoadFrom() {
        return 0;
    }

    public int docIdsToLoadSize() {
        return 0;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        return null;
    }

    public DfsSearchResult dfsResult() {
        return null;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    public FetchPhase fetchPhase() {
        return null;
    }

    public MappedFieldType fieldType(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().fieldType(name);
        }
        return null;
    }

    public ObjectMapper getObjectMapper(String name) {
        if (this.mapperService() != null) {
            return this.mapperService().getObjectMapper(name);
        }
        return null;
    }

    public void doClose() {
    }

    public long getRelativeTimeInMillis() {
        return 0L;
    }

    public Profilers getProfilers() {
        return this.profilers;
    }

    public boolean shouldUseConcurrentSearch() {
        return this.concurrentSegmentSearchEnabled;
    }

    public Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers() {
        return this.queryCollectorManagers;
    }

    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    public SearchShardTask getTask() {
        return this.task;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public void addRescore(RescoreContext rescore) {
    }

    public ReaderContext readerContext() {
        throw new UnsupportedOperationException();
    }

    public InternalAggregation.ReduceContext partialOnShard() {
        return InternalAggregationTestCase.emptyReduceContextBuilder().forPartialReduction();
    }

    public void setBucketCollectorProcessor(BucketCollectorProcessor bucketCollectorProcessor) {
        this.bucketCollectorProcessor = bucketCollectorProcessor;
    }

    public BucketCollectorProcessor bucketCollectorProcessor() {
        return this.bucketCollectorProcessor;
    }

    public boolean shouldUseTimeSeriesDescSortOptimization() {
        return this.indexShard != null && this.indexShard.isTimeSeriesDescSortOptimizationEnabled() && this.sort != null && this.sort.isSortOnTimeSeriesField() && !this.sort.sort.getSort()[0].getReverse();
    }

    public TestSearchContext withCleanQueryResult() {
        this.queryResult.consumeAll();
        this.profilers = null;
        return this;
    }

    public TestSearchContext withProfilers() {
        this.profilers = new Profilers(this.searcher, this.concurrentSegmentSearchEnabled);
        return this;
    }
}

