/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.opensearch.Version;
import org.opensearch.client.Node;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.Response;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.WarningsHandler;
import org.opensearch.client.sniff.OpenSearchNodesSniffer;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.test.rest.OpenSearchRestTestCase;
import org.opensearch.test.rest.yaml.ClientYamlTestCandidate;
import org.opensearch.test.rest.yaml.ClientYamlTestClient;
import org.opensearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.opensearch.test.rest.yaml.ClientYamlTestResponse;
import org.opensearch.test.rest.yaml.DenylistedPathPatternMatcher;
import org.opensearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.opensearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;
import org.opensearch.test.rest.yaml.section.ClientYamlTestSection;
import org.opensearch.test.rest.yaml.section.ClientYamlTestSuite;
import org.opensearch.test.rest.yaml.section.ExecutableSection;

@TimeoutSuite(millis=1800000)
public abstract class OpenSearchClientYamlSuiteTestCase
extends OpenSearchRestTestCase {
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_DENYLIST = "tests.rest.denylist";
    public static final String REST_TESTS_DENYLIST_ADDITIONS = "tests.rest.denylist_additions";
    private static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    private static final String TESTS_PATH = "/rest-api-spec/test";
    private static final String SPEC_PATH = "/rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private static List<DenylistedPathPatternMatcher> denylistPathMatchers;
    private static ClientYamlTestExecutionContext restTestExecutionContext;
    private static ClientYamlTestExecutionContext adminExecutionContext;
    private static ClientYamlTestClient clientYamlTestClient;
    private final ClientYamlTestCandidate testCandidate;
    private static boolean useDefaultNumberOfShards;

    protected OpenSearchClientYamlSuiteTestCase(ClientYamlTestCandidate testCandidate) {
        this.testCandidate = testCandidate;
    }

    @BeforeClass
    public static void initializeUseDefaultNumberOfShards() {
        useDefaultNumberOfShards = OpenSearchClientYamlSuiteTestCase.usually();
    }

    @Before
    public void initAndResetContext() throws Exception {
        if (restTestExecutionContext == null) {
            String[] denylistAdditions;
            assert (adminExecutionContext == null);
            assert (denylistPathMatchers == null);
            ClientYamlSuiteRestSpec restSpec = ClientYamlSuiteRestSpec.load(SPEC_PATH);
            OpenSearchClientYamlSuiteTestCase.validateSpec(restSpec);
            List<HttpHost> hosts = this.getClusterHosts();
            Tuple<Version, Version> versionVersionTuple = this.readVersionsFromCatNodes(OpenSearchClientYamlSuiteTestCase.adminClient());
            Version minVersion = (Version)versionVersionTuple.v1();
            Version clusterManagerVersion = (Version)versionVersionTuple.v2();
            this.logger.info("initializing client, minimum OpenSearch version [{}], cluster-manager version, [{}], hosts {}", (Object)minVersion, (Object)clusterManagerVersion, hosts);
            clientYamlTestClient = this.initClientYamlTestClient(restSpec, OpenSearchClientYamlSuiteTestCase.client(), hosts, minVersion, clusterManagerVersion);
            restTestExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient, this.randomizeContentType());
            adminExecutionContext = new ClientYamlTestExecutionContext(clientYamlTestClient, false);
            String[] denylist = OpenSearchClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_DENYLIST, null);
            denylistPathMatchers = new ArrayList<DenylistedPathPatternMatcher>();
            for (String entry : denylist) {
                denylistPathMatchers.add(new DenylistedPathPatternMatcher(entry));
            }
            for (String entry : denylistAdditions = OpenSearchClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_DENYLIST_ADDITIONS, null)) {
                denylistPathMatchers.add(new DenylistedPathPatternMatcher(entry));
            }
        }
        assert (restTestExecutionContext != null);
        assert (adminExecutionContext != null);
        assert (denylistPathMatchers != null);
        adminExecutionContext.clear();
        restTestExecutionContext.clear();
    }

    protected ClientYamlTestClient initClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Version clusterManagerVersion) {
        return new ClientYamlTestClient(restSpec, restClient, hosts, esVersion, clusterManagerVersion, (CheckedSupplier<RestClientBuilder, IOException>)((CheckedSupplier)this::getClientBuilderWithSniffedHosts));
    }

    @AfterClass
    public static void closeClient() throws IOException {
        try {
            IOUtils.close((Closeable)clientYamlTestClient);
        }
        finally {
            denylistPathMatchers = null;
            restTestExecutionContext = null;
            adminExecutionContext = null;
            clientYamlTestClient = null;
        }
    }

    public static Iterable<Object[]> createParameters() throws Exception {
        return OpenSearchClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY);
    }

    public static Iterable<Object[]> createParameters(NamedXContentRegistry executeableSectionRegistry) throws Exception {
        String[] paths = OpenSearchClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, "");
        Map<String, Set<Path>> yamlSuites = OpenSearchClientYamlSuiteTestCase.loadSuites(paths);
        ArrayList<ClientYamlTestSuite> suites = new ArrayList<ClientYamlTestSuite>();
        Throwable validationException = null;
        for (String api : yamlSuites.keySet()) {
            ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
            for (Path yamlFile : yamlFiles) {
                ClientYamlTestSuite suite = ClientYamlTestSuite.parse(executeableSectionRegistry, api, yamlFile);
                suites.add(suite);
                try {
                    suite.validate();
                }
                catch (IllegalArgumentException e) {
                    if (validationException == null) {
                        validationException = new IllegalArgumentException("Validation errors for the following test suites:\n- " + e.getMessage());
                    } else {
                        String previousMessage = validationException.getMessage();
                        Throwable[] suppressed = validationException.getSuppressed();
                        validationException = new IllegalArgumentException(previousMessage + "\n- " + e.getMessage());
                        for (Throwable t : suppressed) {
                            validationException.addSuppressed(t);
                        }
                    }
                    validationException.addSuppressed(e);
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (ClientYamlTestSuite yamlTestSuite : suites) {
            for (ClientYamlTestSection testSection : yamlTestSuite.getTestSections()) {
                tests.add(new Object[]{new ClientYamlTestCandidate(yamlTestSuite, testSection)});
            }
        }
        tests.sort(Comparator.comparing(o -> ((ClientYamlTestCandidate)o[0]).getTestPath()));
        return tests;
    }

    static Map<String, Set<Path>> loadSuites(String ... paths) throws Exception {
        HashMap<String, Set<Path>> files = new HashMap<String, Set<Path>>();
        Path root = PathUtils.get((URI)OpenSearchClientYamlSuiteTestCase.class.getResource(TESTS_PATH).toURI());
        for (String strPath : paths) {
            Path path = root.resolve(strPath);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walk(path, new FileVisitOption[0]).forEach(file -> {
                    if (file.toString().endsWith(".yml")) {
                        OpenSearchClientYamlSuiteTestCase.addSuite(root, file, files);
                    } else if (file.toString().endsWith(".yaml")) {
                        throw new IllegalArgumentException("yaml files are no longer supported: " + file);
                    }
                });
                continue;
            }
            path = root.resolve(strPath + ".yml");
            assert (Files.exists(path, new LinkOption[0]));
            OpenSearchClientYamlSuiteTestCase.addSuite(root, path, files);
        }
        return files;
    }

    private static void addSuite(Path root, Path file, Map<String, Set<Path>> files) {
        String groupName = root.relativize(file.getParent()).toString();
        Set<Path> filesSet = files.get(groupName);
        if (filesSet == null) {
            filesSet = new HashSet<Path>();
            files.put(groupName, filesSet);
        }
        filesSet.add(file);
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    protected ClientYamlTestExecutionContext getAdminExecutionContext() {
        return adminExecutionContext;
    }

    private static void validateSpec(ClientYamlSuiteRestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (ClientYamlSuiteRestApi restApi : restSpec.getApis()) {
                if (!restApi.isBodySupported()) continue;
                for (ClientYamlSuiteRestApi.Path path : restApi.getPaths()) {
                    List<String> methodsList = Arrays.asList(path.getMethods());
                    if (!methodsList.contains("GET") || !restApi.isBodySupported() || methodsList.contains("POST")) continue;
                    errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
                }
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    private Tuple<Version, Version> readVersionsFromCatNodes(RestClient restClient) throws IOException {
        Request request = new Request("GET", "/_cat/nodes");
        request.addParameter("h", "version,master");
        request.setOptions(this.getCatNodesVersionClusterManagerRequestOptions());
        Response response = restClient.performRequest(request);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response);
        String nodesCatResponse = restTestResponse.getBodyAsString();
        String[] split = nodesCatResponse.split("\n");
        Version version = null;
        Version clusterManagerVersion = null;
        for (String perNode : split) {
            String[] versionAndClusterManager = perNode.split("\\s+");
            assert (versionAndClusterManager.length == 2) : "invalid line: " + perNode + " length: " + versionAndClusterManager.length;
            Version currentVersion = Version.fromString((String)versionAndClusterManager[0]);
            boolean clusterManager = versionAndClusterManager[1].trim().equals("*");
            if (clusterManager) {
                assert (clusterManagerVersion == null);
                clusterManagerVersion = currentVersion;
            }
            if (version == null) {
                version = currentVersion;
                continue;
            }
            if (!version.onOrAfter(currentVersion)) continue;
            version = currentVersion;
        }
        return new Tuple(version, clusterManagerVersion);
    }

    protected RequestOptions getCatNodesVersionClusterManagerRequestOptions() {
        return RequestOptions.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws IOException {
        for (DenylistedPathPatternMatcher denylistedPathMatcher : denylistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            OpenSearchClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: denylisted"), (boolean)denylistedPathMatcher.isSuffixMatch(testPath));
        }
        OpenSearchClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getSetupSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getSetupSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        OpenSearchClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTeardownSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getTeardownSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        OpenSearchClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTestSection().getSkipSection().getSkipMessage(this.testCandidate.getTestPath()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        if (this.testCandidate.getTestSection().getExecutableSections().size() == 0) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        if (!useDefaultNumberOfShards && !this.testCandidate.getTestSection().getSkipSection().getFeatures().contains("default_shards")) {
            Request request = new Request("PUT", "/_template/global");
            request.setJsonEntity("{\"index_patterns\":[\"*\"],\"settings\":{\"index.number_of_shards\":2}}");
            RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
            builder.setWarningsHandler(WarningsHandler.PERMISSIVE);
            request.setOptions(builder.build());
            OpenSearchClientYamlSuiteTestCase.adminClient().performRequest(request);
        }
        if (!this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.debug("start setup test [{}]", (Object)this.testCandidate.getTestPath());
            for (ExecutableSection executableSection : this.testCandidate.getSetupSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
            this.logger.debug("end setup test [{}]", (Object)this.testCandidate.getTestPath());
        }
        restTestExecutionContext.clear();
        try {
            for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
        }
        catch (Throwable throwable) {
            this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
            for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
            throw throwable;
        }
        this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
        for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
            this.executeSection(doSection);
        }
        this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
    }

    private void executeSection(ExecutableSection executableSection) {
        try {
            executableSection.execute(restTestExecutionContext);
        }
        catch (AssertionError | Exception e) {
            this.logger.info("Stash dump on test failure [{}]", (Object)Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)restTestExecutionContext.stash(), (boolean)true, (boolean)true).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t"));
            if (e instanceof AssertionError) {
                throw new AssertionError(this.errorMessage(executableSection, (Throwable)e), (Throwable)e);
            }
            throw new RuntimeException(this.errorMessage(executableSection, (Throwable)e), (Throwable)e);
        }
    }

    private String errorMessage(ExecutableSection executableSection, Throwable t) {
        return "Failure at [" + this.testCandidate.getSuitePath() + ":" + executableSection.getLocation().lineNumber + "]: " + t.getMessage();
    }

    protected boolean randomizeContentType() {
        return true;
    }

    protected final RestClientBuilder getClientBuilderWithSniffedHosts() throws IOException {
        OpenSearchNodesSniffer.Scheme scheme = OpenSearchNodesSniffer.Scheme.valueOf((String)this.getProtocol().toUpperCase(Locale.ROOT));
        OpenSearchNodesSniffer sniffer = new OpenSearchNodesSniffer(OpenSearchClientYamlSuiteTestCase.adminClient(), OpenSearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
        RestClientBuilder builder = RestClient.builder((Node[])sniffer.sniff().toArray(new Node[0]));
        OpenSearchClientYamlSuiteTestCase.configureClient(builder, this.restClientSettings());
        return builder;
    }
}

