/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.junit.Assert;
import org.opensearch.bootstrap.Bootstrap;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.bootstrap.BootstrapSettings;
import org.opensearch.bootstrap.FilePermissionUtils;
import org.opensearch.bootstrap.JarHell;
import org.opensearch.bootstrap.OpenSearchPolicy;
import org.opensearch.bootstrap.Security;
import org.opensearch.common.Booleans;
import org.opensearch.common.Strings;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.io.FileSystemUtils;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.network.IfConfig;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.settings.Settings;
import org.opensearch.mockito.plugin.PriviledgedMockMaker;
import org.opensearch.secure_sm.SecureSM;

public class BootstrapForTesting {
    private static void addClassCodebase(Map<String, URL> codebases, String name, String classname) {
        try {
            Class<?> clazz = BootstrapForTesting.class.getClassLoader().loadClass(classname);
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (!location.toString().endsWith(".jar") && codebases.put(name, location) != null) {
                throw new IllegalStateException("Already added " + name + " codebase for testing");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Map<String, Policy> getPluginPermissions() throws Exception {
        ArrayList<URL> pluginPolicies = Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-security.policy"));
        if (pluginPolicies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<URL> codebases = new HashSet<URL>(BootstrapForTesting.parseClassPathWithSymlinks());
        HashSet<URL> excluded = new HashSet<URL>(Arrays.asList(Bootstrap.class.getProtectionDomain().getCodeSource().getLocation(), BootstrapForTesting.class.getProtectionDomain().getCodeSource().getLocation(), LuceneTestCase.class.getProtectionDomain().getCodeSource().getLocation(), RandomizedRunner.class.getProtectionDomain().getCodeSource().getLocation(), Assert.class.getProtectionDomain().getCodeSource().getLocation()));
        codebases.removeAll(excluded);
        final ArrayList<Policy> policies = new ArrayList<Policy>(pluginPolicies.size());
        for (URL policyFile : pluginPolicies) {
            policies.add(Security.readPolicy((URL)policyFile, (Map)Security.getCodebaseJarMap(codebases)));
        }
        HashMap<String, 2> map = new HashMap<String, 2>();
        for (URL url : codebases) {
            map.put(url.getFile(), new Policy(){

                @Override
                public boolean implies(ProtectionDomain domain, Permission permission) {
                    for (Policy p : policies) {
                        if (!p.implies(domain, permission)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return Collections.unmodifiableMap(map);
    }

    @SuppressForbidden(reason="does evil stuff with paths and urls because devs and jenkins do evil stuff with paths and urls")
    static Set<URL> parseClassPathWithSymlinks() throws Exception {
        Set raw = JarHell.parseClassPath();
        HashSet<URL> cooked = new HashSet<URL>(raw.size());
        for (URL url : raw) {
            boolean added;
            Path path = PathUtils.get((URI)url.toURI());
            if (!Files.exists(path, new LinkOption[0]) || (added = cooked.add(path.toRealPath(new LinkOption[0]).toUri().toURL()))) continue;
            throw new IllegalStateException("Duplicate in classpath after resolving symlinks: " + url);
        }
        return raw;
    }

    private static Set<String> getTrustedHosts() {
        try {
            return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(iface -> Collections.list(iface.getInetAddresses()).stream()).map(address -> NetworkAddress.format((InetAddress)address)).collect(Collectors.toSet());
        }
        catch (SocketException e) {
            return Collections.emptySet();
        }
    }

    public static void ensureInitialized() {
    }

    static {
        Path javaTmpDir = PathUtils.get((String)Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "please set ${java.io.tmpdir} in pom.xml"), (String[])new String[0]);
        try {
            Security.ensureDirectoryExists((Path)javaTmpDir);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create test temp directory", e);
        }
        boolean memoryLock = (Boolean)BootstrapSettings.MEMORY_LOCK_SETTING.get(Settings.EMPTY);
        boolean systemCallFilter = Booleans.parseBoolean((String)System.getProperty("tests.system_call_filter", "true"));
        Bootstrap.initializeNatives((Path)javaTmpDir, (boolean)memoryLock, (boolean)systemCallFilter, (boolean)true);
        Bootstrap.initializeProbes();
        BootstrapInfo.getSystemProperties();
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (Exception e) {
            throw new RuntimeException("found jar hell in test classpath", e);
        }
        IfConfig.logIfNecessary();
        if (RandomizedTest.systemPropertyAsBoolean((String)"tests.security.manager", (boolean)true)) {
            try {
                Permissions perms = new Permissions();
                Security.addClasspathPermissions((Permissions)perms);
                FilePermissionUtils.addDirectoryPath((Permissions)perms, (String)"java.io.tmpdir", (Path)javaTmpDir, (String)"read,readlink,write,delete", (boolean)false);
                String testConfigFile = System.getProperty("tests.config");
                if (Strings.hasLength((String)testConfigFile)) {
                    FilePermissionUtils.addSingleFilePath((Permissions)perms, (Path)PathUtils.get((String)testConfigFile, (String[])new String[0]), (String)"read,readlink");
                }
                if (System.getProperty("tests.gradle") == null) {
                    perms.add(new RuntimePermission("setIO"));
                }
                perms.add(new SocketPermission("localhost:0", "listen,resolve"));
                perms.add(new SocketPermission("localhost:1024-", "listen,resolve"));
                Map codebases = Security.getCodebaseJarMap((Set)JarHell.parseClassPath());
                BootstrapForTesting.addClassCodebase(codebases, "opensearch", "org.opensearch.plugins.PluginsService");
                if (System.getProperty("tests.gradle") == null) {
                    BootstrapForTesting.addClassCodebase(codebases, "plugin-classloader", "org.opensearch.plugins.ExtendedPluginsClassLoader");
                    BootstrapForTesting.addClassCodebase(codebases, "opensearch-nio", "org.opensearch.nio.ChannelFactory");
                    BootstrapForTesting.addClassCodebase(codebases, "opensearch-secure-sm", "org.opensearch.secure_sm.SecureSM");
                    BootstrapForTesting.addClassCodebase(codebases, "opensearch-rest-client", "org.opensearch.client.RestClient");
                }
                Policy testFramework = Security.readPolicy((URL)Bootstrap.class.getResource("test-framework.policy"), (Map)codebases);
                OpenSearchPolicy opensearchPolicy = new OpenSearchPolicy(codebases, (PermissionCollection)perms, BootstrapForTesting.getPluginPermissions(), true, (PermissionCollection)new Permissions());
                Policy.setPolicy(new Policy((Policy)opensearchPolicy, testFramework){
                    final /* synthetic */ Policy val$opensearchPolicy;
                    final /* synthetic */ Policy val$testFramework;
                    {
                        this.val$opensearchPolicy = policy;
                        this.val$testFramework = policy2;
                    }

                    @Override
                    public boolean implies(ProtectionDomain domain, Permission permission) {
                        return this.val$opensearchPolicy.implies(domain, permission) || this.val$testFramework.implies(domain, permission);
                    }
                });
                PriviledgedMockMaker.createAccessControlContext();
                System.setSecurityManager((SecurityManager)SecureSM.createTestSecureSM(BootstrapForTesting.getTrustedHosts()));
                Security.selfTest();
                for (URL url : Collections.list(BootstrapForTesting.class.getClassLoader().getResources("plugin-descriptor.properties"))) {
                    Properties properties = new Properties();
                    try (InputStream stream = FileSystemUtils.openFileURLStream((URL)url);){
                        properties.load(stream);
                    }
                    String clazz = properties.getProperty("classname");
                    if (clazz == null) continue;
                    Class.forName(clazz);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unable to install test security manager", e);
            }
        }
    }
}

