/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.opensearch.bootstrap.OpenSearch;
import org.opensearch.cli.MockTerminal;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.test.OpenSearchTestCase;

abstract class OpenSearchCliTestCase
extends OpenSearchTestCase {
    OpenSearchCliTestCase() {
    }

    void runTest(int expectedStatus, boolean expectedInit, BiConsumer<String, String> outputConsumer, final InitConsumer initConsumer, String ... args) throws Exception {
        MockTerminal terminal = new MockTerminal();
        final Path home = OpenSearchCliTestCase.createTempDir();
        try {
            final AtomicBoolean init = new AtomicBoolean();
            int status = OpenSearch.main((String[])args, (OpenSearch)new OpenSearch(){

                protected Environment createEnv(Map<String, String> settings) throws UserException {
                    Settings.Builder builder = Settings.builder().put("path.home", home);
                    settings.forEach((k, v) -> builder.put(k, v));
                    Settings realSettings = builder.build();
                    return new Environment(realSettings, home.resolve("config"));
                }

                void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) {
                    init.set(true);
                    initConsumer.accept(!daemonize, pidFile, quiet, initialEnv);
                }

                protected boolean addShutdownHook() {
                    return false;
                }
            }, (Terminal)terminal);
            OpenSearchCliTestCase.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)expectedStatus));
            OpenSearchCliTestCase.assertThat((Object)init.get(), (Matcher)CoreMatchers.equalTo((Object)expectedInit));
            outputConsumer.accept(terminal.getOutput(), terminal.getErrorOutput());
        }
        catch (Exception e) {
            this.logger.info("Stdout:\n" + terminal.getOutput());
            this.logger.info("Stderr:\n" + terminal.getErrorOutput());
            throw e;
        }
    }

    static interface InitConsumer {
        public void accept(boolean var1, Path var2, boolean var3, Environment var4);
    }
}

