/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.UUIDs;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.Index;
import org.opensearch.test.OpenSearchTestCase;

public final class DataStreamTestHelper {
    private static final Settings.Builder SETTINGS = OpenSearchTestCase.settings(Version.CURRENT).put("index.hidden", true);
    private static final int NUMBER_OF_SHARDS = 1;
    private static final int NUMBER_OF_REPLICAS = 1;

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1);
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation) {
        return IndexMetadata.builder((String)DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation)).settings(SETTINGS).numberOfShards(1).numberOfReplicas(1);
    }

    public static IndexMetadata.Builder getIndexMetadataBuilderForIndex(Index index) {
        return IndexMetadata.builder((String)index.getName()).settings(Settings.builder().put(SETTINGS.build()).put("index.uuid", index.getUUID())).numberOfShards(1).numberOfReplicas(1);
    }

    public static DataStream.TimestampField createTimestampField(String fieldName) {
        return new DataStream.TimestampField(fieldName);
    }

    public static String generateMapping(String timestampFieldName) {
        return DataStreamTestHelper.generateMapping(timestampFieldName, "date");
    }

    public static String generateMapping(String timestampFieldName, String type) {
        return "{\n      \"_data_stream_timestamp\": {\n        \"enabled\": true,\n        \"timestamp_field\": { \"name\": \"" + timestampFieldName + "\" }      },      \"properties\": {\n        \"" + timestampFieldName + "\": {\n          \"type\": \"" + type + "\"\n        }\n      }\n    }";
    }

    public static List<Index> randomIndexInstances() {
        int numIndices = OpenSearchTestCase.randomIntBetween(0, 128);
        ArrayList<Index> indices = new ArrayList<Index>(numIndices);
        for (int i = 0; i < numIndices; ++i) {
            indices.add(new Index(OpenSearchTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        }
        return indices;
    }

    public static DataStream randomInstance() {
        List<Index> indices = DataStreamTestHelper.randomIndexInstances();
        long generation = (long)indices.size() + OpenSearchTestCase.randomLongBetween(1L, 128L);
        String dataStreamName = OpenSearchTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT);
        indices.add(new Index(DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        return new DataStream(dataStreamName, DataStreamTestHelper.createTimestampField("@timestamp"), indices, generation);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames) {
        Metadata.Builder builder = Metadata.builder();
        ArrayList allIndices = new ArrayList();
        for (Tuple<String, Integer> dsTuple : dataStreams) {
            ArrayList<IndexMetadata> backingIndices = new ArrayList<IndexMetadata>();
            for (int backingIndexNumber = 1; backingIndexNumber <= (Integer)dsTuple.v2(); ++backingIndexNumber) {
                backingIndices.add(DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultBackingIndexName((String)((String)dsTuple.v1()), (long)backingIndexNumber), true));
            }
            allIndices.addAll(backingIndices);
            DataStream ds = new DataStream((String)dsTuple.v1(), DataStreamTestHelper.createTimestampField("@timestamp"), backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toList()), (long)((Integer)dsTuple.v2()).intValue());
            builder.put(ds);
        }
        for (String indexName : indexNames) {
            allIndices.add(DataStreamTestHelper.createIndexMetadata(indexName, false));
        }
        for (IndexMetadata index : allIndices) {
            builder.put(index, false);
        }
        return ClusterState.builder((ClusterName)new ClusterName("_name")).metadata(builder).build();
    }

    private static IndexMetadata createIndexMetadata(String name, boolean hidden) {
        Settings.Builder b = Settings.builder().put("index.version.created", Version.CURRENT).put("index.hidden", hidden);
        return IndexMetadata.builder((String)name).settings(b).numberOfShards(1).numberOfReplicas(1).build();
    }
}

