/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.opensearch.action.ActionListener;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.ClusterStatePublisher;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.common.UUIDs;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.PrioritizedOpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.node.Node;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.threadpool.ThreadPool;

public class FakeThreadPoolClusterManagerService
extends ClusterManagerService {
    private static final Logger logger = LogManager.getLogger(FakeThreadPoolClusterManagerService.class);
    private final String name;
    private final List<Runnable> pendingTasks = new ArrayList<Runnable>();
    private final Consumer<Runnable> onTaskAvailableToRun;
    private boolean scheduledNextTask = false;
    private boolean taskInProgress = false;
    private boolean waitForPublish = false;

    public FakeThreadPoolClusterManagerService(String nodeName, String serviceName, ThreadPool threadPool, Consumer<Runnable> onTaskAvailableToRun) {
        super(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), nodeName).build(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool);
        this.name = serviceName;
        this.onTaskAvailableToRun = onTaskAvailableToRun;
    }

    protected PrioritizedOpenSearchThreadPoolExecutor createThreadPoolExecutor() {
        return new PrioritizedOpenSearchThreadPoolExecutor(this.name, 1, 1, 1L, TimeUnit.SECONDS, OpenSearchExecutors.daemonThreadFactory((String)this.name), null, null){

            public void execute(Runnable command, TimeValue timeout, Runnable timeoutCallback) {
                this.execute(command);
            }

            public void execute(Runnable command) {
                FakeThreadPoolClusterManagerService.this.pendingTasks.add(command);
                FakeThreadPoolClusterManagerService.this.scheduleNextTaskIfNecessary();
            }
        };
    }

    public int getFakeMasterServicePendingTaskCount() {
        return this.pendingTasks.size();
    }

    private void scheduleNextTaskIfNecessary() {
        if (!(this.taskInProgress || this.pendingTasks.isEmpty() || this.scheduledNextTask)) {
            this.scheduledNextTask = true;
            this.onTaskAvailableToRun.accept(new Runnable(){

                public String toString() {
                    return "cluster-manager service scheduling next task";
                }

                @Override
                public void run() {
                    assert (!FakeThreadPoolClusterManagerService.this.taskInProgress);
                    assert (!FakeThreadPoolClusterManagerService.this.waitForPublish);
                    assert (FakeThreadPoolClusterManagerService.this.scheduledNextTask);
                    int taskIndex = OpenSearchTestCase.randomInt(FakeThreadPoolClusterManagerService.this.pendingTasks.size() - 1);
                    logger.debug("next cluster-manager service task: choosing task {} of {}", (Object)taskIndex, (Object)FakeThreadPoolClusterManagerService.this.pendingTasks.size());
                    Runnable task = FakeThreadPoolClusterManagerService.this.pendingTasks.remove(taskIndex);
                    FakeThreadPoolClusterManagerService.this.taskInProgress = true;
                    FakeThreadPoolClusterManagerService.this.scheduledNextTask = false;
                    ThreadContext threadContext = FakeThreadPoolClusterManagerService.this.threadPool.getThreadContext();
                    try (ThreadContext.StoredContext ignored = threadContext.stashContext();){
                        threadContext.markAsSystemContext();
                        task.run();
                    }
                    if (!FakeThreadPoolClusterManagerService.this.waitForPublish) {
                        FakeThreadPoolClusterManagerService.this.taskInProgress = false;
                    }
                    FakeThreadPoolClusterManagerService.this.scheduleNextTaskIfNecessary();
                }
            });
        }
    }

    public ClusterState.Builder incrementVersion(ClusterState clusterState) {
        return ClusterState.builder((ClusterState)clusterState).incrementVersion().stateUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random()));
    }

    protected void publish(final ClusterChangedEvent clusterChangedEvent, final MasterService.TaskOutputs taskOutputs, final long startTimeMillis) {
        assert (!this.waitForPublish);
        this.waitForPublish = true;
        ClusterStatePublisher.AckListener ackListener = taskOutputs.createAckListener(this.threadPool, clusterChangedEvent.state());
        ActionListener<Void> publishListener = new ActionListener<Void>(){
            private boolean listenerCalled = false;

            public void onResponse(Void aVoid) {
                assert (!this.listenerCalled);
                this.listenerCalled = true;
                assert (FakeThreadPoolClusterManagerService.this.waitForPublish);
                FakeThreadPoolClusterManagerService.this.waitForPublish = false;
                try {
                    FakeThreadPoolClusterManagerService.this.onPublicationSuccess(clusterChangedEvent, taskOutputs);
                }
                finally {
                    FakeThreadPoolClusterManagerService.this.taskInProgress = false;
                    FakeThreadPoolClusterManagerService.this.scheduleNextTaskIfNecessary();
                }
            }

            public void onFailure(Exception e) {
                assert (!this.listenerCalled);
                this.listenerCalled = true;
                assert (FakeThreadPoolClusterManagerService.this.waitForPublish);
                FakeThreadPoolClusterManagerService.this.waitForPublish = false;
                try {
                    FakeThreadPoolClusterManagerService.this.onPublicationFailed(clusterChangedEvent, taskOutputs, startTimeMillis, e);
                }
                finally {
                    FakeThreadPoolClusterManagerService.this.taskInProgress = false;
                    FakeThreadPoolClusterManagerService.this.scheduleNextTaskIfNecessary();
                }
            }
        };
        this.threadPool.generic().execute(this.threadPool.getThreadContext().preserveContext(new Runnable(){
            final /* synthetic */ ActionListener val$publishListener;
            final /* synthetic */ ClusterStatePublisher.AckListener val$ackListener;
            {
                this.val$publishListener = actionListener;
                this.val$ackListener = ackListener;
            }

            @Override
            public void run() {
                FakeThreadPoolClusterManagerService.this.clusterStatePublisher.publish(clusterChangedEvent, this.val$publishListener, FakeThreadPoolClusterManagerService.this.wrapAckListener(this.val$ackListener));
            }

            public String toString() {
                return "publish change of cluster state from version [" + clusterChangedEvent.previousState().version() + "] in term [" + clusterChangedEvent.previousState().term() + "] to version [" + clusterChangedEvent.state().version() + "] in term [" + clusterChangedEvent.state().term() + "]";
            }
        }));
    }

    protected ClusterStatePublisher.AckListener wrapAckListener(ClusterStatePublisher.AckListener ackListener) {
        return ackListener;
    }
}

