/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.ReleasableBytesStreamOutput;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.ByteArray;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.test.OpenSearchTestCase;

public abstract class AbstractBytesReferenceTestCase
extends OpenSearchTestCase {
    protected static final int PAGE_SIZE = 16384;
    protected final BigArrays bigarrays = new BigArrays(null, (CircuitBreakerService)new NoneCircuitBreakerService(), "request");

    public void testGet() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(1, 49152);
        BytesReference pbr = this.newBytesReference(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, length / 2);
        int sliceLength = Math.max(1, length - sliceOffset - 1);
        BytesReference slice = pbr.slice(sliceOffset, sliceLength);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(sliceOffset), (long)slice.get(0));
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(sliceOffset + sliceLength - 1), (long)slice.get(sliceLength - 1));
        int probes = AbstractBytesReferenceTestCase.randomIntBetween(20, 100);
        BytesArray copy = new BytesArray(pbr.toBytesRef(), true);
        for (int i = 0; i < probes; ++i) {
            int index = AbstractBytesReferenceTestCase.randomIntBetween(0, copy.length() - 1);
            AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(index), (long)copy.get(index));
            index = AbstractBytesReferenceTestCase.randomIntBetween(sliceOffset, sliceOffset + sliceLength - 1);
            AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(index), (long)slice.get(index - sliceOffset));
        }
    }

    public void testLength() throws IOException {
        int[] sizes = new int[]{0, AbstractBytesReferenceTestCase.randomInt(16384), 16384, AbstractBytesReferenceTestCase.randomInt(49152)};
        for (int i = 0; i < sizes.length; ++i) {
            BytesReference pbr = this.newBytesReference(sizes[i]);
            AbstractBytesReferenceTestCase.assertEquals((long)sizes[i], (long)pbr.length());
        }
    }

    public void testSlice() throws IOException {
        for (int length : new int[]{0, 1, AbstractBytesReferenceTestCase.randomIntBetween(2, 16384), AbstractBytesReferenceTestCase.randomIntBetween(16385, 49152)}) {
            BytesReference pbr = this.newBytesReference(length);
            int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, length / 2);
            int sliceLength = Math.max(0, length - sliceOffset - 1);
            BytesReference slice = pbr.slice(sliceOffset, sliceLength);
            AbstractBytesReferenceTestCase.assertEquals((long)sliceLength, (long)slice.length());
            for (int i = 0; i < sliceLength; ++i) {
                AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(i + sliceOffset), (long)slice.get(i));
            }
            BytesRef singlePageOrNull = AbstractBytesReferenceTestCase.getSinglePageOrNull(slice);
            if (singlePageOrNull == null) continue;
            AbstractBytesReferenceTestCase.assertEquals((long)sliceLength, (long)singlePageOrNull.length);
        }
    }

    public void testStreamInput() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        StreamInput si = pbr.streamInput();
        AbstractBytesReferenceTestCase.assertNotNull((Object)si);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(0), (long)si.readByte());
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(1), (long)si.readByte());
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(2), (long)si.readByte());
        si.reset();
        byte[] origBuf = new byte[length];
        AbstractBytesReferenceTestCase.random().nextBytes(origBuf);
        byte[] targetBuf = Arrays.copyOf(origBuf, origBuf.length);
        si.readBytes(targetBuf, 0, 0);
        AbstractBytesReferenceTestCase.assertEquals((long)origBuf[0], (long)targetBuf[0]);
        si.reset();
        int bytesToRead = AbstractBytesReferenceTestCase.randomIntBetween(1, length / 2);
        for (int i = 0; i < bytesToRead; ++i) {
            int b = si.read();
            AbstractBytesReferenceTestCase.assertEquals((long)(pbr.get(i) & 0xFF), (long)b);
        }
        si.reset();
        si.readFully(targetBuf);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)pbr), (byte[])targetBuf);
        try {
            si.readByte();
            AbstractBytesReferenceTestCase.fail((String)"expected EOF");
        }
        catch (EOFException | IndexOutOfBoundsException exception) {
            // empty catch block
        }
        si.reset();
        AbstractBytesReferenceTestCase.expectThrows(IndexOutOfBoundsException.class, () -> si.readBytes(targetBuf, 0, length * 2));
    }

    public void testStreamInputMarkAndReset() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        StreamInput si = pbr.streamInput();
        AbstractBytesReferenceTestCase.assertNotNull((Object)si);
        StreamInput wrap = StreamInput.wrap((byte[])BytesReference.toBytes((BytesReference)pbr));
        while (wrap.available() > 0) {
            if (AbstractBytesReferenceTestCase.rarely()) {
                wrap.mark(Integer.MAX_VALUE);
                si.mark(Integer.MAX_VALUE);
            } else if (AbstractBytesReferenceTestCase.rarely()) {
                wrap.reset();
                si.reset();
            }
            AbstractBytesReferenceTestCase.assertEquals((long)si.readByte(), (long)wrap.readByte());
            AbstractBytesReferenceTestCase.assertEquals((long)si.available(), (long)wrap.available());
        }
    }

    public void testStreamInputBulkReadWithOffset() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        StreamInput si = pbr.streamInput();
        AbstractBytesReferenceTestCase.assertNotNull((Object)si);
        int offset = AbstractBytesReferenceTestCase.randomIntBetween(1, length / 2);
        for (int i = 0; i < offset; ++i) {
            AbstractBytesReferenceTestCase.assertEquals((long)si.available(), (long)(length - i));
            AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(i), (long)si.readByte());
        }
        byte[] pbrBytesWithOffset = Arrays.copyOfRange(BytesReference.toBytes((BytesReference)pbr), offset, length);
        byte[] targetBytes = new byte[pbrBytesWithOffset.length];
        AbstractBytesReferenceTestCase.random().nextBytes(targetBytes);
        si.readFully(targetBytes);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])pbrBytesWithOffset, (byte[])targetBytes);
        AbstractBytesReferenceTestCase.assertEquals((long)si.available(), (long)0L);
    }

    public void testRandomReads() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        StreamInput streamInput = pbr.streamInput();
        BytesRefBuilder target = new BytesRefBuilder();
        block4: while (target.length() < pbr.length()) {
            switch (AbstractBytesReferenceTestCase.randomIntBetween(0, 10)) {
                case 5: 
                case 6: {
                    target.append(new BytesRef(new byte[]{streamInput.readByte()}));
                    continue block4;
                }
                case 3: 
                case 4: {
                    BytesRef bytesRef = streamInput.readBytesRef(AbstractBytesReferenceTestCase.scaledRandomIntBetween(1, pbr.length() - target.length()));
                    target.append(bytesRef);
                    continue block4;
                }
            }
            byte[] buffer = new byte[AbstractBytesReferenceTestCase.scaledRandomIntBetween(1, pbr.length() - target.length())];
            int offset = AbstractBytesReferenceTestCase.scaledRandomIntBetween(0, buffer.length - 1);
            int read = streamInput.read(buffer, offset, buffer.length - offset);
            target.append(new BytesRef(buffer, offset, read));
        }
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.length(), (long)target.length());
        BytesRef targetBytes = target.get();
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)pbr), (byte[])Arrays.copyOfRange(targetBytes.bytes, targetBytes.offset, targetBytes.length));
    }

    public void testSliceStreamInput() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(1, length / 2);
        int sliceLength = length - sliceOffset;
        BytesReference slice = pbr.slice(sliceOffset, sliceLength);
        StreamInput sliceInput = slice.streamInput();
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)sliceLength);
        AbstractBytesReferenceTestCase.assertEquals((long)slice.get(0), (long)sliceInput.readByte());
        AbstractBytesReferenceTestCase.assertEquals((long)slice.get(1), (long)sliceInput.readByte());
        AbstractBytesReferenceTestCase.assertEquals((long)slice.get(2), (long)sliceInput.readByte());
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)(sliceLength - 3));
        sliceInput.reset();
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)sliceLength);
        byte[] sliceBytes = new byte[sliceLength];
        sliceInput.readFully(sliceBytes);
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)0L);
        byte[] pbrSliceBytes = Arrays.copyOfRange(BytesReference.toBytes((BytesReference)pbr), sliceOffset, length);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])pbrSliceBytes, (byte[])sliceBytes);
        byte[] sliceToBytes = BytesReference.toBytes((BytesReference)slice);
        AbstractBytesReferenceTestCase.assertEquals((long)sliceBytes.length, (long)sliceToBytes.length);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])sliceBytes, (byte[])sliceToBytes);
        sliceInput.reset();
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)sliceLength);
        byte[] buffer = new byte[sliceLength + AbstractBytesReferenceTestCase.scaledRandomIntBetween(1, 100)];
        int offset = AbstractBytesReferenceTestCase.scaledRandomIntBetween(0, Math.max(1, buffer.length - sliceLength - 1));
        int read = sliceInput.read(buffer, offset, sliceLength / 2);
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)(sliceLength - read));
        sliceInput.read(buffer, offset + read, sliceLength - read);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])sliceBytes, (byte[])Arrays.copyOfRange(buffer, offset, offset + sliceLength));
        AbstractBytesReferenceTestCase.assertEquals((long)sliceInput.available(), (long)0L);
    }

    public void testWriteToOutputStream() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 65536);
        BytesReference pbr = this.newBytesReference(length);
        BytesStreamOutput out = new BytesStreamOutput();
        pbr.writeTo((OutputStream)out);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.length(), (long)out.size());
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)pbr), (byte[])BytesReference.toBytes((BytesReference)out.bytes()));
        out.close();
    }

    public void testInputStreamSkip() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, AbstractBytesReferenceTestCase.scaledRandomIntBetween(32768, 327680));
        BytesReference pbr = this.newBytesReference(length);
        int iters = AbstractBytesReferenceTestCase.randomIntBetween(5, 50);
        for (int i = 0; i < iters; ++i) {
            try (StreamInput input = pbr.streamInput();){
                int offset = AbstractBytesReferenceTestCase.randomIntBetween(0, length - 1);
                AbstractBytesReferenceTestCase.assertEquals((long)offset, (long)input.skip((long)offset));
                AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(offset), (long)input.readByte());
                if (offset == length - 1) continue;
                int nextOffset = AbstractBytesReferenceTestCase.randomIntBetween(offset, length - 2);
                AbstractBytesReferenceTestCase.assertEquals((long)(nextOffset - offset), (long)input.skip((long)(nextOffset - offset)));
                AbstractBytesReferenceTestCase.assertEquals((long)pbr.get(nextOffset + 1), (long)input.readByte());
                AbstractBytesReferenceTestCase.assertEquals((long)(length - (nextOffset + 2)), (long)input.skip(Long.MAX_VALUE));
                AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)input.skip((long)AbstractBytesReferenceTestCase.randomIntBetween(0, Integer.MAX_VALUE)));
                continue;
            }
        }
    }

    public void testSliceWriteToOutputStream() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5));
        BytesReference pbr = this.newBytesReference(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(1, length / 2);
        int sliceLength = length - sliceOffset;
        BytesReference slice = pbr.slice(sliceOffset, sliceLength);
        BytesStreamOutput sliceOut = new BytesStreamOutput(sliceLength);
        slice.writeTo((OutputStream)sliceOut);
        AbstractBytesReferenceTestCase.assertEquals((long)slice.length(), (long)sliceOut.size());
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)slice), (byte[])BytesReference.toBytes((BytesReference)sliceOut.bytes()));
        sliceOut.close();
    }

    public void testToBytes() throws IOException {
        int[] sizes = new int[]{0, AbstractBytesReferenceTestCase.randomInt(16384), 16384, AbstractBytesReferenceTestCase.randomIntBetween(2, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5))};
        for (int i = 0; i < sizes.length; ++i) {
            BytesReference pbr = this.newBytesReference(sizes[i]);
            byte[] bytes = BytesReference.toBytes((BytesReference)pbr);
            AbstractBytesReferenceTestCase.assertEquals((long)sizes[i], (long)bytes.length);
            for (int j = 0; j < bytes.length; ++j) {
                AbstractBytesReferenceTestCase.assertEquals((long)bytes[j], (long)pbr.get(j));
            }
        }
    }

    public void testToBytesRefSharedPage() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384);
        BytesReference pbr = this.newBytesReference(length);
        BytesArray ba = new BytesArray(pbr.toBytesRef());
        BytesArray ba2 = new BytesArray(pbr.toBytesRef());
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba);
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba2);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.length(), (long)ba.length());
        AbstractBytesReferenceTestCase.assertEquals((long)ba.length(), (long)ba2.length());
        AbstractBytesReferenceTestCase.assertSame((Object)ba.array(), (Object)ba2.array());
    }

    public void testToBytesRefMaterializedPages() throws IOException {
        int length = 0;
        while (length % 16384 == 0) {
            length = AbstractBytesReferenceTestCase.randomIntBetween(16384, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5));
        }
        BytesReference pbr = this.newBytesReference(length);
        BytesArray ba = new BytesArray(pbr.toBytesRef());
        BytesArray ba2 = new BytesArray(pbr.toBytesRef());
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba);
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba2);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.length(), (long)ba.length());
        AbstractBytesReferenceTestCase.assertEquals((long)ba.length(), (long)ba2.length());
    }

    public void testCopyBytesRefSharesBytes() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384);
        BytesReference pbr = this.newBytesReference(length);
        BytesArray ba = new BytesArray(pbr.toBytesRef(), true);
        BytesArray ba2 = new BytesArray(pbr.toBytesRef(), true);
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba);
        AbstractBytesReferenceTestCase.assertNotSame((Object)ba, (Object)ba2);
        AbstractBytesReferenceTestCase.assertNotSame((Object)ba.array(), (Object)ba2.array());
    }

    public void testSliceCopyBytesRef() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
        BytesReference pbr = this.newBytesReference(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceOffset);
        BytesReference slice = pbr.slice(sliceOffset, sliceLength);
        BytesArray ba1 = new BytesArray(slice.toBytesRef(), true);
        BytesArray ba2 = new BytesArray(slice.toBytesRef(), true);
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba1);
        AbstractBytesReferenceTestCase.assertNotNull((Object)ba2);
        AbstractBytesReferenceTestCase.assertNotSame((Object)ba1.array(), (Object)ba2.array());
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)slice), (byte[])ba1.array());
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)slice), (byte[])ba2.array());
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])ba1.array(), (byte[])ba2.array());
    }

    public void testEmptyToBytesRefIterator() throws IOException {
        BytesReference pbr = this.newBytesReference(0);
        AbstractBytesReferenceTestCase.assertNull((Object)pbr.iterator().next());
    }

    public void testIterator() throws IOException {
        BytesRef ref;
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
        BytesReference pbr = this.newBytesReference(length);
        BytesRefIterator iterator = pbr.iterator();
        BytesRefBuilder builder = new BytesRefBuilder();
        while ((ref = iterator.next()) != null) {
            builder.append(ref);
        }
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)pbr), (byte[])BytesRef.deepCopyOf((BytesRef)builder.toBytesRef()).bytes);
    }

    public void testSliceIterator() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
        BytesReference pbr = this.newBytesReference(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceOffset);
        BytesReference slice = pbr.slice(sliceOffset, sliceLength);
        BytesRefIterator iterator = slice.iterator();
        BytesRef ref = null;
        BytesRefBuilder builder = new BytesRefBuilder();
        while ((ref = iterator.next()) != null) {
            builder.append(ref);
        }
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)slice), (byte[])BytesRef.deepCopyOf((BytesRef)builder.toBytesRef()).bytes);
    }

    public void testIteratorRandom() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
        BytesReference pbr = this.newBytesReference(length);
        if (AbstractBytesReferenceTestCase.randomBoolean()) {
            int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
            int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceOffset);
            pbr = pbr.slice(sliceOffset, sliceLength);
        }
        if (AbstractBytesReferenceTestCase.randomBoolean()) {
            pbr = new BytesArray(pbr.toBytesRef());
        }
        BytesRefIterator iterator = pbr.iterator();
        BytesRef ref = null;
        BytesRefBuilder builder = new BytesRefBuilder();
        while ((ref = iterator.next()) != null) {
            builder.append(ref);
        }
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)pbr), (byte[])BytesRef.deepCopyOf((BytesRef)builder.toBytesRef()).bytes);
    }

    public void testArrayOffset() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomInt(16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5));
        BytesReference pbr = this.newBytesReference(length);
        BytesRef singlePageOrNull = AbstractBytesReferenceTestCase.getSinglePageOrNull(pbr);
        if (singlePageOrNull != null) {
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)singlePageOrNull.offset);
        }
    }

    public void testSliceArrayOffset() throws IOException {
        int sliceLength;
        int sliceOffset;
        int length = AbstractBytesReferenceTestCase.randomIntBetween(1, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5));
        BytesReference pbr = this.newBytesReferenceWithOffsetOfZero(length);
        BytesReference slice = pbr.slice(sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - 1), sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(1, pbr.length() - sliceOffset));
        BytesRef singlePageOrNull = AbstractBytesReferenceTestCase.getSinglePageOrNull(slice);
        if (singlePageOrNull != null) {
            if (AbstractBytesReferenceTestCase.getSinglePageOrNull(pbr) == null) {
                AbstractBytesReferenceTestCase.assertEquals((long)(sliceOffset % 16384), (long)singlePageOrNull.offset);
            } else {
                AbstractBytesReferenceTestCase.assertEquals((long)sliceOffset, (long)singlePageOrNull.offset);
            }
        }
    }

    public void testToUtf8() throws IOException {
        BytesReference pbr = this.newBytesReference(0);
        AbstractBytesReferenceTestCase.assertEquals((Object)"", (Object)pbr.utf8ToString());
    }

    public void testToBytesRef() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(0, 16384);
        BytesReference pbr = this.newBytesReference(length);
        BytesRef ref = pbr.toBytesRef();
        AbstractBytesReferenceTestCase.assertNotNull((Object)ref);
        AbstractBytesReferenceTestCase.assertEquals((long)pbr.length(), (long)ref.length);
    }

    public void testSliceToBytesRef() throws IOException {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(0, 16384);
        BytesReference pbr = this.newBytesReferenceWithOffsetOfZero(length);
        int sliceOffset = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceOffset);
        BytesRef sliceRef = pbr.slice(sliceOffset, sliceLength).toBytesRef();
        if (sliceLength == 0 && sliceOffset != sliceRef.offset) {
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)sliceRef.offset);
        } else {
            AbstractBytesReferenceTestCase.assertEquals((long)sliceOffset, (long)sliceRef.offset);
        }
        AbstractBytesReferenceTestCase.assertEquals((long)sliceLength, (long)sliceRef.length);
    }

    public void testHashCode() throws IOException {
        BytesReference pbr = this.newBytesReference(0);
        AbstractBytesReferenceTestCase.assertEquals((long)Arrays.hashCode(BytesRef.EMPTY_BYTES), (long)pbr.hashCode());
        pbr = this.newBytesReference(AbstractBytesReferenceTestCase.randomIntBetween(0, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5)));
        int jdkHash = Arrays.hashCode(BytesReference.toBytes((BytesReference)pbr));
        int pbrHash = pbr.hashCode();
        AbstractBytesReferenceTestCase.assertEquals((long)jdkHash, (long)pbrHash);
        int sliceFrom = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceFrom);
        BytesReference slice = pbr.slice(sliceFrom, sliceLength);
        int sliceJdkHash = Arrays.hashCode(BytesReference.toBytes((BytesReference)slice));
        int sliceHash = slice.hashCode();
        AbstractBytesReferenceTestCase.assertEquals((long)sliceJdkHash, (long)sliceHash);
    }

    public void testEquals() throws IOException {
        BytesReference bytesReference = this.newBytesReference(AbstractBytesReferenceTestCase.randomIntBetween(100, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5)));
        BytesReference copy = bytesReference.slice(0, bytesReference.length());
        AbstractBytesReferenceTestCase.assertEquals((Object)copy, (Object)bytesReference);
        int sliceFrom = AbstractBytesReferenceTestCase.randomIntBetween(0, bytesReference.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, bytesReference.length() - sliceFrom);
        AbstractBytesReferenceTestCase.assertEquals((Object)copy.slice(sliceFrom, sliceLength), (Object)bytesReference.slice(sliceFrom, sliceLength));
        BytesRef bytesRef = BytesRef.deepCopyOf((BytesRef)copy.toBytesRef());
        AbstractBytesReferenceTestCase.assertEquals((Object)new BytesArray(bytesRef), (Object)copy);
        int offsetToFlip = AbstractBytesReferenceTestCase.randomIntBetween(0, bytesRef.length - 1);
        int value = ~Byte.toUnsignedInt(bytesRef.bytes[bytesRef.offset + offsetToFlip]);
        bytesRef.bytes[bytesRef.offset + offsetToFlip] = (byte)value;
        AbstractBytesReferenceTestCase.assertNotEquals((Object)new BytesArray(bytesRef), (Object)copy);
    }

    public void testSliceEquals() {
        int length = AbstractBytesReferenceTestCase.randomIntBetween(100, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 5));
        ByteArray ba1 = this.bigarrays.newByteArray((long)length, false);
        BytesReference pbr = BytesReference.fromByteArray((ByteArray)ba1, (int)length);
        int sliceFrom = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length());
        int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, pbr.length() - sliceFrom);
        BytesReference slice1 = pbr.slice(sliceFrom, sliceLength);
        BytesReference slice2 = pbr.slice(sliceFrom, sliceLength);
        AbstractBytesReferenceTestCase.assertArrayEquals((byte[])BytesReference.toBytes((BytesReference)slice1), (byte[])BytesReference.toBytes((BytesReference)slice2));
        if (sliceLength > 0) {
            BytesReference slice3 = pbr.slice(sliceFrom, sliceLength / 2);
            AbstractBytesReferenceTestCase.assertFalse((boolean)Arrays.equals(BytesReference.toBytes((BytesReference)slice1), BytesReference.toBytes((BytesReference)slice3)));
        }
    }

    protected abstract BytesReference newBytesReference(int var1) throws IOException;

    protected abstract BytesReference newBytesReferenceWithOffsetOfZero(int var1) throws IOException;

    public void testCompareTo() throws IOException {
        int iters = AbstractBytesReferenceTestCase.randomIntBetween(5, 10);
        for (int i = 0; i < iters; ++i) {
            int j;
            int length = AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
            BytesReference bytesReference = this.newBytesReference(length);
            AbstractBytesReferenceTestCase.assertTrue((bytesReference.compareTo((Object)new BytesArray("")) > 0 ? 1 : 0) != 0);
            AbstractBytesReferenceTestCase.assertTrue((new BytesArray("").compareTo(bytesReference) < 0 ? 1 : 0) != 0);
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)bytesReference.compareTo((Object)bytesReference));
            int sliceFrom = AbstractBytesReferenceTestCase.randomIntBetween(0, bytesReference.length());
            int sliceLength = AbstractBytesReferenceTestCase.randomIntBetween(0, bytesReference.length() - sliceFrom);
            BytesReference slice = bytesReference.slice(sliceFrom, sliceLength);
            AbstractBytesReferenceTestCase.assertEquals((long)bytesReference.toBytesRef().compareTo(slice.toBytesRef()), (long)new BytesArray(bytesReference.toBytesRef(), true).compareTo((BytesReference)new BytesArray(slice.toBytesRef(), true)));
            AbstractBytesReferenceTestCase.assertEquals((long)bytesReference.toBytesRef().compareTo(slice.toBytesRef()), (long)bytesReference.compareTo((Object)slice));
            AbstractBytesReferenceTestCase.assertEquals((long)slice.toBytesRef().compareTo(bytesReference.toBytesRef()), (long)slice.compareTo((Object)bytesReference));
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)slice.compareTo((Object)new BytesArray(slice.toBytesRef())));
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)new BytesArray(slice.toBytesRef()).compareTo(slice));
            int crazyLength = length + AbstractBytesReferenceTestCase.randomIntBetween(10, 16384 * AbstractBytesReferenceTestCase.randomIntBetween(2, 8));
            ReleasableBytesStreamOutput crazyStream = new ReleasableBytesStreamOutput(length, this.bigarrays);
            int offset = AbstractBytesReferenceTestCase.randomIntBetween(0, crazyLength - length);
            for (j = 0; j < offset; ++j) {
                crazyStream.writeByte((byte)AbstractBytesReferenceTestCase.random().nextInt(256));
            }
            bytesReference.writeTo((OutputStream)crazyStream);
            for (j = crazyStream.size(); j < crazyLength; ++j) {
                crazyStream.writeByte((byte)AbstractBytesReferenceTestCase.random().nextInt(256));
            }
            BytesReference crazyReference = crazyStream.bytes();
            AbstractBytesReferenceTestCase.assertFalse((crazyReference.compareTo((Object)bytesReference) == 0 ? 1 : 0) != 0);
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)crazyReference.slice(offset, length).compareTo((Object)bytesReference));
            AbstractBytesReferenceTestCase.assertEquals((long)0L, (long)bytesReference.compareTo((Object)crazyReference.slice(offset, length)));
        }
    }

    public static BytesRef getSinglePageOrNull(BytesReference ref) throws IOException {
        if (ref.length() > 0) {
            BytesRefIterator iterator = ref.iterator();
            BytesRef next = iterator.next();
            BytesRef retVal = next.clone();
            if (iterator.next() == null) {
                return retVal;
            }
        } else {
            return new BytesRef();
        }
        return null;
    }

    public static int getNumPages(BytesReference ref) throws IOException {
        int num = 0;
        if (ref.length() > 0) {
            BytesRefIterator iterator = ref.iterator();
            while (iterator.next() != null) {
                ++num;
            }
        }
        return num;
    }

    public void testBasicEquals() {
        int len = AbstractBytesReferenceTestCase.randomIntBetween(0, AbstractBytesReferenceTestCase.randomBoolean() ? 10 : 100000);
        int offset1 = AbstractBytesReferenceTestCase.randomInt(5);
        byte[] array1 = new byte[offset1 + len + AbstractBytesReferenceTestCase.randomInt(5)];
        AbstractBytesReferenceTestCase.random().nextBytes(array1);
        int offset2 = AbstractBytesReferenceTestCase.randomInt(offset1);
        byte[] array2 = Arrays.copyOfRange(array1, offset1 - offset2, array1.length);
        BytesArray b1 = new BytesArray(array1, offset1, len);
        BytesArray b2 = new BytesArray(array2, offset2, len);
        AbstractBytesReferenceTestCase.assertEquals((Object)b1, (Object)b2);
        AbstractBytesReferenceTestCase.assertEquals((long)Arrays.hashCode(BytesReference.toBytes((BytesReference)b1)), (long)b1.hashCode());
        AbstractBytesReferenceTestCase.assertEquals((long)Arrays.hashCode(BytesReference.toBytes((BytesReference)b2)), (long)b2.hashCode());
        AbstractBytesReferenceTestCase.assertEquals((Object)b1, (Object)b1);
        AbstractBytesReferenceTestCase.assertEquals((Object)b2, (Object)b2);
        if (len > 0) {
            BytesArray differentLen = new BytesArray(array1, offset1, AbstractBytesReferenceTestCase.randomInt(len - 1));
            AbstractBytesReferenceTestCase.assertNotEquals((Object)b1, (Object)differentLen);
            int n = offset1 + AbstractBytesReferenceTestCase.randomInt(len - 1);
            array1[n] = (byte)(array1[n] + 13);
            AbstractBytesReferenceTestCase.assertNotEquals((Object)b1, (Object)b2);
        }
    }

    public void testGetInt() throws IOException {
        int count = AbstractBytesReferenceTestCase.randomIntBetween(1, 10);
        BytesReference bytesReference = this.newBytesReference(count * 4);
        BytesRef bytesRef = bytesReference.toBytesRef();
        IntBuffer intBuffer = ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        for (int i = 0; i < count; ++i) {
            AbstractBytesReferenceTestCase.assertEquals((long)intBuffer.get(i), (long)bytesReference.getInt(i * 4));
        }
    }

    public void testIndexOf() throws IOException {
        int size = AbstractBytesReferenceTestCase.randomIntBetween(0, 100);
        BytesReference bytesReference = this.newBytesReference(size);
        HashMap<Byte, List> map = new HashMap<Byte, List>();
        for (int i = 0; i < size; ++i) {
            byte value2 = bytesReference.get(i);
            map.computeIfAbsent(value2, v -> new ArrayList()).add(i);
        }
        map.forEach((value, positions) -> {
            for (int i = 0; i < positions.size(); ++i) {
                int pos = (Integer)positions.get(i);
                int from = i == 0 ? AbstractBytesReferenceTestCase.randomIntBetween(0, pos) : (Integer)positions.get(i - 1) + 1;
                AbstractBytesReferenceTestCase.assertEquals((long)bytesReference.indexOf(value.byteValue(), from), (long)pos);
            }
        });
        byte missing = AbstractBytesReferenceTestCase.randomValueOtherThanMany(map::containsKey, OpenSearchTestCase::randomByte);
        AbstractBytesReferenceTestCase.assertEquals((long)-1L, (long)bytesReference.indexOf(missing, AbstractBytesReferenceTestCase.randomIntBetween(0, Math.max(0, size - 1))));
    }
}

