/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.VersionType;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.DocumentMapperForType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.RootObjectMapper;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogRecoveryRunner;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.mapper.MapperRegistry;

public class TranslogHandler
implements TranslogRecoveryRunner {
    private final MapperService mapperService;
    private final AtomicLong appliedOperations = new AtomicLong();
    private final Engine engine;

    long appliedOperations() {
        return this.appliedOperations.get();
    }

    public TranslogHandler(NamedXContentRegistry xContentRegistry, IndexSettings indexSettings, Engine engine) {
        this.engine = engine;
        HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
        analyzers.put("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        IndexAnalyzers indexAnalyzers = new IndexAnalyzers(analyzers, Collections.emptyMap(), Collections.emptyMap());
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        this.mapperService = new MapperService(indexSettings, indexAnalyzers, xContentRegistry, similarityService, mapperRegistry, () -> null, () -> false, null);
    }

    private DocumentMapperForType docMapper(String type) {
        RootObjectMapper.Builder rootBuilder = new RootObjectMapper.Builder(type);
        DocumentMapper.Builder b = new DocumentMapper.Builder(rootBuilder, this.mapperService);
        return new DocumentMapperForType(b.build(this.mapperService), null);
    }

    private void applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        switch (operation.operationType()) {
            case INDEX: {
                engine.index((Engine.Index)operation);
                break;
            }
            case DELETE: {
                engine.delete((Engine.Delete)operation);
                break;
            }
            case NO_OP: {
                engine.noOp((Engine.NoOp)operation);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
    }

    public int run(Translog.Snapshot snapshot) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            this.applyOperation(this.engine, this.convertToEngineOp(operation, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY));
            ++opsRecovered;
            this.appliedOperations.incrementAndGet();
        }
        this.engine.syncTranslog();
        return opsRecovered;
    }

    public Engine.Operation convertToEngineOp(Translog.Operation operation, Engine.Operation.Origin origin) {
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                String indexName = this.mapperService.index().getName();
                Engine.Index engineIndex = IndexShard.prepareIndex((DocumentMapperForType)this.docMapper("_doc"), (SourceToParse)new SourceToParse(indexName, index.id(), index.source(), XContentHelper.xContentType((BytesReference)index.source()), index.routing()), (long)index.seqNo(), (long)index.primaryTerm(), (long)index.version(), (VersionType)versionType, (Engine.Operation.Origin)origin, (long)index.getAutoGeneratedIdTimestamp(), (boolean)true, (long)-2L, (long)0L);
                return engineIndex;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                return IndexShard.prepareDelete((String)delete.id(), (long)delete.seqNo(), (long)delete.primaryTerm(), (long)delete.version(), (VersionType)versionType, (Engine.Operation.Origin)origin, (long)-2L, (long)0L);
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                Engine.NoOp engineNoOp = new Engine.NoOp(noOp.seqNo(), noOp.primaryTerm(), origin, System.nanoTime(), noOp.reason());
                return engineNoOp;
            }
        }
        throw new IllegalStateException("No operation defined for [" + operation + "]");
    }
}

