/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TermBasedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

public class MockFieldMapper
extends ParametrizedFieldMapper {
    static Settings DEFAULT_SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT.id).build();

    public MockFieldMapper(String fullName) {
        this((MappedFieldType)new FakeFieldType(fullName));
    }

    public MockFieldMapper(MappedFieldType fieldType) {
        super(MockFieldMapper.findSimpleName(fieldType.name()), fieldType, FieldMapper.MultiFields.empty(), new FieldMapper.CopyTo.Builder().build());
    }

    public MockFieldMapper(String fullName, MappedFieldType fieldType, FieldMapper.MultiFields multifields, FieldMapper.CopyTo copyTo) {
        super(MockFieldMapper.findSimpleName(fullName), fieldType, multifields, copyTo);
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName());
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(ParseContext context) {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return "faketype";
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final MappedFieldType fieldType;

        protected Builder(String name) {
            super(name);
            this.fieldType = new FakeFieldType(name);
            this.builder = this;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.emptyList();
        }

        public Builder addMultiField(Builder builder) {
            this.multiFieldsBuilder.add((Mapper.Builder)builder);
            return this;
        }

        public Builder copyTo(String field) {
            this.copyTo.add(field);
            return this;
        }

        public MockFieldMapper build(Mapper.BuilderContext context) {
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build((Mapper.Builder)this, context);
            return new MockFieldMapper(this.name(), this.fieldType, multiFields, this.copyTo.build());
        }
    }
}

