/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.BigArrays;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.plugins.Plugin;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchService;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.threadpool.ThreadPool;

public class MockSearchService
extends SearchService {
    private static final Map<ReaderContext, Throwable> ACTIVE_SEARCH_CONTEXTS = new ConcurrentHashMap<ReaderContext, Throwable>();
    private Consumer<ReaderContext> onPutContext = context -> {};

    public static void assertNoInFlightContext() {
        HashMap<ReaderContext, Throwable> copy = new HashMap<ReaderContext, Throwable>(ACTIVE_SEARCH_CONTEXTS);
        if (!copy.isEmpty()) {
            throw new AssertionError("There are still [" + copy.size() + "] in-flight contexts. The first one's creation site is listed as the cause of this exception.", (Throwable)copy.values().iterator().next());
        }
    }

    static void addActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.put(context, new RuntimeException(context.toString()));
    }

    static void removeActiveContext(ReaderContext context) {
        ACTIVE_SEARCH_CONTEXTS.remove(context);
    }

    public MockSearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, QueryPhase queryPhase, FetchPhase fetchPhase, CircuitBreakerService circuitBreakerService, Executor indexSearcherExecutor) {
        super(clusterService, indicesService, threadPool, scriptService, bigArrays, queryPhase, fetchPhase, null, circuitBreakerService, indexSearcherExecutor);
    }

    protected void putReaderContext(ReaderContext context) {
        this.onPutContext.accept(context);
        MockSearchService.addActiveContext(context);
        super.putReaderContext(context);
    }

    protected ReaderContext removeReaderContext(long id) {
        ReaderContext removed = super.removeReaderContext(id);
        if (removed != null) {
            MockSearchService.removeActiveContext(removed);
        }
        return removed;
    }

    public void setOnPutContext(Consumer<ReaderContext> onPutContext) {
        this.onPutContext = onPutContext;
    }

    public static class TestPlugin
    extends Plugin {
    }
}

