/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.function.Predicate;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.AbstractWireSerializingTestCase;
import org.opensearch.test.AbstractXContentTestCase;

public abstract class AbstractSerializingTestCase<T extends ToXContent & Writeable>
extends AbstractWireSerializingTestCase<T> {
    public final void testFromXContent() throws IOException {
        AbstractXContentTestCase.xContentTester((CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), this::createXContextTestInstance, this.getToXContentParams(), this::doParseInstance).numberOfTestRuns(20).supportsUnknownFields(this.supportsUnknownFields()).shuffleFieldsExceptions(this.getShuffleFieldsExceptions()).randomFieldsExcludeFilter(this.getRandomFieldsExcludeFilter()).assertEqualsConsumer((x$0, x$1) -> this.assertEqualInstances(x$0, x$1)).assertToXContentEquivalence(this.assertToXContentEquivalence()).test();
    }

    protected abstract T doParseInstance(XContentParser var1) throws IOException;

    protected T createXContextTestInstance(XContentType xContentType) {
        return (T)((ToXContent)this.createTestInstance());
    }

    protected boolean supportsUnknownFields() {
        return false;
    }

    protected Predicate<String> getRandomFieldsExcludeFilter() {
        return field -> false;
    }

    protected String[] getShuffleFieldsExceptions() {
        return Strings.EMPTY_ARRAY;
    }

    protected ToXContent.Params getToXContentParams() {
        return ToXContent.EMPTY_PARAMS;
    }

    protected boolean assertToXContentEquivalence() {
        return true;
    }

    protected Date randomDate() {
        return new Date(AbstractSerializingTestCase.randomLongBetween(0L, 3000000000000L));
    }

    protected Instant randomInstant() {
        return Instant.ofEpochSecond(AbstractSerializingTestCase.randomLongBetween(0L, 3000000000L), AbstractSerializingTestCase.randomLongBetween(0L, 999999999L));
    }
}

