/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Assert;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.XContentTestUtils;
import org.opensearch.test.hamcrest.OpenSearchAssertions;

public abstract class AbstractXContentTestCase<T extends ToXContent>
extends OpenSearchTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    public static <T> XContentTester<T> xContentTester(CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser, Supplier<T> instanceSupplier, CheckedBiConsumer<T, XContentBuilder, IOException> toXContent, CheckedFunction<XContentParser, T, IOException> fromXContent) {
        return new XContentTester<Object>(createParser, x -> instanceSupplier.get(), (testInstance, xContentType) -> {
            try (XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());){
                toXContent.accept(testInstance, (Object)builder);
                BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
                return bytesReference;
            }
        }, fromXContent);
    }

    public static <T extends ToXContent> XContentTester<T> xContentTester(CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser, Supplier<T> instanceSupplier, CheckedFunction<XContentParser, T, IOException> fromXContent) {
        return AbstractXContentTestCase.xContentTester(createParser, instanceSupplier, ToXContent.EMPTY_PARAMS, fromXContent);
    }

    public static <T extends ToXContent> XContentTester<T> xContentTester(CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser, Supplier<T> instanceSupplier, ToXContent.Params toXContentParams, CheckedFunction<XContentParser, T, IOException> fromXContent) {
        return new XContentTester<ToXContent>(createParser, x -> (ToXContent)instanceSupplier.get(), (testInstance, xContentType) -> XContentHelper.toXContent((ToXContent)testInstance, (XContentType)xContentType, (ToXContent.Params)toXContentParams, (boolean)false), fromXContent);
    }

    public static <T extends ToXContent> XContentTester<T> xContentTester(CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser, Function<XContentType, T> instanceSupplier, ToXContent.Params toXContentParams, CheckedFunction<XContentParser, T, IOException> fromXContent) {
        return new XContentTester<T>(createParser, instanceSupplier, (testInstance, xContentType) -> XContentHelper.toXContent((ToXContent)testInstance, (XContentType)xContentType, (ToXContent.Params)toXContentParams, (boolean)false), fromXContent);
    }

    public static <T extends ToXContent> void testFromXContent(int numberOfTestRuns, Supplier<T> instanceSupplier, boolean supportsUnknownFields, String[] shuffleFieldsExceptions, Predicate<String> randomFieldsExcludeFilter, CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParserFunction, CheckedFunction<XContentParser, T, IOException> fromXContent, BiConsumer<T, T> assertEqualsConsumer, boolean assertToXContentEquivalence, ToXContent.Params toXContentParams) throws IOException {
        AbstractXContentTestCase.xContentTester(createParserFunction, instanceSupplier, toXContentParams, fromXContent).numberOfTestRuns(numberOfTestRuns).supportsUnknownFields(supportsUnknownFields).shuffleFieldsExceptions(shuffleFieldsExceptions).randomFieldsExcludeFilter(randomFieldsExcludeFilter).assertEqualsConsumer(assertEqualsConsumer).assertToXContentEquivalence(assertToXContentEquivalence).test();
    }

    public final void testFromXContent() throws IOException {
        AbstractXContentTestCase.testFromXContent(20, this::createTestInstance, this.supportsUnknownFields(), this.getShuffleFieldsExceptions(), this.getRandomFieldsExcludeFilter(), (CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), this::parseInstance, this::assertEqualInstances, this.assertToXContentEquivalence(), this.getToXContentParams());
    }

    protected abstract T createTestInstance();

    private T parseInstance(XContentParser parser) throws IOException {
        T parsedInstance = this.doParseInstance(parser);
        AbstractXContentTestCase.assertNull((Object)parser.nextToken());
        return parsedInstance;
    }

    protected abstract T doParseInstance(XContentParser var1) throws IOException;

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        AbstractXContentTestCase.assertNotSame(newInstance, expectedInstance);
        AbstractXContentTestCase.assertEquals(expectedInstance, newInstance);
        AbstractXContentTestCase.assertEquals((long)expectedInstance.hashCode(), (long)newInstance.hashCode());
    }

    protected boolean assertToXContentEquivalence() {
        return true;
    }

    protected abstract boolean supportsUnknownFields();

    protected Predicate<String> getRandomFieldsExcludeFilter() {
        return field -> false;
    }

    protected String[] getShuffleFieldsExceptions() {
        return Strings.EMPTY_ARRAY;
    }

    protected ToXContent.Params getToXContentParams() {
        return ToXContent.EMPTY_PARAMS;
    }

    static BytesReference insertRandomFieldsAndShuffle(BytesReference xContent, XContentType xContentType, boolean supportsUnknownFields, String[] shuffleFieldsExceptions, Predicate<String> randomFieldsExcludeFilter, CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParserFunction) throws IOException {
        BytesReference withRandomFields = supportsUnknownFields ? XContentTestUtils.insertRandomFields((MediaType)xContentType, xContent, randomFieldsExcludeFilter, AbstractXContentTestCase.random()) : xContent;
        XContentParser parserWithRandonFields = (XContentParser)createParserFunction.apply((Object)XContentFactory.xContent((MediaType)xContentType), (Object)withRandomFields);
        return BytesReference.bytes((XContentBuilder)AbstractXContentTestCase.shuffleXContent(parserWithRandonFields, false, shuffleFieldsExceptions));
    }

    public static class XContentTester<T> {
        private final CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser;
        private final Function<XContentType, T> instanceSupplier;
        private final CheckedBiFunction<T, XContentType, BytesReference, IOException> toXContent;
        private final CheckedFunction<XContentParser, T, IOException> fromXContent;
        private int numberOfTestRuns = 20;
        private boolean supportsUnknownFields = false;
        private String[] shuffleFieldsExceptions = Strings.EMPTY_ARRAY;
        private Predicate<String> randomFieldsExcludeFilter = field -> false;
        private BiConsumer<T, T> assertEqualsConsumer = (expectedInstance, newInstance) -> {
            Assert.assertNotSame((Object)newInstance, (Object)expectedInstance);
            Assert.assertEquals((Object)expectedInstance, (Object)newInstance);
            Assert.assertEquals((long)expectedInstance.hashCode(), (long)newInstance.hashCode());
        };
        private boolean assertToXContentEquivalence = true;

        private XContentTester(CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParser, Function<XContentType, T> instanceSupplier, CheckedBiFunction<T, XContentType, BytesReference, IOException> toXContent, CheckedFunction<XContentParser, T, IOException> fromXContent) {
            this.createParser = createParser;
            this.instanceSupplier = instanceSupplier;
            this.toXContent = toXContent;
            this.fromXContent = fromXContent;
        }

        public void test() throws IOException {
            for (int runs = 0; runs < this.numberOfTestRuns; ++runs) {
                XContentType xContentType = OpenSearchTestCase.randomFrom(XContentType.values());
                T testInstance = this.instanceSupplier.apply(xContentType);
                BytesReference originalXContent = (BytesReference)this.toXContent.apply(testInstance, (Object)xContentType);
                BytesReference shuffledContent = AbstractXContentTestCase.insertRandomFieldsAndShuffle(originalXContent, xContentType, this.supportsUnknownFields, this.shuffleFieldsExceptions, this.randomFieldsExcludeFilter, this.createParser);
                XContentParser parser = (XContentParser)this.createParser.apply((Object)XContentFactory.xContent((MediaType)xContentType), (Object)shuffledContent);
                Object parsed = this.fromXContent.apply((Object)parser);
                this.assertEqualsConsumer.accept(testInstance, parsed);
                if (!this.assertToXContentEquivalence) continue;
                OpenSearchAssertions.assertToXContentEquivalent((BytesReference)this.toXContent.apply(testInstance, (Object)xContentType), (BytesReference)this.toXContent.apply(parsed, (Object)xContentType), (MediaType)xContentType);
            }
        }

        public XContentTester<T> numberOfTestRuns(int numberOfTestRuns) {
            this.numberOfTestRuns = numberOfTestRuns;
            return this;
        }

        public XContentTester<T> supportsUnknownFields(boolean supportsUnknownFields) {
            this.supportsUnknownFields = supportsUnknownFields;
            return this;
        }

        public XContentTester<T> shuffleFieldsExceptions(String[] shuffleFieldsExceptions) {
            this.shuffleFieldsExceptions = shuffleFieldsExceptions;
            return this;
        }

        public XContentTester<T> randomFieldsExcludeFilter(Predicate<String> randomFieldsExcludeFilter) {
            this.randomFieldsExcludeFilter = randomFieldsExcludeFilter;
            return this;
        }

        public XContentTester<T> assertEqualsConsumer(BiConsumer<T, T> assertEqualsConsumer) {
            this.assertEqualsConsumer = assertEqualsConsumer;
            return this;
        }

        public XContentTester<T> assertToXContentEquivalence(boolean assertToXContentEquivalence) {
            this.assertToXContentEquivalence = assertToXContentEquivalence;
            return this;
        }
    }
}

