/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.security.AccessController;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.util.concurrent.ConcurrentCollections;

public class FeatureFlagSetter {
    private static FeatureFlagSetter INSTANCE = null;
    private static final Logger LOGGER = LogManager.getLogger(FeatureFlagSetter.class);
    private final Set<String> flags = ConcurrentCollections.newConcurrentSet();

    private static synchronized FeatureFlagSetter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeatureFlagSetter();
        }
        return INSTANCE;
    }

    public static synchronized void set(String flag) {
        FeatureFlagSetter.getInstance().setFlag(flag);
    }

    public static synchronized void clear() {
        if (INSTANCE != null) {
            INSTANCE.clearAll();
            INSTANCE = null;
        }
    }

    @SuppressForbidden(reason="Enables setting of feature flags")
    private void setFlag(String flag) {
        this.flags.add(flag);
        AccessController.doPrivileged(() -> System.setProperty(flag, "true"));
        LOGGER.info("set feature_flag={}", (Object)flag);
    }

    @SuppressForbidden(reason="Clears the set feature flags")
    private void clearAll() {
        for (String flag : this.flags) {
            AccessController.doPrivileged(() -> System.clearProperty(flag));
        }
        LOGGER.info("unset feature_flags={}", this.flags);
        this.flags.clear();
    }
}

