/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Module;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.Index;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.plugins.Plugin;

public final class MockIndexEventListener {

    public static class TestEventListener
    implements IndexEventListener {
        private volatile IndexEventListener delegate = new IndexEventListener(){};

        public void setNewDelegate(IndexEventListener listener) {
            this.delegate = listener == null ? new IndexEventListener(){} : listener;
        }

        public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
            this.delegate.shardRoutingChanged(indexShard, oldRouting, newRouting);
        }

        public void afterIndexShardCreated(IndexShard indexShard) {
            this.delegate.afterIndexShardCreated(indexShard);
        }

        public void afterIndexShardStarted(IndexShard indexShard) {
            this.delegate.afterIndexShardStarted(indexShard);
        }

        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            this.delegate.beforeIndexShardClosed(shardId, indexShard, indexSettings);
        }

        public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            this.delegate.afterIndexShardClosed(shardId, indexShard, indexSettings);
        }

        public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
            this.delegate.indexShardStateChanged(indexShard, previousState, currentState, reason);
        }

        public void beforeIndexCreated(Index index, Settings indexSettings) {
            this.delegate.beforeIndexCreated(index, indexSettings);
        }

        public void afterIndexCreated(IndexService indexService) {
            this.delegate.afterIndexCreated(indexService);
        }

        public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
            this.delegate.beforeIndexShardCreated(shardId, indexSettings);
        }

        public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
            this.delegate.beforeIndexRemoved(indexService, reason);
        }

        public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
            this.delegate.afterIndexRemoved(index, indexSettings, reason);
        }

        public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
            this.delegate.beforeIndexShardDeleted(shardId, indexSettings);
        }

        public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
            this.delegate.afterIndexShardDeleted(shardId, indexSettings);
        }

        public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
            this.delegate.beforeIndexAddedToCluster(index, indexSettings);
        }
    }

    public static class TestPlugin
    extends Plugin {
        private final TestEventListener listener = new TestEventListener();
        public static final Setting<Boolean> INDEX_FAIL = Setting.boolSetting((String)"index.fail", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});

        public List<Setting<?>> getSettings() {
            return Arrays.asList(INDEX_FAIL);
        }

        public void onIndexModule(IndexModule module) {
            module.addIndexEventListener((IndexEventListener)this.listener);
        }

        public Collection<Module> createGuiceModules() {
            return Collections.singleton(binder -> binder.bind(TestEventListener.class).toInstance((Object)this.listener));
        }
    }
}

