/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.regex.Regex;

public class MockLogAppender
extends AbstractAppender
implements AutoCloseable {
    private static final String COMMON_PREFIX = System.getProperty("opensearch.logger.prefix", "org.opensearch.");
    private final List<LoggingExpectation> expectations = new CopyOnWriteArrayList<LoggingExpectation>();
    private final List<Logger> loggers;

    public static MockLogAppender createForLoggers(Logger ... loggers) throws IllegalAccessException {
        return MockLogAppender.createForLoggers(".*(\n.*)*", loggers);
    }

    public static MockLogAppender createForLoggers(String filter, Logger ... loggers) throws IllegalAccessException {
        MockLogAppender appender = new MockLogAppender(RegexFilter.createFilter((String)filter, (String[])new String[0], (Boolean)false, null, null), Collections.unmodifiableList(Arrays.asList(loggers)));
        appender.start();
        for (Logger logger : loggers) {
            Loggers.addAppender((Logger)logger, (Appender)appender);
        }
        return appender;
    }

    private MockLogAppender(RegexFilter filter, List<Logger> loggers) {
        super("mock", (Filter)filter, null);
        this.loggers = loggers;
    }

    public void addExpectation(LoggingExpectation expectation) {
        this.expectations.add(expectation);
    }

    public void append(LogEvent event) {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.match(event);
        }
    }

    public void assertAllExpectationsMatched() {
        for (LoggingExpectation expectation : this.expectations) {
            expectation.assertMatched();
        }
    }

    @Override
    public void close() {
        for (Logger logger : this.loggers) {
            Loggers.removeAppender((Logger)logger, (Appender)this);
        }
        this.stop();
    }

    private static String getLoggerName(String name) {
        if (name.startsWith("org.opensearch.")) {
            name = name.substring("org.opensearch.".length());
        }
        return COMMON_PREFIX + name;
    }

    public static interface LoggingExpectation {
        public void match(LogEvent var1);

        public void assertMatched();
    }

    public static class PatternSeenEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String pattern;
        volatile boolean saw;

        public PatternSeenEventExpectation(String name, String logger, Level level, String pattern) {
            this.name = name;
            this.logger = logger;
            this.level = level;
            this.pattern = pattern;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && Pattern.matches(this.pattern, event.getMessage().getFormattedMessage())) {
                this.saw = true;
            }
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class ExceptionSeenEventExpectation
    extends SeenEventExpectation {
        private final Class<? extends Exception> clazz;
        private final String exceptionMessage;

        public ExceptionSeenEventExpectation(String name, String logger, Level level, String message, Class<? extends Exception> clazz, String exceptionMessage) {
            super(name, logger, level, message);
            this.clazz = clazz;
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public boolean innerMatch(LogEvent event) {
            return event.getThrown() != null && event.getThrown().getClass() == this.clazz && event.getThrown().getMessage().equals(this.exceptionMessage);
        }
    }

    public static class SeenEventExpectation
    extends AbstractEventExpectation {
        public SeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected to see " + this.name + " but did not"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class UnseenEventExpectation
    extends AbstractEventExpectation {
        public UnseenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected not to see " + this.name + " but did"), (Object)this.saw, (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }

    public static abstract class AbstractEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String message;
        volatile boolean saw;

        public AbstractEventExpectation(String name, String logger, Level level, String message) {
            this.name = name;
            this.logger = MockLogAppender.getLoggerName(logger);
            this.level = level;
            this.message = message;
            this.saw = false;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.innerMatch(event)) {
                if (Regex.isSimpleMatchPattern((String)this.message)) {
                    if (Regex.simpleMatch((String)this.message, (String)event.getMessage().getFormattedMessage())) {
                        this.saw = true;
                    }
                } else if (event.getMessage().getFormattedMessage().contains(this.message)) {
                    this.saw = true;
                }
            }
        }

        public boolean innerMatch(LogEvent event) {
            return true;
        }
    }
}

