/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.disruption.SingleNodeDisruption;

public class BusyClusterManagerServiceDisruption
extends SingleNodeDisruption {
    private final AtomicBoolean active = new AtomicBoolean();
    private final Priority priority;

    public BusyClusterManagerServiceDisruption(Random random, Priority priority) {
        super(random);
        this.priority = priority;
    }

    @Override
    public void startDisrupting() {
        this.disruptedNode = this.cluster.getClusterManagerName();
        String disruptionNodeCopy = this.disruptedNode;
        if (disruptionNodeCopy == null) {
            return;
        }
        ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
        if (clusterService == null) {
            return;
        }
        this.logger.info("making cluster-manager service busy on node [{}] at priority [{}]", (Object)disruptionNodeCopy, (Object)this.priority);
        this.active.set(true);
        this.submitTask(clusterService);
    }

    private void submitTask(final ClusterService clusterService) {
        clusterService.getClusterManagerService().submitStateUpdateTask("service_disruption_block", (ClusterStateTaskConfig)new ClusterStateUpdateTask(this.priority){

            public ClusterState execute(ClusterState currentState) {
                if (BusyClusterManagerServiceDisruption.this.active.get()) {
                    BusyClusterManagerServiceDisruption.this.submitTask(clusterService);
                }
                return currentState;
            }

            public void onFailure(String source, Exception e) {
                BusyClusterManagerServiceDisruption.this.logger.error("unexpected error during disruption", (Throwable)e);
            }
        });
    }

    @Override
    public void stopDisrupting() {
        this.active.set(false);
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

