/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.opensearch.cluster.routing.allocation.FailedShard;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.GatewayAllocator;
import org.opensearch.gateway.PrimaryShardAllocator;
import org.opensearch.gateway.ReplicaShardAllocator;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadata;

public class TestGatewayAllocator
extends GatewayAllocator {
    Map<String, Map<ShardId, ShardRouting>> knownAllocations = new HashMap<String, Map<ShardId, ShardRouting>>();
    DiscoveryNodes currentNodes = DiscoveryNodes.EMPTY_NODES;
    Map<String, ReplicationCheckpoint> shardIdNodeToReplicationCheckPointMap = new HashMap<String, ReplicationCheckpoint>();
    PrimaryShardAllocator primaryShardAllocator = new PrimaryShardAllocator(){

        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            ShardId shardId = shard.shardId();
            Set ignoreNodes = allocation.getIgnoreNodes(shardId);
            Map<DiscoveryNode, TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> foundShards = TestGatewayAllocator.this.knownAllocations.values().stream().flatMap(shardMap -> shardMap.values().stream()).filter(ks -> ks.shardId().equals((Object)shardId)).filter(ks -> !ignoreNodes.contains(ks.currentNodeId())).filter(ks -> TestGatewayAllocator.this.currentNodes.nodeExists(ks.currentNodeId())).collect(Collectors.toMap(routing -> TestGatewayAllocator.this.currentNodes.get(routing.currentNodeId()), routing -> new TransportNodesListGatewayStartedShards.NodeGatewayStartedShards(TestGatewayAllocator.this.currentNodes.get(routing.currentNodeId()), routing.allocationId().getId(), routing.primary(), TestGatewayAllocator.this.getReplicationCheckpoint(shardId, routing.currentNodeId()))));
            return new AsyncShardFetch.FetchResult(shardId, foundShards, ignoreNodes);
        }
    };
    ReplicaShardAllocator replicaShardAllocator = new ReplicaShardAllocator(){

        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetadata.NodeStoreFilesMetadata> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            ShardId shardId = shard.shardId();
            return new AsyncShardFetch.FetchResult(shardId, Collections.emptyMap(), allocation.getIgnoreNodes(shardId));
        }

        protected boolean hasInitiatedFetching(ShardRouting shard) {
            return true;
        }
    };

    private ReplicationCheckpoint getReplicationCheckpoint(ShardId shardId, String nodeName) {
        return this.shardIdNodeToReplicationCheckPointMap.getOrDefault(this.getReplicationCheckPointKey(shardId, nodeName), null);
    }

    public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        this.currentNodes = allocation.nodes();
        allocation.routingNodes().shards(ShardRouting::active).forEach(this::addKnownAllocation);
    }

    public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        this.currentNodes = allocation.nodes();
        for (FailedShard failedShard : failedShards) {
            ShardRouting failedRouting = failedShard.getRoutingEntry();
            Map<ShardId, ShardRouting> nodeAllocations = this.knownAllocations.get(failedRouting.currentNodeId());
            if (nodeAllocations == null) continue;
            nodeAllocations.remove(failedRouting.shardId());
            if (!nodeAllocations.isEmpty()) continue;
            this.knownAllocations.remove(failedRouting.currentNodeId());
        }
    }

    public void beforeAllocation(RoutingAllocation allocation) {
    }

    public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
    }

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        this.currentNodes = allocation.nodes();
        TestGatewayAllocator.innerAllocatedUnassigned((RoutingAllocation)allocation, (PrimaryShardAllocator)this.primaryShardAllocator, (ReplicaShardAllocator)this.replicaShardAllocator, (ShardRouting)shardRouting, (ExistingShardsAllocator.UnassignedAllocationHandler)unassignedAllocationHandler);
    }

    public void addKnownAllocation(ShardRouting shard) {
        this.knownAllocations.computeIfAbsent(shard.currentNodeId(), id -> new HashMap()).put(shard.shardId(), shard);
    }

    public String getReplicationCheckPointKey(ShardId shardId, String nodeName) {
        return shardId.toString() + "_" + nodeName;
    }

    public void addReplicationCheckpoint(ShardId shardId, String nodeName, ReplicationCheckpoint replicationCheckpoint) {
        this.shardIdNodeToReplicationCheckPointMap.putIfAbsent(this.getReplicationCheckPointKey(shardId, nodeName), replicationCheckpoint);
    }
}

