/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.hamcrest;

import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.CombinableMatcher;
import org.opensearch.search.SearchHit;

public class OpenSearchMatchers {

    public static class HasPropertyLambdaMatcher<T, V>
    extends FeatureMatcher<T, V> {
        private final Function<? super T, ? extends V> property;

        private HasPropertyLambdaMatcher(Matcher<? super V> subMatcher, Function<? super T, ? extends V> property) {
            super(subMatcher, "object with", "lambda");
            this.property = property;
        }

        protected V featureValueOf(T actual) {
            return this.property.apply(actual);
        }

        public static <T, V> CombinableMatcher<T> hasProperty(Function<? super T, ? extends V> property, Matcher<V> valueMatcher) {
            return new CombinableMatcher(new HasPropertyLambdaMatcher<T, V>(valueMatcher, property));
        }
    }

    public static class SearchHitHasScoreMatcher
    extends TypeSafeMatcher<SearchHit> {
        private float score;

        public SearchHitHasScoreMatcher(float score) {
            this.score = score;
        }

        protected boolean matchesSafely(SearchHit searchHit) {
            return searchHit.getScore() == this.score;
        }

        public void describeMismatchSafely(SearchHit searchHit, Description mismatchDescription) {
            mismatchDescription.appendText(" was ").appendValue((Object)Float.valueOf(searchHit.getScore()));
        }

        public void describeTo(Description description) {
            description.appendText("searchHit score should be ").appendValue((Object)Float.valueOf(this.score));
        }
    }

    public static class SearchHitHasIndexMatcher
    extends TypeSafeMatcher<SearchHit> {
        private String index;

        public SearchHitHasIndexMatcher(String index) {
            this.index = index;
        }

        public boolean matchesSafely(SearchHit searchHit) {
            return searchHit.getIndex().equals(this.index);
        }

        public void describeMismatchSafely(SearchHit searchHit, Description mismatchDescription) {
            mismatchDescription.appendText(" was ").appendValue((Object)searchHit.getIndex());
        }

        public void describeTo(Description description) {
            description.appendText("searchHit index should be ").appendValue((Object)this.index);
        }
    }

    public static class SearchHitHasIdMatcher
    extends TypeSafeMatcher<SearchHit> {
        private String id;

        public SearchHitHasIdMatcher(String id) {
            this.id = id;
        }

        protected boolean matchesSafely(SearchHit searchHit) {
            return searchHit.getId().equals(this.id);
        }

        public void describeMismatchSafely(SearchHit searchHit, Description mismatchDescription) {
            mismatchDescription.appendText(" was ").appendValue((Object)searchHit.getId());
        }

        public void describeTo(Description description) {
            description.appendText("searchHit id should be ").appendValue((Object)this.id);
        }
    }
}

