/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.junit.listeners;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.opensearch.common.logging.Loggers;
import org.opensearch.test.junit.annotations.TestIssueLogging;
import org.opensearch.test.junit.annotations.TestLogging;

public class LoggingListener
extends RunListener {
    private Map<String, String> previousLoggingMap;
    private Map<String, String> previousClassLoggingMap;
    private Map<String, String> previousPackageLoggingMap;

    public void testRunStarted(Description description) throws Exception {
        Package testClassPackage = description.getTestClass().getPackage();
        this.previousPackageLoggingMap = this.processTestLogging(testClassPackage != null ? testClassPackage.getAnnotation(TestLogging.class) : null, testClassPackage != null ? testClassPackage.getAnnotation(TestIssueLogging.class) : null);
        this.previousClassLoggingMap = this.processTestLogging((TestLogging)description.getAnnotation(TestLogging.class), (TestIssueLogging)description.getAnnotation(TestIssueLogging.class));
    }

    public void testRunFinished(Result result) throws Exception {
        this.previousClassLoggingMap = this.reset(this.previousClassLoggingMap);
        this.previousPackageLoggingMap = this.reset(this.previousPackageLoggingMap);
    }

    public void testStarted(Description description) throws Exception {
        TestLogging testLogging = (TestLogging)description.getAnnotation(TestLogging.class);
        TestIssueLogging testIssueLogging = (TestIssueLogging)description.getAnnotation(TestIssueLogging.class);
        this.previousLoggingMap = this.processTestLogging(testLogging, testIssueLogging);
    }

    public void testFinished(Description description) throws Exception {
        this.previousLoggingMap = this.reset(this.previousLoggingMap);
    }

    private static Logger resolveLogger(String loggerName) {
        if (loggerName.equalsIgnoreCase("_root")) {
            return LogManager.getRootLogger();
        }
        return LogManager.getLogger((String)loggerName);
    }

    private Map<String, String> processTestLogging(TestLogging testLogging, TestIssueLogging testIssueLogging) {
        Logger logger;
        Map<String, String> testLoggingMap = LoggingListener.getLoggersAndLevelsFromAnnotation(testLogging);
        Map<String, String> testIssueLoggingMap = LoggingListener.getLoggersAndLevelsFromAnnotation(testIssueLogging);
        HashSet<String> testLoggingKeys = new HashSet<String>(testLoggingMap.keySet());
        testLoggingKeys.retainAll(testIssueLoggingMap.keySet());
        if (!testLoggingKeys.isEmpty()) {
            throw new IllegalArgumentException("found intersection " + testLoggingKeys + " between TestLogging and TestIssueLogging");
        }
        TreeMap<String, String> loggingLevels = new TreeMap<String, String>(Stream.concat(testLoggingMap.entrySet().stream(), testIssueLoggingMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        TreeMap<String, String> existing = new TreeMap<String, String>();
        for (Map.Entry entry : loggingLevels.entrySet()) {
            logger = LoggingListener.resolveLogger((String)entry.getKey());
            existing.put((String)entry.getKey(), logger.getLevel().toString());
        }
        for (Map.Entry entry : loggingLevels.entrySet()) {
            logger = LoggingListener.resolveLogger((String)entry.getKey());
            Loggers.setLevel((Logger)logger, (String)((String)entry.getValue()));
        }
        return existing;
    }

    private static Map<String, String> getLoggersAndLevelsFromAnnotation(TestLogging testLogging) {
        if (testLogging == null) {
            return Collections.emptyMap();
        }
        return LoggingListener.getLoggersAndLevelsFromAnnotationValue(testLogging.value());
    }

    private static Map<String, String> getLoggersAndLevelsFromAnnotation(TestIssueLogging testIssueLogging) {
        if (testIssueLogging == null) {
            return Collections.emptyMap();
        }
        return LoggingListener.getLoggersAndLevelsFromAnnotationValue(testIssueLogging.value());
    }

    private static Map<String, String> getLoggersAndLevelsFromAnnotationValue(String value) {
        String[] loggersAndLevels;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String loggerAndLevel : loggersAndLevels = value.split(",")) {
            String[] loggerAndLevelArray = loggerAndLevel.split(":");
            if (loggerAndLevelArray.length != 2) {
                throw new IllegalArgumentException("invalid test logging annotation [" + loggerAndLevel + "]");
            }
            map.put(loggerAndLevelArray[0], loggerAndLevelArray[1]);
        }
        return map;
    }

    private Map<String, String> reset(Map<String, String> map) {
        for (Map.Entry<String, String> previousLogger : map.entrySet()) {
            Logger logger = LoggingListener.resolveLogger(previousLogger.getKey());
            Loggers.setLevel((Logger)logger, (String)previousLogger.getValue());
        }
        return Collections.emptyMap();
    }
}

