/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.client.NodeSelector;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.test.rest.yaml.ClientYamlTestClient;
import org.opensearch.test.rest.yaml.ClientYamlTestResponse;
import org.opensearch.test.rest.yaml.ClientYamlTestResponseException;
import org.opensearch.test.rest.yaml.Stash;

public class ClientYamlTestExecutionContext {
    private static final Logger logger = LogManager.getLogger(ClientYamlTestExecutionContext.class);
    private static final XContentType[] STREAMING_CONTENT_TYPES = new XContentType[]{XContentType.JSON, XContentType.SMILE};
    private final Stash stash = new Stash();
    private final ClientYamlTestClient clientYamlTestClient;
    private ClientYamlTestResponse response;
    private final boolean randomizeContentType;

    ClientYamlTestExecutionContext(ClientYamlTestClient clientYamlTestClient, boolean randomizeContentType) {
        this.clientYamlTestClient = clientYamlTestClient;
        this.randomizeContentType = randomizeContentType;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException {
        return this.callApi(apiName, params, bodies, headers, NodeSelector.ANY);
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, List<Map<String, Object>> bodies, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        Object responseBody;
        ClientYamlTestResponse clientYamlTestResponse;
        HashMap<String, String> requestParams = new HashMap<String, String>(params);
        requestParams.putIfAbsent("error_trace", "true");
        for (Map.Entry entry2 : requestParams.entrySet()) {
            if (!this.stash.containsStashedValue(entry2.getValue())) continue;
            entry2.setValue(this.stash.getValue((String)entry2.getValue()).toString());
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>(headers);
        for (Map.Entry entry : requestHeaders.entrySet()) {
            if (!this.stash.containsStashedValue(entry.getValue())) continue;
            entry.setValue(this.stash.getValue((String)entry.getValue()).toString());
        }
        HttpEntity entity = this.createEntity(bodies, requestHeaders);
        try {
            clientYamlTestResponse = this.response = this.callApiInternal(apiName, requestParams, entity, requestHeaders, nodeSelector);
            responseBody = this.response != null ? this.response.getBody() : null;
        }
        catch (ClientYamlTestResponseException clientYamlTestResponseException) {
            try {
                this.response = clientYamlTestResponseException.getRestTestResponse();
                throw clientYamlTestResponseException;
            }
            catch (Throwable throwable) {
                Object responseBody2 = this.response != null ? this.response.getBody() : null;
                this.stash.stashValue("body", responseBody2);
                throw throwable;
            }
        }
        this.stash.stashValue("body", responseBody);
        return clientYamlTestResponse;
    }

    private HttpEntity createEntity(List<Map<String, Object>> bodies, Map<String, String> headers) throws IOException {
        if (bodies.isEmpty()) {
            return null;
        }
        if (bodies.size() == 1) {
            XContentType xContentType = this.getContentType(headers, XContentType.values());
            BytesRef bytesRef = this.bodyAsBytesRef(bodies.get(0), xContentType);
            return new ByteArrayEntity(bytesRef.bytes, bytesRef.offset, bytesRef.length, ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)StandardCharsets.UTF_8));
        }
        XContentType xContentType = this.getContentType(headers, STREAMING_CONTENT_TYPES);
        ArrayList<BytesRef> bytesRefList = new ArrayList<BytesRef>(bodies.size());
        int totalBytesLength = 0;
        for (Map<String, Object> body : bodies) {
            BytesRef bytesRef = this.bodyAsBytesRef(body, xContentType);
            bytesRefList.add(bytesRef);
            totalBytesLength += bytesRef.length - bytesRef.offset + 1;
        }
        byte[] bytes = new byte[totalBytesLength];
        int position = 0;
        for (BytesRef bytesRef : bytesRefList) {
            for (int i = bytesRef.offset; i < bytesRef.length; ++i) {
                bytes[position++] = bytesRef.bytes[i];
            }
            bytes[position++] = xContentType.xContent().streamSeparator();
        }
        return new ByteArrayEntity(bytes, ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)StandardCharsets.UTF_8));
    }

    private XContentType getContentType(Map<String, String> headers, XContentType[] supportedContentTypes) {
        XContentType xContentType = null;
        String contentType = headers.get("Content-Type");
        if (contentType != null) {
            xContentType = XContentType.fromMediaType((String)contentType);
        }
        if (xContentType != null) {
            return xContentType;
        }
        if (this.randomizeContentType) {
            return (XContentType)RandomizedTest.randomFrom((Object[])supportedContentTypes);
        }
        return XContentType.JSON;
    }

    private BytesRef bodyAsBytesRef(Map<String, Object> bodyAsMap, XContentType xContentType) throws IOException {
        Map<String, Object> finalBodyAsMap = this.stash.replaceStashedValues(bodyAsMap);
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);){
            BytesRef bytesRef = BytesReference.bytes((XContentBuilder)builder.map(finalBodyAsMap)).toBytesRef();
            return bytesRef;
        }
    }

    ClientYamlTestResponse callApiInternal(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        return this.clientYamlTestClient.callApi(apiName, params, entity, headers, nodeSelector);
    }

    public Object response(String path) throws IOException {
        return this.response.evaluate(path, this.stash);
    }

    public void clear() {
        logger.debug("resetting client, response and stash");
        this.response = null;
        this.stash.clear();
    }

    public Stash stash() {
        return this.stash;
    }

    public Version esVersion() {
        return this.clientYamlTestClient.getEsVersion();
    }

    public Version clusterManagerVersion() {
        return this.clientYamlTestClient.getClusterManagerVersion();
    }

    @Deprecated
    public Version masterVersion() {
        return this.clusterManagerVersion();
    }
}

