/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.section.Assertion;
import org.opensearch.test.rest.yaml.section.ParserUtils;

public class GreaterThanEqualToAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(GreaterThanEqualToAssertion.class);

    public static GreaterThanEqualToAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        if (!(stringObjectTuple.v2() instanceof Comparable)) {
            throw new IllegalArgumentException("gte section can only be used with objects that support natural ordering, found " + stringObjectTuple.v2().getClass().getSimpleName());
        }
        return new GreaterThanEqualToAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public GreaterThanEqualToAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] is greater than or equal to [{}] (field: [{}])", actualValue, expectedValue, (Object)this.getField());
        Assert.assertThat((String)("value of [" + this.getField() + "] is not comparable (got [" + this.safeClass(actualValue) + "])"), (Object)actualValue, (Matcher)Matchers.instanceOf(Comparable.class));
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not comparable (got [" + expectedValue.getClass() + "])"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Comparable.class));
        try {
            Assert.assertThat((String)this.errorMessage(), (Object)((Comparable)actualValue), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)((Comparable)expectedValue)));
        }
        catch (ClassCastException e) {
            Assert.fail((String)("cast error while checking (" + this.errorMessage() + "): " + e));
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] is not greater than or equal to [" + this.getExpectedValue() + "]";
    }
}

