/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.store;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestRuleMarkFailure;
import org.junit.Assert;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.FsDirectoryFactory;
import org.opensearch.index.store.Store;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.OpenSearchTestCase;

public class MockFSDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final List<IndexModule.Type> FILE_SYSTEM_BASED_STORE_TYPES = Arrays.stream(IndexModule.Type.values()).filter(t -> !(t == IndexModule.Type.REMOTE_SNAPSHOT)).collect(Collectors.toUnmodifiableList());
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate_on_open", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Boolean> CRASH_INDEX_SETTING = Setting.boolSetting((String)"index.store.mock.random.crash_index", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});

    public Directory newDirectory(IndexSettings idxSettings, ShardPath path) throws IOException {
        Settings indexSettings = idxSettings.getSettings();
        Random random = new Random((Long)idxSettings.getValue(OpenSearchIntegTestCase.INDEX_TEST_SEED_SETTING));
        return this.wrap(this.randomDirectoryService(random, idxSettings, path), random, indexSettings, path.getShardId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIndex(Logger logger, Store store, ShardId shardId) {
        if (store.tryIncRef()) {
            logger.info("start check index");
            try {
                Directory dir = store.directory();
                if (!Lucene.indexExists((Directory)dir)) {
                    return;
                }
                try {
                    BytesStreamOutput os = new BytesStreamOutput();
                    PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
                    CheckIndex.Status status = store.checkIndex(out);
                    out.flush();
                    if (!status.clean) {
                        IOException failure = new IOException("failed to check index for shard " + shardId + ";index files [" + Arrays.toString(dir.listAll()) + "] os [" + os.bytes().utf8ToString() + "]");
                        OpenSearchTestCase.checkIndexFailures.add(failure);
                        throw failure;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
                    }
                }
                catch (LockObtainFailedException e) {
                    IllegalStateException failure = new IllegalStateException("IndexWriter is still open on shard " + shardId, e);
                    OpenSearchTestCase.checkIndexFailures.add(failure);
                    throw failure;
                }
            }
            catch (Exception e) {
                logger.warn("failed to check index", (Throwable)e);
            }
            finally {
                logger.info("end check index");
                store.decRef();
            }
        }
    }

    private Directory wrap(Directory dir, Random random, Settings indexSettings, ShardId shardId) {
        double randomIOExceptionRate = (Double)RANDOM_IO_EXCEPTION_RATE_SETTING.get(indexSettings);
        double randomIOExceptionRateOnOpen = (Double)RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING.get(indexSettings);
        random.nextInt(shardId.getId() + 1);
        MockDirectoryWrapper.Throttling throttle = MockDirectoryWrapper.Throttling.NEVER;
        boolean crashIndex = (Boolean)CRASH_INDEX_SETTING.get(indexSettings);
        OpenSearchMockDirectoryWrapper w = new OpenSearchMockDirectoryWrapper(random, dir, crashIndex);
        w.setRandomIOExceptionRate(randomIOExceptionRate);
        w.setRandomIOExceptionRateOnOpen(randomIOExceptionRateOnOpen);
        w.setThrottling(throttle);
        w.setCheckIndexOnClose(false);
        w.setAssertNoDeleteOpenFile(false);
        w.setUseSlowOpenClosers(false);
        LuceneTestCase.closeAfterSuite((Closeable)new CloseableDirectory((BaseDirectoryWrapper)w));
        return w;
    }

    private Directory randomDirectoryService(Random random, IndexSettings indexSettings, ShardPath path) throws IOException {
        IndexMetadata build = IndexMetadata.builder((IndexMetadata)indexSettings.getIndexMetadata()).settings(Settings.builder().put(indexSettings.getIndexMetadata().getSettings()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), ((IndexModule.Type)RandomPicks.randomFrom((Random)random, FILE_SYSTEM_BASED_STORE_TYPES)).getSettingsKey())).build();
        IndexSettings newIndexSettings = new IndexSettings(build, indexSettings.getNodeSettings());
        return new FsDirectoryFactory().newDirectory(newIndexSettings, path);
    }

    public static final class OpenSearchMockDirectoryWrapper
    extends MockDirectoryWrapper {
        private final boolean crash;

        public OpenSearchMockDirectoryWrapper(Random random, Directory delegate, boolean crash) {
            super(random, delegate);
            this.crash = crash;
        }

        public synchronized void crash() throws IOException {
            if (this.crash) {
                super.crash();
            }
        }

        public Set<String> getPendingDeletions() throws IOException {
            return this.in.getPendingDeletions();
        }
    }

    static final class CloseableDirectory
    implements Closeable {
        private final BaseDirectoryWrapper dir;
        private final TestRuleMarkFailure failureMarker;

        CloseableDirectory(BaseDirectoryWrapper dir) {
            this.dir = dir;
            this.failureMarker = OpenSearchTestCase.getSuiteFailureMarker();
        }

        @Override
        public void close() {
            if (this.failureMarker.wasSuccessful() && this.dir.isOpen()) {
                Assert.fail((String)("Directory not closed: " + this.dir));
            }
        }
    }
}

