/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service.applicationtemplates;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.opensearch.cluster.applicationtemplates.SystemTemplate;
import org.opensearch.cluster.applicationtemplates.SystemTemplateLoader;
import org.opensearch.cluster.applicationtemplates.SystemTemplateMetadata;
import org.opensearch.cluster.applicationtemplates.SystemTemplateRepository;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesPlugin;
import org.opensearch.cluster.applicationtemplates.TemplateRepositoryMetadata;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.plugins.Plugin;

public class TestSystemTemplatesRepositoryPlugin
extends Plugin
implements SystemTemplatesPlugin {
    private final SystemTemplateMetadata templateMetadata = SystemTemplateMetadata.fromComponentTemplateInfo((String)"dummy", (long)1L);
    private final TemplateRepositoryMetadata repoMetadata = new TemplateRepositoryMetadata("test", 1L);
    private final SystemTemplate systemTemplate = new SystemTemplate(BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap("content".getBytes(StandardCharsets.UTF_8))), this.templateMetadata, this.repoMetadata);

    public SystemTemplateRepository loadRepository() throws IOException {
        return new SystemTemplateRepository(){

            public TemplateRepositoryMetadata metadata() {
                return TestSystemTemplatesRepositoryPlugin.this.repoMetadata;
            }

            public List<SystemTemplateMetadata> listTemplates() throws IOException {
                return List.of(TestSystemTemplatesRepositoryPlugin.this.templateMetadata);
            }

            public SystemTemplate getTemplate(SystemTemplateMetadata template) throws IOException {
                return TestSystemTemplatesRepositoryPlugin.this.systemTemplate;
            }

            public void close() throws Exception {
            }
        };
    }

    public SystemTemplateLoader loaderFor(SystemTemplateMetadata templateMetadata) {
        return new SystemTemplateLoader(){

            public boolean loadTemplate(SystemTemplate template) throws IOException {
                assert (template.templateMetadata() == TestSystemTemplatesRepositoryPlugin.this.templateMetadata);
                assert (template.repositoryMetadata() == TestSystemTemplatesRepositoryPlugin.this.repoMetadata);
                assert (template.templateContent() == TestSystemTemplatesRepositoryPlugin.this.systemTemplate.templateContent());
                return true;
            }
        };
    }
}

