/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import java.util.HashSet;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.test.OpenSearchTestCase;

public final class RandomCreateIndexGenerator {
    private RandomCreateIndexGenerator() {
    }

    public static CreateIndexRequest randomCreateIndexRequest() throws IOException {
        String index = OpenSearchTestCase.randomAlphaOfLength(5);
        CreateIndexRequest request = new CreateIndexRequest(index);
        RandomCreateIndexGenerator.randomAliases(request);
        if (OpenSearchTestCase.randomBoolean()) {
            request.mapping(RandomCreateIndexGenerator.randomMapping());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            request.settings(RandomCreateIndexGenerator.randomIndexSettings());
        }
        return request;
    }

    public static Settings randomIndexSettings() {
        Settings.Builder builder = Settings.builder();
        if (OpenSearchTestCase.randomBoolean()) {
            int numberOfShards = OpenSearchTestCase.randomIntBetween(1, 10);
            builder.put("index.number_of_shards", numberOfShards);
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int numberOfReplicas = OpenSearchTestCase.randomIntBetween(1, 10);
            builder.put("index.number_of_replicas", numberOfReplicas);
        }
        return builder.build();
    }

    public static XContentBuilder randomMapping() throws IOException {
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)OpenSearchTestCase.randomFrom(XContentType.values())));
        builder.startObject();
        RandomCreateIndexGenerator.randomMappingFields(builder, true);
        builder.endObject();
        return builder;
    }

    public static void randomMappingFields(XContentBuilder builder, boolean allowObjectField) throws IOException {
        builder.startObject("properties");
        int fieldsNo = OpenSearchTestCase.randomIntBetween(0, 5);
        HashSet<String> uniqueFields = new HashSet<String>();
        while (uniqueFields.size() < fieldsNo) {
            uniqueFields.add(OpenSearchTestCase.randomAlphaOfLength(5));
        }
        for (String uniqueField : uniqueFields) {
            builder.startObject(uniqueField);
            if (allowObjectField && OpenSearchTestCase.randomBoolean()) {
                RandomCreateIndexGenerator.randomMappingFields(builder, false);
            } else {
                builder.field("type", "text");
            }
            builder.endObject();
        }
        builder.endObject();
    }

    public static void randomAliases(CreateIndexRequest request) {
        int aliasesNo = OpenSearchTestCase.randomIntBetween(0, 2);
        for (int i = 0; i < aliasesNo; ++i) {
            request.alias(RandomCreateIndexGenerator.randomAlias());
        }
    }

    public static Alias randomAlias() {
        Alias alias = new Alias(OpenSearchTestCase.randomAlphaOfLength(5));
        if (OpenSearchTestCase.randomBoolean()) {
            if (OpenSearchTestCase.randomBoolean()) {
                alias.routing(OpenSearchTestCase.randomAlphaOfLength(5));
            } else {
                if (OpenSearchTestCase.randomBoolean()) {
                    alias.indexRouting(OpenSearchTestCase.randomAlphaOfLength(5));
                }
                if (OpenSearchTestCase.randomBoolean()) {
                    alias.searchRouting(OpenSearchTestCase.randomAlphaOfLength(5));
                }
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            alias.filter("{\"term\":{\"year\":2016}}");
        }
        if (OpenSearchTestCase.randomBoolean()) {
            alias.writeIndex(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        return alias;
    }
}

